<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_EntfernungZu StructType
 * Meta information extracted from the WSDL
 * - documentation: Klasse zur Abbildung der Entfernung zu dem Gegenstand, der durch die Gegenstandsrolle identifiziert wird.
 * @subpackage Structs
 */
class CT_EntfernungZu extends CT_Gegenstandsrolle
{
    /**
     * The Entfernung
     * Meta information extracted from the WSDL
     * - documentation: Wert der Entfernung.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Entfernung;
    /**
     * The Werteinheit
     * Meta information extracted from the WSDL
     * - documentation: Werteinheit der Entfernung.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Werteinheit;
    /**
     * Constructor method for CT_EntfernungZu
     * @uses CT_EntfernungZu::setEntfernung()
     * @uses CT_EntfernungZu::setWerteinheit()
     * @param int $entfernung
     * @param string $werteinheit
     */
    public function __construct($entfernung = null, $werteinheit = null)
    {
        $this
            ->setEntfernung($entfernung)
            ->setWerteinheit($werteinheit);
    }
    /**
     * Get Entfernung value
     * @return int|null
     */
    public function getEntfernung()
    {
        return $this->Entfernung;
    }
    /**
     * Set Entfernung value
     * @param int $entfernung
     * @return \BiPRO\StructType\CT_EntfernungZu
     */
    public function setEntfernung($entfernung = null)
    {
        // validation for constraint: int
        if (!is_null($entfernung) && !(is_int($entfernung) || ctype_digit($entfernung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entfernung, true), gettype($entfernung)), __LINE__);
        }
        $this->Entfernung = $entfernung;
        return $this;
    }
    /**
     * Get Werteinheit value
     * @return string|null
     */
    public function getWerteinheit()
    {
        return $this->Werteinheit;
    }
    /**
     * Set Werteinheit value
     * @uses \BiPRO\EnumType\ST_Werteinheit::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Werteinheit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $werteinheit
     * @return \BiPRO\StructType\CT_EntfernungZu
     */
    public function setWerteinheit($werteinheit = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Werteinheit::valueIsValid($werteinheit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Werteinheit', is_array($werteinheit) ? implode(', ', $werteinheit) : var_export($werteinheit, true), implode(', ', \BiPRO\EnumType\ST_Werteinheit::getValidValues())), __LINE__);
        }
        $this->Werteinheit = $werteinheit;
        return $this;
    }
}
