<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Elementarprodukt StructType
 * Meta information extracted from the WSDL
 * - documentation: Unterste Ebene der Produkthierarchie gemaess VAA-Modell. Kleinste tariefierbare Einheit. Spartenspezifisch abzuleiten und zu benennen (z.B. Deckung, Tarif, etc.).
 * @subpackage Structs
 */
abstract class CT_Elementarprodukt extends CT_Produktbaustein
{
    /**
     * The Kennung
     * Meta information extracted from the WSDL
     * - documentation: Erfolgt die Identifizierung eines Elementarproduktes mittels einer technischen Kennung (=technische Bezeichnung des Elementarprodukts), MUSS hierfür das Attribut Kennung benutzt werden. | Datentyp um die technische Kennung des
     * Elementarproduktes als String im Datenmodell abzulegen. Hier dürfen Tarifgenerationen abgelegt werden. Da es sich um einen String handelt werden keine vollständigen Listen von Elementarproduktkennungen veröffentlicht.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Kennung;
    /**
     * The Dynamik
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Dynamik[]
     */
    public $Dynamik;
    /**
     * The VersicherungssummeOderLeistung
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_VersicherungssummeOderLeistung[]
     */
    public $VersicherungssummeOderLeistung;
    /**
     * The Selbstbeteiligung
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Selbstbeteiligung[]
     */
    public $Selbstbeteiligung;
    /**
     * The Klausel
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Klausel[]
     */
    public $Klausel;
    /**
     * The Bezugsrecht
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Bezugsrecht[]
     */
    public $Bezugsrecht;
    /**
     * The Leistungsausschluss
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Leistungsausschluss[]
     */
    public $Leistungsausschluss;
    /**
     * The FondsPortfolio
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_FondsPortfolio[]
     */
    public $FondsPortfolio;
    /**
     * The KfzZusatzVersicherung
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_KfzZusatzVersicherung[]
     */
    public $KfzZusatzVersicherung;
    /**
     * The Geltungsbereich
     * Meta information extracted from the WSDL
     * - documentation: Geltungsbereich, für den das Elementarprodukt Deckung gewährt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Geltungsbereich;
    /**
     * Constructor method for CT_Elementarprodukt
     * @uses CT_Elementarprodukt::setKennung()
     * @uses CT_Elementarprodukt::setDynamik()
     * @uses CT_Elementarprodukt::setVersicherungssummeOderLeistung()
     * @uses CT_Elementarprodukt::setSelbstbeteiligung()
     * @uses CT_Elementarprodukt::setKlausel()
     * @uses CT_Elementarprodukt::setBezugsrecht()
     * @uses CT_Elementarprodukt::setLeistungsausschluss()
     * @uses CT_Elementarprodukt::setFondsPortfolio()
     * @uses CT_Elementarprodukt::setKfzZusatzVersicherung()
     * @uses CT_Elementarprodukt::setGeltungsbereich()
     * @param string $kennung
     * @param \BiPRO\StructType\CT_Dynamik[] $dynamik
     * @param \BiPRO\StructType\CT_VersicherungssummeOderLeistung[] $versicherungssummeOderLeistung
     * @param \BiPRO\StructType\CT_Selbstbeteiligung[] $selbstbeteiligung
     * @param \BiPRO\StructType\CT_Klausel[] $klausel
     * @param \BiPRO\StructType\CT_Bezugsrecht[] $bezugsrecht
     * @param \BiPRO\StructType\CT_Leistungsausschluss[] $leistungsausschluss
     * @param \BiPRO\StructType\CT_FondsPortfolio[] $fondsPortfolio
     * @param \BiPRO\StructType\CT_KfzZusatzVersicherung[] $kfzZusatzVersicherung
     * @param string $geltungsbereich
     */
    public function __construct($kennung = null, array $dynamik = array(), array $versicherungssummeOderLeistung = array(), array $selbstbeteiligung = array(), array $klausel = array(), array $bezugsrecht = array(), array $leistungsausschluss = array(), array $fondsPortfolio = array(), array $kfzZusatzVersicherung = array(), $geltungsbereich = null)
    {
        $this
            ->setKennung($kennung)
            ->setDynamik($dynamik)
            ->setVersicherungssummeOderLeistung($versicherungssummeOderLeistung)
            ->setSelbstbeteiligung($selbstbeteiligung)
            ->setKlausel($klausel)
            ->setBezugsrecht($bezugsrecht)
            ->setLeistungsausschluss($leistungsausschluss)
            ->setFondsPortfolio($fondsPortfolio)
            ->setKfzZusatzVersicherung($kfzZusatzVersicherung)
            ->setGeltungsbereich($geltungsbereich);
    }
    /**
     * Get Kennung value
     * @return string|null
     */
    public function getKennung()
    {
        return $this->Kennung;
    }
    /**
     * Set Kennung value
     * @param string $kennung
     * @return \BiPRO\StructType\CT_Elementarprodukt
     */
    public function setKennung($kennung = null)
    {
        // validation for constraint: string
        if (!is_null($kennung) && !is_string($kennung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kennung, true), gettype($kennung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($kennung) && mb_strlen($kennung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($kennung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($kennung) && mb_strlen($kennung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($kennung)), __LINE__);
        }
        $this->Kennung = $kennung;
        return $this;
    }
    /**
     * Get Dynamik value
     * @return \BiPRO\StructType\CT_Dynamik[]|null
     */
    public function getDynamik()
    {
        return $this->Dynamik;
    }
    /**
     * This method is responsible for validating the values passed to the setDynamik method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDynamik method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDynamikForArrayConstraintsFromSetDynamik(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_ElementarproduktDynamikItem) {
            // validation for constraint: itemType
            if (!$cT_ElementarproduktDynamikItem instanceof \BiPRO\StructType\CT_Dynamik) {
                $invalidValues[] = is_object($cT_ElementarproduktDynamikItem) ? get_class($cT_ElementarproduktDynamikItem) : sprintf('%s(%s)', gettype($cT_ElementarproduktDynamikItem), var_export($cT_ElementarproduktDynamikItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Dynamik property can only contain items of type \BiPRO\StructType\CT_Dynamik, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Dynamik value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Dynamik[] $dynamik
     * @return \BiPRO\StructType\CT_Elementarprodukt
     */
    public function setDynamik(array $dynamik = array())
    {
        // validation for constraint: array
        if ('' !== ($dynamikArrayErrorMessage = self::validateDynamikForArrayConstraintsFromSetDynamik($dynamik))) {
            throw new \InvalidArgumentException($dynamikArrayErrorMessage, __LINE__);
        }
        $this->Dynamik = $dynamik;
        return $this;
    }
    /**
     * Add item to Dynamik value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Dynamik $item
     * @return \BiPRO\StructType\CT_Elementarprodukt
     */
    public function addToDynamik(\BiPRO\StructType\CT_Dynamik $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Dynamik) {
            throw new \InvalidArgumentException(sprintf('The Dynamik property can only contain items of type \BiPRO\StructType\CT_Dynamik, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Dynamik[] = $item;
        return $this;
    }
    /**
     * Get VersicherungssummeOderLeistung value
     * @return \BiPRO\StructType\CT_VersicherungssummeOderLeistung[]|null
     */
    public function getVersicherungssummeOderLeistung()
    {
        return $this->VersicherungssummeOderLeistung;
    }
    /**
     * This method is responsible for validating the values passed to the setVersicherungssummeOderLeistung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVersicherungssummeOderLeistung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVersicherungssummeOderLeistungForArrayConstraintsFromSetVersicherungssummeOderLeistung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_ElementarproduktVersicherungssummeOderLeistungItem) {
            // validation for constraint: itemType
            if (!$cT_ElementarproduktVersicherungssummeOderLeistungItem instanceof \BiPRO\StructType\CT_VersicherungssummeOderLeistung) {
                $invalidValues[] = is_object($cT_ElementarproduktVersicherungssummeOderLeistungItem) ? get_class($cT_ElementarproduktVersicherungssummeOderLeistungItem) : sprintf('%s(%s)', gettype($cT_ElementarproduktVersicherungssummeOderLeistungItem), var_export($cT_ElementarproduktVersicherungssummeOderLeistungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VersicherungssummeOderLeistung property can only contain items of type \BiPRO\StructType\CT_VersicherungssummeOderLeistung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VersicherungssummeOderLeistung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_VersicherungssummeOderLeistung[] $versicherungssummeOderLeistung
     * @return \BiPRO\StructType\CT_Elementarprodukt
     */
    public function setVersicherungssummeOderLeistung(array $versicherungssummeOderLeistung = array())
    {
        // validation for constraint: array
        if ('' !== ($versicherungssummeOderLeistungArrayErrorMessage = self::validateVersicherungssummeOderLeistungForArrayConstraintsFromSetVersicherungssummeOderLeistung($versicherungssummeOderLeistung))) {
            throw new \InvalidArgumentException($versicherungssummeOderLeistungArrayErrorMessage, __LINE__);
        }
        $this->VersicherungssummeOderLeistung = $versicherungssummeOderLeistung;
        return $this;
    }
    /**
     * Add item to VersicherungssummeOderLeistung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_VersicherungssummeOderLeistung $item
     * @return \BiPRO\StructType\CT_Elementarprodukt
     */
    public function addToVersicherungssummeOderLeistung(\BiPRO\StructType\CT_VersicherungssummeOderLeistung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_VersicherungssummeOderLeistung) {
            throw new \InvalidArgumentException(sprintf('The VersicherungssummeOderLeistung property can only contain items of type \BiPRO\StructType\CT_VersicherungssummeOderLeistung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->VersicherungssummeOderLeistung[] = $item;
        return $this;
    }
    /**
     * Get Selbstbeteiligung value
     * @return \BiPRO\StructType\CT_Selbstbeteiligung[]|null
     */
    public function getSelbstbeteiligung()
    {
        return $this->Selbstbeteiligung;
    }
    /**
     * This method is responsible for validating the values passed to the setSelbstbeteiligung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelbstbeteiligung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelbstbeteiligungForArrayConstraintsFromSetSelbstbeteiligung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_ElementarproduktSelbstbeteiligungItem) {
            // validation for constraint: itemType
            if (!$cT_ElementarproduktSelbstbeteiligungItem instanceof \BiPRO\StructType\CT_Selbstbeteiligung) {
                $invalidValues[] = is_object($cT_ElementarproduktSelbstbeteiligungItem) ? get_class($cT_ElementarproduktSelbstbeteiligungItem) : sprintf('%s(%s)', gettype($cT_ElementarproduktSelbstbeteiligungItem), var_export($cT_ElementarproduktSelbstbeteiligungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Selbstbeteiligung property can only contain items of type \BiPRO\StructType\CT_Selbstbeteiligung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Selbstbeteiligung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Selbstbeteiligung[] $selbstbeteiligung
     * @return \BiPRO\StructType\CT_Elementarprodukt
     */
    public function setSelbstbeteiligung(array $selbstbeteiligung = array())
    {
        // validation for constraint: array
        if ('' !== ($selbstbeteiligungArrayErrorMessage = self::validateSelbstbeteiligungForArrayConstraintsFromSetSelbstbeteiligung($selbstbeteiligung))) {
            throw new \InvalidArgumentException($selbstbeteiligungArrayErrorMessage, __LINE__);
        }
        $this->Selbstbeteiligung = $selbstbeteiligung;
        return $this;
    }
    /**
     * Add item to Selbstbeteiligung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Selbstbeteiligung $item
     * @return \BiPRO\StructType\CT_Elementarprodukt
     */
    public function addToSelbstbeteiligung(\BiPRO\StructType\CT_Selbstbeteiligung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Selbstbeteiligung) {
            throw new \InvalidArgumentException(sprintf('The Selbstbeteiligung property can only contain items of type \BiPRO\StructType\CT_Selbstbeteiligung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Selbstbeteiligung[] = $item;
        return $this;
    }
    /**
     * Get Klausel value
     * @return \BiPRO\StructType\CT_Klausel[]|null
     */
    public function getKlausel()
    {
        return $this->Klausel;
    }
    /**
     * This method is responsible for validating the values passed to the setKlausel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKlausel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKlauselForArrayConstraintsFromSetKlausel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_ElementarproduktKlauselItem) {
            // validation for constraint: itemType
            if (!$cT_ElementarproduktKlauselItem instanceof \BiPRO\StructType\CT_Klausel) {
                $invalidValues[] = is_object($cT_ElementarproduktKlauselItem) ? get_class($cT_ElementarproduktKlauselItem) : sprintf('%s(%s)', gettype($cT_ElementarproduktKlauselItem), var_export($cT_ElementarproduktKlauselItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Klausel property can only contain items of type \BiPRO\StructType\CT_Klausel, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Klausel value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Klausel[] $klausel
     * @return \BiPRO\StructType\CT_Elementarprodukt
     */
    public function setKlausel(array $klausel = array())
    {
        // validation for constraint: array
        if ('' !== ($klauselArrayErrorMessage = self::validateKlauselForArrayConstraintsFromSetKlausel($klausel))) {
            throw new \InvalidArgumentException($klauselArrayErrorMessage, __LINE__);
        }
        $this->Klausel = $klausel;
        return $this;
    }
    /**
     * Add item to Klausel value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Klausel $item
     * @return \BiPRO\StructType\CT_Elementarprodukt
     */
    public function addToKlausel(\BiPRO\StructType\CT_Klausel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Klausel) {
            throw new \InvalidArgumentException(sprintf('The Klausel property can only contain items of type \BiPRO\StructType\CT_Klausel, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Klausel[] = $item;
        return $this;
    }
    /**
     * Get Bezugsrecht value
     * @return \BiPRO\StructType\CT_Bezugsrecht[]|null
     */
    public function getBezugsrecht()
    {
        return $this->Bezugsrecht;
    }
    /**
     * This method is responsible for validating the values passed to the setBezugsrecht method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBezugsrecht method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBezugsrechtForArrayConstraintsFromSetBezugsrecht(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_ElementarproduktBezugsrechtItem) {
            // validation for constraint: itemType
            if (!$cT_ElementarproduktBezugsrechtItem instanceof \BiPRO\StructType\CT_Bezugsrecht) {
                $invalidValues[] = is_object($cT_ElementarproduktBezugsrechtItem) ? get_class($cT_ElementarproduktBezugsrechtItem) : sprintf('%s(%s)', gettype($cT_ElementarproduktBezugsrechtItem), var_export($cT_ElementarproduktBezugsrechtItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Bezugsrecht property can only contain items of type \BiPRO\StructType\CT_Bezugsrecht, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Bezugsrecht value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Bezugsrecht[] $bezugsrecht
     * @return \BiPRO\StructType\CT_Elementarprodukt
     */
    public function setBezugsrecht(array $bezugsrecht = array())
    {
        // validation for constraint: array
        if ('' !== ($bezugsrechtArrayErrorMessage = self::validateBezugsrechtForArrayConstraintsFromSetBezugsrecht($bezugsrecht))) {
            throw new \InvalidArgumentException($bezugsrechtArrayErrorMessage, __LINE__);
        }
        $this->Bezugsrecht = $bezugsrecht;
        return $this;
    }
    /**
     * Add item to Bezugsrecht value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Bezugsrecht $item
     * @return \BiPRO\StructType\CT_Elementarprodukt
     */
    public function addToBezugsrecht(\BiPRO\StructType\CT_Bezugsrecht $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Bezugsrecht) {
            throw new \InvalidArgumentException(sprintf('The Bezugsrecht property can only contain items of type \BiPRO\StructType\CT_Bezugsrecht, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Bezugsrecht[] = $item;
        return $this;
    }
    /**
     * Get Leistungsausschluss value
     * @return \BiPRO\StructType\CT_Leistungsausschluss[]|null
     */
    public function getLeistungsausschluss()
    {
        return $this->Leistungsausschluss;
    }
    /**
     * This method is responsible for validating the values passed to the setLeistungsausschluss method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLeistungsausschluss method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLeistungsausschlussForArrayConstraintsFromSetLeistungsausschluss(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_ElementarproduktLeistungsausschlussItem) {
            // validation for constraint: itemType
            if (!$cT_ElementarproduktLeistungsausschlussItem instanceof \BiPRO\StructType\CT_Leistungsausschluss) {
                $invalidValues[] = is_object($cT_ElementarproduktLeistungsausschlussItem) ? get_class($cT_ElementarproduktLeistungsausschlussItem) : sprintf('%s(%s)', gettype($cT_ElementarproduktLeistungsausschlussItem), var_export($cT_ElementarproduktLeistungsausschlussItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Leistungsausschluss property can only contain items of type \BiPRO\StructType\CT_Leistungsausschluss, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Leistungsausschluss value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Leistungsausschluss[] $leistungsausschluss
     * @return \BiPRO\StructType\CT_Elementarprodukt
     */
    public function setLeistungsausschluss(array $leistungsausschluss = array())
    {
        // validation for constraint: array
        if ('' !== ($leistungsausschlussArrayErrorMessage = self::validateLeistungsausschlussForArrayConstraintsFromSetLeistungsausschluss($leistungsausschluss))) {
            throw new \InvalidArgumentException($leistungsausschlussArrayErrorMessage, __LINE__);
        }
        $this->Leistungsausschluss = $leistungsausschluss;
        return $this;
    }
    /**
     * Add item to Leistungsausschluss value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Leistungsausschluss $item
     * @return \BiPRO\StructType\CT_Elementarprodukt
     */
    public function addToLeistungsausschluss(\BiPRO\StructType\CT_Leistungsausschluss $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Leistungsausschluss) {
            throw new \InvalidArgumentException(sprintf('The Leistungsausschluss property can only contain items of type \BiPRO\StructType\CT_Leistungsausschluss, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Leistungsausschluss[] = $item;
        return $this;
    }
    /**
     * Get FondsPortfolio value
     * @return \BiPRO\StructType\CT_FondsPortfolio[]|null
     */
    public function getFondsPortfolio()
    {
        return $this->FondsPortfolio;
    }
    /**
     * This method is responsible for validating the values passed to the setFondsPortfolio method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFondsPortfolio method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFondsPortfolioForArrayConstraintsFromSetFondsPortfolio(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_ElementarproduktFondsPortfolioItem) {
            // validation for constraint: itemType
            if (!$cT_ElementarproduktFondsPortfolioItem instanceof \BiPRO\StructType\CT_FondsPortfolio) {
                $invalidValues[] = is_object($cT_ElementarproduktFondsPortfolioItem) ? get_class($cT_ElementarproduktFondsPortfolioItem) : sprintf('%s(%s)', gettype($cT_ElementarproduktFondsPortfolioItem), var_export($cT_ElementarproduktFondsPortfolioItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FondsPortfolio property can only contain items of type \BiPRO\StructType\CT_FondsPortfolio, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FondsPortfolio value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_FondsPortfolio[] $fondsPortfolio
     * @return \BiPRO\StructType\CT_Elementarprodukt
     */
    public function setFondsPortfolio(array $fondsPortfolio = array())
    {
        // validation for constraint: array
        if ('' !== ($fondsPortfolioArrayErrorMessage = self::validateFondsPortfolioForArrayConstraintsFromSetFondsPortfolio($fondsPortfolio))) {
            throw new \InvalidArgumentException($fondsPortfolioArrayErrorMessage, __LINE__);
        }
        $this->FondsPortfolio = $fondsPortfolio;
        return $this;
    }
    /**
     * Add item to FondsPortfolio value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_FondsPortfolio $item
     * @return \BiPRO\StructType\CT_Elementarprodukt
     */
    public function addToFondsPortfolio(\BiPRO\StructType\CT_FondsPortfolio $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_FondsPortfolio) {
            throw new \InvalidArgumentException(sprintf('The FondsPortfolio property can only contain items of type \BiPRO\StructType\CT_FondsPortfolio, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FondsPortfolio[] = $item;
        return $this;
    }
    /**
     * Get KfzZusatzVersicherung value
     * @return \BiPRO\StructType\CT_KfzZusatzVersicherung[]|null
     */
    public function getKfzZusatzVersicherung()
    {
        return $this->KfzZusatzVersicherung;
    }
    /**
     * This method is responsible for validating the values passed to the setKfzZusatzVersicherung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKfzZusatzVersicherung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKfzZusatzVersicherungForArrayConstraintsFromSetKfzZusatzVersicherung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_ElementarproduktKfzZusatzVersicherungItem) {
            // validation for constraint: itemType
            if (!$cT_ElementarproduktKfzZusatzVersicherungItem instanceof \BiPRO\StructType\CT_KfzZusatzVersicherung) {
                $invalidValues[] = is_object($cT_ElementarproduktKfzZusatzVersicherungItem) ? get_class($cT_ElementarproduktKfzZusatzVersicherungItem) : sprintf('%s(%s)', gettype($cT_ElementarproduktKfzZusatzVersicherungItem), var_export($cT_ElementarproduktKfzZusatzVersicherungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The KfzZusatzVersicherung property can only contain items of type \BiPRO\StructType\CT_KfzZusatzVersicherung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set KfzZusatzVersicherung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_KfzZusatzVersicherung[] $kfzZusatzVersicherung
     * @return \BiPRO\StructType\CT_Elementarprodukt
     */
    public function setKfzZusatzVersicherung(array $kfzZusatzVersicherung = array())
    {
        // validation for constraint: array
        if ('' !== ($kfzZusatzVersicherungArrayErrorMessage = self::validateKfzZusatzVersicherungForArrayConstraintsFromSetKfzZusatzVersicherung($kfzZusatzVersicherung))) {
            throw new \InvalidArgumentException($kfzZusatzVersicherungArrayErrorMessage, __LINE__);
        }
        $this->KfzZusatzVersicherung = $kfzZusatzVersicherung;
        return $this;
    }
    /**
     * Add item to KfzZusatzVersicherung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_KfzZusatzVersicherung $item
     * @return \BiPRO\StructType\CT_Elementarprodukt
     */
    public function addToKfzZusatzVersicherung(\BiPRO\StructType\CT_KfzZusatzVersicherung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_KfzZusatzVersicherung) {
            throw new \InvalidArgumentException(sprintf('The KfzZusatzVersicherung property can only contain items of type \BiPRO\StructType\CT_KfzZusatzVersicherung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->KfzZusatzVersicherung[] = $item;
        return $this;
    }
    /**
     * Get Geltungsbereich value
     * @return string|null
     */
    public function getGeltungsbereich()
    {
        return $this->Geltungsbereich;
    }
    /**
     * Set Geltungsbereich value
     * @uses \BiPRO\EnumType\ST_Geltungsbereich::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Geltungsbereich::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geltungsbereich
     * @return \BiPRO\StructType\CT_Elementarprodukt
     */
    public function setGeltungsbereich($geltungsbereich = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Geltungsbereich::valueIsValid($geltungsbereich)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Geltungsbereich', is_array($geltungsbereich) ? implode(', ', $geltungsbereich) : var_export($geltungsbereich, true), implode(', ', \BiPRO\EnumType\ST_Geltungsbereich::getValidValues())), __LINE__);
        }
        $this->Geltungsbereich = $geltungsbereich;
        return $this;
    }
}
