<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Eigentuemer StructType
 * Meta information extracted from the WSDL
 * - documentation: Eigentümer, auch Nießbraucher, Dinglicher Nutzungsberechtigter
 * @subpackage Structs
 */
class CT_Eigentuemer extends CT_Partnerrolle
{
    /**
     * The ArtWEG
     * Meta information extracted from the WSDL
     * - documentation: Art der Wohnungseigentümergemeinschaft.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtWEG;
    /**
     * Constructor method for CT_Eigentuemer
     * @uses CT_Eigentuemer::setArtWEG()
     * @param string $artWEG
     */
    public function __construct($artWEG = null)
    {
        $this
            ->setArtWEG($artWEG);
    }
    /**
     * Get ArtWEG value
     * @return string|null
     */
    public function getArtWEG()
    {
        return $this->ArtWEG;
    }
    /**
     * Set ArtWEG value
     * @uses \BiPRO\EnumType\ST_ArtWohnungseigentuemergemeinschaft::valueIsValid()
     * @uses \BiPRO\EnumType\ST_ArtWohnungseigentuemergemeinschaft::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artWEG
     * @return \BiPRO\StructType\CT_Eigentuemer
     */
    public function setArtWEG($artWEG = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_ArtWohnungseigentuemergemeinschaft::valueIsValid($artWEG)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_ArtWohnungseigentuemergemeinschaft', is_array($artWEG) ? implode(', ', $artWEG) : var_export($artWEG, true), implode(', ', \BiPRO\EnumType\ST_ArtWohnungseigentuemergemeinschaft::getValidValues())), __LINE__);
        }
        $this->ArtWEG = $artWEG;
        return $this;
    }
}
