<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Dokumentversand StructType
 * Meta information extracted from the WSDL
 * - documentation: Informationen zu einem Dokument, das alternativ - d.h. nicht innerhalb einer BiPRO-Nachricht - versand wird (z.B. postalischer Versand des beantworteten Risikofragebogens).Die Versandart des Dokuments MUSS entweder mittels des
 * Attributs Versandart oder des Attributs SonstigeVersandart angegeben werden.
 * @subpackage Structs
 */
class CT_Dokumentversand extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Art des Dokumentes, das alternativ versandt wird.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArtID;
    /**
     * The Versandart
     * Meta information extracted from the WSDL
     * - documentation: Gibt an, auf welche Art das Dokument versandt wird (z.B. Brief).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Versandart;
    /**
     * The SonstigeVersandart
     * Meta information extracted from the WSDL
     * - documentation: Gibt an, auf welche sonstige Art das Dokument versandt wird.DARF NUR verwendet werden,WENN im Attribut Versandart (ST_Versandart) keine passende Ausprägung definiert ist.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $SonstigeVersandart;
    /**
     * The Bezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Kurze, menschenlesbare Bezeichnung des versandten Dokuments.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Bezeichnung;
    /**
     * The Erlaeuterung
     * Meta information extracted from the WSDL
     * - documentation: Kurze, menschenlesbare Erläuterung zum Inhalt des versandten Dokuments.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Erlaeuterung;
    /**
     * Constructor method for CT_Dokumentversand
     * @uses CT_Dokumentversand::setArtID()
     * @uses CT_Dokumentversand::setVersandart()
     * @uses CT_Dokumentversand::setSonstigeVersandart()
     * @uses CT_Dokumentversand::setBezeichnung()
     * @uses CT_Dokumentversand::setErlaeuterung()
     * @param string $artID
     * @param string $versandart
     * @param string $sonstigeVersandart
     * @param string $bezeichnung
     * @param string $erlaeuterung
     */
    public function __construct($artID = null, $versandart = null, $sonstigeVersandart = null, $bezeichnung = null, $erlaeuterung = null)
    {
        $this
            ->setArtID($artID)
            ->setVersandart($versandart)
            ->setSonstigeVersandart($sonstigeVersandart)
            ->setBezeichnung($bezeichnung)
            ->setErlaeuterung($erlaeuterung);
    }
    /**
     * Get ArtID value
     * @return string
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_DokumentartID::valueIsValid()
     * @uses \BiPRO\EnumType\ST_DokumentartID::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_Dokumentversand
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_DokumentartID::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_DokumentartID', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_DokumentartID::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Versandart value
     * @return string|null
     */
    public function getVersandart()
    {
        return $this->Versandart;
    }
    /**
     * Set Versandart value
     * @uses \BiPRO\EnumType\ST_Versandart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Versandart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $versandart
     * @return \BiPRO\StructType\CT_Dokumentversand
     */
    public function setVersandart($versandart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Versandart::valueIsValid($versandart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Versandart', is_array($versandart) ? implode(', ', $versandart) : var_export($versandart, true), implode(', ', \BiPRO\EnumType\ST_Versandart::getValidValues())), __LINE__);
        }
        $this->Versandart = $versandart;
        return $this;
    }
    /**
     * Get SonstigeVersandart value
     * @return string|null
     */
    public function getSonstigeVersandart()
    {
        return $this->SonstigeVersandart;
    }
    /**
     * Set SonstigeVersandart value
     * @param string $sonstigeVersandart
     * @return \BiPRO\StructType\CT_Dokumentversand
     */
    public function setSonstigeVersandart($sonstigeVersandart = null)
    {
        // validation for constraint: string
        if (!is_null($sonstigeVersandart) && !is_string($sonstigeVersandart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sonstigeVersandart, true), gettype($sonstigeVersandart)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($sonstigeVersandart) && mb_strlen($sonstigeVersandart) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($sonstigeVersandart)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($sonstigeVersandart) && mb_strlen($sonstigeVersandart) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($sonstigeVersandart)), __LINE__);
        }
        $this->SonstigeVersandart = $sonstigeVersandart;
        return $this;
    }
    /**
     * Get Bezeichnung value
     * @return string|null
     */
    public function getBezeichnung()
    {
        return $this->Bezeichnung;
    }
    /**
     * Set Bezeichnung value
     * @param string $bezeichnung
     * @return \BiPRO\StructType\CT_Dokumentversand
     */
    public function setBezeichnung($bezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($bezeichnung) && !is_string($bezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezeichnung, true), gettype($bezeichnung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($bezeichnung) && mb_strlen($bezeichnung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($bezeichnung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($bezeichnung) && mb_strlen($bezeichnung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($bezeichnung)), __LINE__);
        }
        $this->Bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Get Erlaeuterung value
     * @return string|null
     */
    public function getErlaeuterung()
    {
        return $this->Erlaeuterung;
    }
    /**
     * Set Erlaeuterung value
     * @param string $erlaeuterung
     * @return \BiPRO\StructType\CT_Dokumentversand
     */
    public function setErlaeuterung($erlaeuterung = null)
    {
        // validation for constraint: string
        if (!is_null($erlaeuterung) && !is_string($erlaeuterung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erlaeuterung, true), gettype($erlaeuterung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($erlaeuterung) && mb_strlen($erlaeuterung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($erlaeuterung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($erlaeuterung) && mb_strlen($erlaeuterung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($erlaeuterung)), __LINE__);
        }
        $this->Erlaeuterung = $erlaeuterung;
        return $this;
    }
}
