<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Dokumentinformation StructType
 * Meta information extracted from the WSDL
 * - documentation: Klasse, über die Informationen zu bereitgestellten und mittels TP42007 (N420) abrufbaren Dokumenten.
 * @subpackage Structs
 */
class CT_Dokumentinformation extends CT_Objekt
{
    /**
     * The DokumentartID
     * Meta information extracted from the WSDL
     * - documentation: Art des Dokumentes, das zum Download angeboten wird (z. B. Vorschlag)
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DokumentartID;
    /**
     * The BereitstellungBis
     * Meta information extracted from the WSDL
     * - documentation: Zeitpunkt, bis zu dem das Dokument unter Angabe der DateiID abgerufen werden kann. | wie ST_DatumZeit ergänzt um Sekunden
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9]
     * @var string
     */
    public $BereitstellungBis;
    /**
     * The DateiID
     * Meta information extracted from the WSDL
     * - documentation: Kennzeichen, über das die abrufbare Datei eindeutig identifiziert werden kann. Das Kennzeichen dient beim Abruf der Datei als Referenzierung. | Typ fuer alle IDs.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateiID;
    /**
     * The Bezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Kurze für den Endanwender (Vermittler) verständliche Bezeichnung für das abrufbare Dokument.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Bezeichnung;
    /**
     * The Erlaeuterung
     * Meta information extracted from the WSDL
     * - documentation: Eine für Endanwender (Vermittler) verständliche Erläuterung über den Inhalt des Dokumentes.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Erlaeuterung;
    /**
     * Constructor method for CT_Dokumentinformation
     * @uses CT_Dokumentinformation::setDokumentartID()
     * @uses CT_Dokumentinformation::setBereitstellungBis()
     * @uses CT_Dokumentinformation::setDateiID()
     * @uses CT_Dokumentinformation::setBezeichnung()
     * @uses CT_Dokumentinformation::setErlaeuterung()
     * @param string $dokumentartID
     * @param string $bereitstellungBis
     * @param string $dateiID
     * @param string $bezeichnung
     * @param string $erlaeuterung
     */
    public function __construct($dokumentartID = null, $bereitstellungBis = null, $dateiID = null, $bezeichnung = null, $erlaeuterung = null)
    {
        $this
            ->setDokumentartID($dokumentartID)
            ->setBereitstellungBis($bereitstellungBis)
            ->setDateiID($dateiID)
            ->setBezeichnung($bezeichnung)
            ->setErlaeuterung($erlaeuterung);
    }
    /**
     * Get DokumentartID value
     * @return string
     */
    public function getDokumentartID()
    {
        return $this->DokumentartID;
    }
    /**
     * Set DokumentartID value
     * @uses \BiPRO\EnumType\ST_DokumentartID::valueIsValid()
     * @uses \BiPRO\EnumType\ST_DokumentartID::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dokumentartID
     * @return \BiPRO\StructType\CT_Dokumentinformation
     */
    public function setDokumentartID($dokumentartID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_DokumentartID::valueIsValid($dokumentartID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_DokumentartID', is_array($dokumentartID) ? implode(', ', $dokumentartID) : var_export($dokumentartID, true), implode(', ', \BiPRO\EnumType\ST_DokumentartID::getValidValues())), __LINE__);
        }
        $this->DokumentartID = $dokumentartID;
        return $this;
    }
    /**
     * Get BereitstellungBis value
     * @return string
     */
    public function getBereitstellungBis()
    {
        return $this->BereitstellungBis;
    }
    /**
     * Set BereitstellungBis value
     * @param string $bereitstellungBis
     * @return \BiPRO\StructType\CT_Dokumentinformation
     */
    public function setBereitstellungBis($bereitstellungBis = null)
    {
        // validation for constraint: string
        if (!is_null($bereitstellungBis) && !is_string($bereitstellungBis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bereitstellungBis, true), gettype($bereitstellungBis)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9])
        if (!is_null($bereitstellungBis) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9]/', $bereitstellungBis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9]', var_export($bereitstellungBis, true)), __LINE__);
        }
        $this->BereitstellungBis = $bereitstellungBis;
        return $this;
    }
    /**
     * Get DateiID value
     * @return string|null
     */
    public function getDateiID()
    {
        return $this->DateiID;
    }
    /**
     * Set DateiID value
     * @param string $dateiID
     * @return \BiPRO\StructType\CT_Dokumentinformation
     */
    public function setDateiID($dateiID = null)
    {
        // validation for constraint: string
        if (!is_null($dateiID) && !is_string($dateiID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateiID, true), gettype($dateiID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($dateiID) && mb_strlen($dateiID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($dateiID)), __LINE__);
        }
        $this->DateiID = $dateiID;
        return $this;
    }
    /**
     * Get Bezeichnung value
     * @return string|null
     */
    public function getBezeichnung()
    {
        return $this->Bezeichnung;
    }
    /**
     * Set Bezeichnung value
     * @param string $bezeichnung
     * @return \BiPRO\StructType\CT_Dokumentinformation
     */
    public function setBezeichnung($bezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($bezeichnung) && !is_string($bezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezeichnung, true), gettype($bezeichnung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($bezeichnung) && mb_strlen($bezeichnung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($bezeichnung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($bezeichnung) && mb_strlen($bezeichnung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($bezeichnung)), __LINE__);
        }
        $this->Bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Get Erlaeuterung value
     * @return string|null
     */
    public function getErlaeuterung()
    {
        return $this->Erlaeuterung;
    }
    /**
     * Set Erlaeuterung value
     * @param string $erlaeuterung
     * @return \BiPRO\StructType\CT_Dokumentinformation
     */
    public function setErlaeuterung($erlaeuterung = null)
    {
        // validation for constraint: string
        if (!is_null($erlaeuterung) && !is_string($erlaeuterung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erlaeuterung, true), gettype($erlaeuterung)), __LINE__);
        }
        $this->Erlaeuterung = $erlaeuterung;
        return $this;
    }
}
