<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Dienstleister StructType
 * Meta information extracted from the WSDL
 * - documentation: Dienstleister, der einen Service erbringt.
 * @subpackage Structs
 */
class CT_Dienstleister extends CT_Objekt
{
    /**
     * The PartnerID
     * Meta information extracted from the WSDL
     * - documentation: Eindeutige Referenz auf einen Partner in der Partnerliste. | Typ fuer alle IDs.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $PartnerID;
    /**
     * The SubDienstleister
     * Meta information extracted from the WSDL
     * - documentation: Der referenzierte Sub-Dienstleister ist ein Dienstleister, der dem referenzierenden Dienstleister untergeordnet ist.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Dienstleister[]
     */
    public $SubDienstleister;
    /**
     * Constructor method for CT_Dienstleister
     * @uses CT_Dienstleister::setPartnerID()
     * @uses CT_Dienstleister::setSubDienstleister()
     * @param string $partnerID
     * @param \BiPRO\StructType\CT_Dienstleister[] $subDienstleister
     */
    public function __construct($partnerID = null, array $subDienstleister = array())
    {
        $this
            ->setPartnerID($partnerID)
            ->setSubDienstleister($subDienstleister);
    }
    /**
     * Get PartnerID value
     * @return string
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }
    /**
     * Set PartnerID value
     * @param string $partnerID
     * @return \BiPRO\StructType\CT_Dienstleister
     */
    public function setPartnerID($partnerID = null)
    {
        // validation for constraint: string
        if (!is_null($partnerID) && !is_string($partnerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerID, true), gettype($partnerID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($partnerID) && mb_strlen($partnerID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($partnerID)), __LINE__);
        }
        $this->PartnerID = $partnerID;
        return $this;
    }
    /**
     * Get SubDienstleister value
     * @return \BiPRO\StructType\CT_Dienstleister[]|null
     */
    public function getSubDienstleister()
    {
        return $this->SubDienstleister;
    }
    /**
     * This method is responsible for validating the values passed to the setSubDienstleister method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubDienstleister method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubDienstleisterForArrayConstraintsFromSetSubDienstleister(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_DienstleisterSubDienstleisterItem) {
            // validation for constraint: itemType
            if (!$cT_DienstleisterSubDienstleisterItem instanceof \BiPRO\StructType\CT_Dienstleister) {
                $invalidValues[] = is_object($cT_DienstleisterSubDienstleisterItem) ? get_class($cT_DienstleisterSubDienstleisterItem) : sprintf('%s(%s)', gettype($cT_DienstleisterSubDienstleisterItem), var_export($cT_DienstleisterSubDienstleisterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubDienstleister property can only contain items of type \BiPRO\StructType\CT_Dienstleister, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubDienstleister value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Dienstleister[] $subDienstleister
     * @return \BiPRO\StructType\CT_Dienstleister
     */
    public function setSubDienstleister(array $subDienstleister = array())
    {
        // validation for constraint: array
        if ('' !== ($subDienstleisterArrayErrorMessage = self::validateSubDienstleisterForArrayConstraintsFromSetSubDienstleister($subDienstleister))) {
            throw new \InvalidArgumentException($subDienstleisterArrayErrorMessage, __LINE__);
        }
        $this->SubDienstleister = $subDienstleister;
        return $this;
    }
    /**
     * Add item to SubDienstleister value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Dienstleister $item
     * @return \BiPRO\StructType\CT_Dienstleister
     */
    public function addToSubDienstleister(\BiPRO\StructType\CT_Dienstleister $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Dienstleister) {
            throw new \InvalidArgumentException(sprintf('The SubDienstleister property can only contain items of type \BiPRO\StructType\CT_Dienstleister, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SubDienstleister[] = $item;
        return $this;
    }
}
