<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Diebstahlschaden StructType
 * Meta information extracted from the WSDL
 * - documentation: Informationen, die im Kontext eines Diebstahlschadens relevant sind.
 * @subpackage Structs
 */
class CT_Diebstahlschaden extends CT_SchadenZuObjekt
{
    /**
     * The RaumOderBehaeltnisAufgebrochen
     * Meta information extracted from the WSDL
     * - documentation: JA = Räume / Behältnisse, in denen sich das Schadenobjekt zum Schadenzeitpunkt befand, wurden aufgebrochen.NEIN = Räume / Behältnisse, in denen sich das Schadenobjekt zum Schadenzeitpunkt befand, wurden nicht aufgebrochen.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $RaumOderBehaeltnisAufgebrochen;
    /**
     * The Einbruchmeldeanlage
     * Meta information extracted from the WSDL
     * - documentation: Status der Einbruchmeldeanlage zum Schadenzeitpunkt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Einbruchmeldeanlage;
    /**
     * The Fensterstellung
     * Meta information extracted from the WSDL
     * - documentation: Stellung der Fenster zum Schadenzeitpunkt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fensterstellung;
    /**
     * The Fenstergriffe
     * Meta information extracted from the WSDL
     * - documentation: Status der abschließbaren Fenstergriffe zum Schadenzeitpunkt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fenstergriffe;
    /**
     * The Rollladen
     * Meta information extracted from the WSDL
     * - documentation: Status der Rollläden zum Schadenzeitpunkt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Rollladen;
    /**
     * The Tuerschlossart
     * Meta information extracted from the WSDL
     * - documentation: Schlossart der Tür.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tuerschlossart;
    /**
     * The TuerschlossartBeschreibung
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung der Schlossart der Tür.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $TuerschlossartBeschreibung;
    /**
     * The TuerschlossUmgeschlossen
     * Meta information extracted from the WSDL
     * - documentation: JA = Türschloss war zum Schadenzeitpunkt umgeschlossen (abgeschlossen)..NEIN = Türschloss war zum Schadenzeitpunkt nicht umgeschlossen (abgeschlossen).
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $TuerschlossUmgeschlossen;
    /**
     * The SacheVerschlossen
     * Meta information extracted from the WSDL
     * - documentation: JA = Das Schadenobjekt war zum Schadenzeitpunkt verschlossen.NEIN = Das Schadenobjekt war zum Schadenzeitpunkt nicht verschlossen.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $SacheVerschlossen;
    /**
     * The AnzahlSchluessel
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der Schlüssel für die Tür.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlSchluessel;
    /**
     * The NachschluesselSelbstGefertigt
     * Meta information extracted from the WSDL
     * - documentation: JA = Nachschlüssel selbst gefertigt.NEIN = Keine Nachschlüssel selbst gefertigt.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $NachschluesselSelbstGefertigt;
    /**
     * The NachschluesselSelbstGefertigtBeschreibung
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung, von wem der Nachschlüssel angefertigt wurde
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $NachschluesselSelbstGefertigtBeschreibung;
    /**
     * The SchluesselAufbewahrungsort
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung der Aufbewahrungsorte aller Schlüssel.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $SchluesselAufbewahrungsort;
    /**
     * The SchluesselverlustDatum
     * Meta information extracted from the WSDL
     * - documentation: Datum des Schlüsselverlustes. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $SchluesselverlustDatum;
    /**
     * The FremdeInRaeumen
     * Meta information extracted from the WSDL
     * - documentation: JA = Seit Verlust der Schlüssel haben sich Fremde in den versicherten Räumen aufgehalten.NEIN = Seit Verlust der Schlüssel haben sich keine Fremden in den versicherten Räumen aufgehalten.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $FremdeInRaeumen;
    /**
     * The FremdeAlleingelassen
     * Meta information extracted from the WSDL
     * - documentation: JA = Fremde, die sich in den versicherten Räumen aufgehalten haben, wurden alleingelassen.NEIN = Fremde, die sich in den versicherten Räumen aufgehalten haben, wurden nicht alleingelassen.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $FremdeAlleingelassen;
    /**
     * The Nachschluesseldiebstahl
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung der Indikatoren für einen Nachschlüsseldiebstahl.Es geht darum, dass jemand die Gelegenheit hatte, unbefugt einen Nachschlüssel zu fertigen, z.B. jemand, dem man den eigenen Schlüssel geliehen hat.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Nachschluesseldiebstahl;
    /**
     * The SachenAusserhalbVersicherungsort
     * Meta information extracted from the WSDL
     * - documentation: JA = Sachen befanden sich zum Schadenzeitpunkt außerhalb des Versicherungsortes.NEIN = Sachen befanden sich zum Schadenzeitpunkt nicht außerhalb des Versicherungsortes.Bsp.: Ein Notebook wurde aus dem Auto gestohlen und war damit
     * ausserhalb des Versicherungsortes.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $SachenAusserhalbVersicherungsort;
    /**
     * The Abstellort
     * Meta information extracted from the WSDL
     * - documentation: Abstellort des Schadenobjekts zum Schadenzeitpunkt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Abstellort;
    /**
     * The LetzteSichtung
     * Meta information extracted from the WSDL
     * - documentation: Datum mit optionaler Zeitangabe, wann das Schadenobjekt zuletzt gesehen wurde.Es MUSS mindestens ein Datum übermittelt werden. Wird eine Zeitangabe übermittelt, MUSS diese mit Stunden und Minuten angegeben werden. Eine Zeitzone
     * DARF übermittelt werden. Fehlt die Zeitzone, MUSS die am angegebenen Datum in Deutschland gültige Zeitzone angenommen werden. | Datentyp zur Angabe eines Zeitpunkts mit beliebiger Genauigkeit und optionaler Zeitzone. Vollständig ausgeprägt
     * entspricht die Darstellung ISO 8601 und dem W3C TimeStamp.Diesen Datentyp nutzende Attribute MÜSSEN in ihrer Dokumentation die gewünschte Genauigkeit und die Optionalität der Zeitzone explizit definieren.Angaben zur Zeitzone MÜSSEN wie folgt
     * interpretiert werden:Z = Zeitzone entspricht UTC.+05:00 = Zeitzone entspricht UTC +5 Stunden.Gültige Werte sind zum
     * Beispiel:2015-01-192015-01-19T20:152015-01-19T20:15:312015-01-19T20:15:31.3332015-01-19T20:15:31+05:002015-01-19Z2015-01-19+05:002015-01-19T20:15-03:30
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?
     * @var string
     */
    public $LetzteSichtung;
    /**
     * The ArtDerSicherung
     * Meta information extracted from the WSDL
     * - documentation: Art der Sicherung des Schadenobjekts zum Schadenzeitpunkt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtDerSicherung;
    /**
     * The GebrauchBeendet
     * Meta information extracted from the WSDL
     * - documentation: JA = Der Gebrauch des Schadenobjekts war beendet.NEIN = Der Gebrauch des Schadenobjekts war nicht beendet.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $GebrauchBeendet;
    /**
     * The StehlgutlisteEingereicht
     * Meta information extracted from the WSDL
     * - documentation: Wurde eine Stehlgutliste (Liste der gestohlenen Gegenstände) bei der Polizei eingereicht?JA = Komplette Stehlgutliste (Liste der gestohlenen Gegenstände) bei Polizei eingereicht.NEIN = Keine komplette Stehlgutliste bei Polizei
     * eingereicht.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $StehlgutlisteEingereicht;
    /**
     * The StehlgutlisteEingereichtDatum
     * Meta information extracted from the WSDL
     * - documentation: Datum, wann die Stehlgutliste bei der Polizei eingereicht wurde | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $StehlgutlisteEingereichtDatum;
    /**
     * The ZeitraumAusserhalbVersicherungsort
     * Meta information extracted from the WSDL
     * - documentation: Beginn des Zeitraums = Datum, seit dem sich die Sachen außerhalb des Versicherungsortes befanden.Ende des Zeitraums = Datum der geplanten Rückbringung.Der Zeitraum MUSS durch die Attribute Beginn und Ende spezifiziert werden.
     * Beginn und Ende MÜSSEN mindestens als Datum übermittelt werden. Wird eine Zeitangabe übermittelt, MUSS diese mit Stunden und Minuten angegeben werden. Eine Zeitzone DARF übermittelt werden. Fehlt die Zeitzone, MUSS die am angegebenen Datum in
     * Deutschland gültige Zeitzone angenommen werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum2
     */
    public $ZeitraumAusserhalbVersicherungsort;
    /**
     * The Abstellzeitraum
     * Meta information extracted from the WSDL
     * - documentation: Beginn des Zeitraums = Datum und Uhrzeit, wann das gestohlene Objekt am Abstellort abgestellt wurde.Ende des Zeitraums = Datum und Uhrzeit, wann geplant war, das gestohlene Objekt wieder zu benutzen.Der Zeitraum MUSS durch die
     * Attribute Beginn und Ende spezifiziert werden. Beginn und Ende MÜSSEN mindestens als Datum übermittelt werden. Wird eine Zeitangabe übermittelt, MUSS diese mit Stunden und Minuten angegeben werden. Eine Zeitzone DARF übermittelt werden. Fehlt die
     * Zeitzone, MUSS die am angegebenen Datum in Deutschland gültige Zeitzone angenommen werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum2
     */
    public $Abstellzeitraum;
    /**
     * The RaumBehaeltnis
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung des Raums und/oder Behältnisses (Gebäuede, Wohnung, Raum, Safe, Kfz, Hotelzimmer etc.) in dem sich das Schadenobjekt zum Schadenzeitpunkt befand.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_RaumBehaeltnis
     */
    public $RaumBehaeltnis;
    /**
     * Constructor method for CT_Diebstahlschaden
     * @uses CT_Diebstahlschaden::setRaumOderBehaeltnisAufgebrochen()
     * @uses CT_Diebstahlschaden::setEinbruchmeldeanlage()
     * @uses CT_Diebstahlschaden::setFensterstellung()
     * @uses CT_Diebstahlschaden::setFenstergriffe()
     * @uses CT_Diebstahlschaden::setRollladen()
     * @uses CT_Diebstahlschaden::setTuerschlossart()
     * @uses CT_Diebstahlschaden::setTuerschlossartBeschreibung()
     * @uses CT_Diebstahlschaden::setTuerschlossUmgeschlossen()
     * @uses CT_Diebstahlschaden::setSacheVerschlossen()
     * @uses CT_Diebstahlschaden::setAnzahlSchluessel()
     * @uses CT_Diebstahlschaden::setNachschluesselSelbstGefertigt()
     * @uses CT_Diebstahlschaden::setNachschluesselSelbstGefertigtBeschreibung()
     * @uses CT_Diebstahlschaden::setSchluesselAufbewahrungsort()
     * @uses CT_Diebstahlschaden::setSchluesselverlustDatum()
     * @uses CT_Diebstahlschaden::setFremdeInRaeumen()
     * @uses CT_Diebstahlschaden::setFremdeAlleingelassen()
     * @uses CT_Diebstahlschaden::setNachschluesseldiebstahl()
     * @uses CT_Diebstahlschaden::setSachenAusserhalbVersicherungsort()
     * @uses CT_Diebstahlschaden::setAbstellort()
     * @uses CT_Diebstahlschaden::setLetzteSichtung()
     * @uses CT_Diebstahlschaden::setArtDerSicherung()
     * @uses CT_Diebstahlschaden::setGebrauchBeendet()
     * @uses CT_Diebstahlschaden::setStehlgutlisteEingereicht()
     * @uses CT_Diebstahlschaden::setStehlgutlisteEingereichtDatum()
     * @uses CT_Diebstahlschaden::setZeitraumAusserhalbVersicherungsort()
     * @uses CT_Diebstahlschaden::setAbstellzeitraum()
     * @uses CT_Diebstahlschaden::setRaumBehaeltnis()
     * @param bool $raumOderBehaeltnisAufgebrochen
     * @param string $einbruchmeldeanlage
     * @param string $fensterstellung
     * @param string $fenstergriffe
     * @param string $rollladen
     * @param string $tuerschlossart
     * @param string $tuerschlossartBeschreibung
     * @param bool $tuerschlossUmgeschlossen
     * @param bool $sacheVerschlossen
     * @param int $anzahlSchluessel
     * @param bool $nachschluesselSelbstGefertigt
     * @param string $nachschluesselSelbstGefertigtBeschreibung
     * @param string $schluesselAufbewahrungsort
     * @param string $schluesselverlustDatum
     * @param bool $fremdeInRaeumen
     * @param bool $fremdeAlleingelassen
     * @param string $nachschluesseldiebstahl
     * @param bool $sachenAusserhalbVersicherungsort
     * @param string $abstellort
     * @param string $letzteSichtung
     * @param string $artDerSicherung
     * @param bool $gebrauchBeendet
     * @param bool $stehlgutlisteEingereicht
     * @param string $stehlgutlisteEingereichtDatum
     * @param \BiPRO\StructType\CT_Zeitraum2 $zeitraumAusserhalbVersicherungsort
     * @param \BiPRO\StructType\CT_Zeitraum2 $abstellzeitraum
     * @param \BiPRO\StructType\CT_RaumBehaeltnis $raumBehaeltnis
     */
    public function __construct($raumOderBehaeltnisAufgebrochen = null, $einbruchmeldeanlage = null, $fensterstellung = null, $fenstergriffe = null, $rollladen = null, $tuerschlossart = null, $tuerschlossartBeschreibung = null, $tuerschlossUmgeschlossen = null, $sacheVerschlossen = null, $anzahlSchluessel = null, $nachschluesselSelbstGefertigt = null, $nachschluesselSelbstGefertigtBeschreibung = null, $schluesselAufbewahrungsort = null, $schluesselverlustDatum = null, $fremdeInRaeumen = null, $fremdeAlleingelassen = null, $nachschluesseldiebstahl = null, $sachenAusserhalbVersicherungsort = null, $abstellort = null, $letzteSichtung = null, $artDerSicherung = null, $gebrauchBeendet = null, $stehlgutlisteEingereicht = null, $stehlgutlisteEingereichtDatum = null, \BiPRO\StructType\CT_Zeitraum2 $zeitraumAusserhalbVersicherungsort = null, \BiPRO\StructType\CT_Zeitraum2 $abstellzeitraum = null, \BiPRO\StructType\CT_RaumBehaeltnis $raumBehaeltnis = null)
    {
        $this
            ->setRaumOderBehaeltnisAufgebrochen($raumOderBehaeltnisAufgebrochen)
            ->setEinbruchmeldeanlage($einbruchmeldeanlage)
            ->setFensterstellung($fensterstellung)
            ->setFenstergriffe($fenstergriffe)
            ->setRollladen($rollladen)
            ->setTuerschlossart($tuerschlossart)
            ->setTuerschlossartBeschreibung($tuerschlossartBeschreibung)
            ->setTuerschlossUmgeschlossen($tuerschlossUmgeschlossen)
            ->setSacheVerschlossen($sacheVerschlossen)
            ->setAnzahlSchluessel($anzahlSchluessel)
            ->setNachschluesselSelbstGefertigt($nachschluesselSelbstGefertigt)
            ->setNachschluesselSelbstGefertigtBeschreibung($nachschluesselSelbstGefertigtBeschreibung)
            ->setSchluesselAufbewahrungsort($schluesselAufbewahrungsort)
            ->setSchluesselverlustDatum($schluesselverlustDatum)
            ->setFremdeInRaeumen($fremdeInRaeumen)
            ->setFremdeAlleingelassen($fremdeAlleingelassen)
            ->setNachschluesseldiebstahl($nachschluesseldiebstahl)
            ->setSachenAusserhalbVersicherungsort($sachenAusserhalbVersicherungsort)
            ->setAbstellort($abstellort)
            ->setLetzteSichtung($letzteSichtung)
            ->setArtDerSicherung($artDerSicherung)
            ->setGebrauchBeendet($gebrauchBeendet)
            ->setStehlgutlisteEingereicht($stehlgutlisteEingereicht)
            ->setStehlgutlisteEingereichtDatum($stehlgutlisteEingereichtDatum)
            ->setZeitraumAusserhalbVersicherungsort($zeitraumAusserhalbVersicherungsort)
            ->setAbstellzeitraum($abstellzeitraum)
            ->setRaumBehaeltnis($raumBehaeltnis);
    }
    /**
     * Get RaumOderBehaeltnisAufgebrochen value
     * @return bool|null
     */
    public function getRaumOderBehaeltnisAufgebrochen()
    {
        return $this->RaumOderBehaeltnisAufgebrochen;
    }
    /**
     * Set RaumOderBehaeltnisAufgebrochen value
     * @param bool $raumOderBehaeltnisAufgebrochen
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setRaumOderBehaeltnisAufgebrochen($raumOderBehaeltnisAufgebrochen = null)
    {
        // validation for constraint: boolean
        if (!is_null($raumOderBehaeltnisAufgebrochen) && !is_bool($raumOderBehaeltnisAufgebrochen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($raumOderBehaeltnisAufgebrochen, true), gettype($raumOderBehaeltnisAufgebrochen)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($raumOderBehaeltnisAufgebrochen) && !preg_match('/true|false/', $raumOderBehaeltnisAufgebrochen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($raumOderBehaeltnisAufgebrochen, true)), __LINE__);
        }
        $this->RaumOderBehaeltnisAufgebrochen = $raumOderBehaeltnisAufgebrochen;
        return $this;
    }
    /**
     * Get Einbruchmeldeanlage value
     * @return string|null
     */
    public function getEinbruchmeldeanlage()
    {
        return $this->Einbruchmeldeanlage;
    }
    /**
     * Set Einbruchmeldeanlage value
     * @uses \BiPRO\EnumType\ST_EinbruchmeldeanlageStatus::valueIsValid()
     * @uses \BiPRO\EnumType\ST_EinbruchmeldeanlageStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $einbruchmeldeanlage
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setEinbruchmeldeanlage($einbruchmeldeanlage = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_EinbruchmeldeanlageStatus::valueIsValid($einbruchmeldeanlage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_EinbruchmeldeanlageStatus', is_array($einbruchmeldeanlage) ? implode(', ', $einbruchmeldeanlage) : var_export($einbruchmeldeanlage, true), implode(', ', \BiPRO\EnumType\ST_EinbruchmeldeanlageStatus::getValidValues())), __LINE__);
        }
        $this->Einbruchmeldeanlage = $einbruchmeldeanlage;
        return $this;
    }
    /**
     * Get Fensterstellung value
     * @return string|null
     */
    public function getFensterstellung()
    {
        return $this->Fensterstellung;
    }
    /**
     * Set Fensterstellung value
     * @uses \BiPRO\EnumType\ST_Fensterstellung::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Fensterstellung::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fensterstellung
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setFensterstellung($fensterstellung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Fensterstellung::valueIsValid($fensterstellung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Fensterstellung', is_array($fensterstellung) ? implode(', ', $fensterstellung) : var_export($fensterstellung, true), implode(', ', \BiPRO\EnumType\ST_Fensterstellung::getValidValues())), __LINE__);
        }
        $this->Fensterstellung = $fensterstellung;
        return $this;
    }
    /**
     * Get Fenstergriffe value
     * @return string|null
     */
    public function getFenstergriffe()
    {
        return $this->Fenstergriffe;
    }
    /**
     * Set Fenstergriffe value
     * @uses \BiPRO\EnumType\ST_Fenstergriffe::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Fenstergriffe::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fenstergriffe
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setFenstergriffe($fenstergriffe = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Fenstergriffe::valueIsValid($fenstergriffe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Fenstergriffe', is_array($fenstergriffe) ? implode(', ', $fenstergriffe) : var_export($fenstergriffe, true), implode(', ', \BiPRO\EnumType\ST_Fenstergriffe::getValidValues())), __LINE__);
        }
        $this->Fenstergriffe = $fenstergriffe;
        return $this;
    }
    /**
     * Get Rollladen value
     * @return string|null
     */
    public function getRollladen()
    {
        return $this->Rollladen;
    }
    /**
     * Set Rollladen value
     * @uses \BiPRO\EnumType\ST_RollladenStatus::valueIsValid()
     * @uses \BiPRO\EnumType\ST_RollladenStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rollladen
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setRollladen($rollladen = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_RollladenStatus::valueIsValid($rollladen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_RollladenStatus', is_array($rollladen) ? implode(', ', $rollladen) : var_export($rollladen, true), implode(', ', \BiPRO\EnumType\ST_RollladenStatus::getValidValues())), __LINE__);
        }
        $this->Rollladen = $rollladen;
        return $this;
    }
    /**
     * Get Tuerschlossart value
     * @return string|null
     */
    public function getTuerschlossart()
    {
        return $this->Tuerschlossart;
    }
    /**
     * Set Tuerschlossart value
     * @uses \BiPRO\EnumType\ST_TuerschlossArt::valueIsValid()
     * @uses \BiPRO\EnumType\ST_TuerschlossArt::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tuerschlossart
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setTuerschlossart($tuerschlossart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_TuerschlossArt::valueIsValid($tuerschlossart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_TuerschlossArt', is_array($tuerschlossart) ? implode(', ', $tuerschlossart) : var_export($tuerschlossart, true), implode(', ', \BiPRO\EnumType\ST_TuerschlossArt::getValidValues())), __LINE__);
        }
        $this->Tuerschlossart = $tuerschlossart;
        return $this;
    }
    /**
     * Get TuerschlossartBeschreibung value
     * @return string|null
     */
    public function getTuerschlossartBeschreibung()
    {
        return $this->TuerschlossartBeschreibung;
    }
    /**
     * Set TuerschlossartBeschreibung value
     * @param string $tuerschlossartBeschreibung
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setTuerschlossartBeschreibung($tuerschlossartBeschreibung = null)
    {
        // validation for constraint: string
        if (!is_null($tuerschlossartBeschreibung) && !is_string($tuerschlossartBeschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tuerschlossartBeschreibung, true), gettype($tuerschlossartBeschreibung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($tuerschlossartBeschreibung) && mb_strlen($tuerschlossartBeschreibung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($tuerschlossartBeschreibung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($tuerschlossartBeschreibung) && mb_strlen($tuerschlossartBeschreibung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($tuerschlossartBeschreibung)), __LINE__);
        }
        $this->TuerschlossartBeschreibung = $tuerschlossartBeschreibung;
        return $this;
    }
    /**
     * Get TuerschlossUmgeschlossen value
     * @return bool|null
     */
    public function getTuerschlossUmgeschlossen()
    {
        return $this->TuerschlossUmgeschlossen;
    }
    /**
     * Set TuerschlossUmgeschlossen value
     * @param bool $tuerschlossUmgeschlossen
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setTuerschlossUmgeschlossen($tuerschlossUmgeschlossen = null)
    {
        // validation for constraint: boolean
        if (!is_null($tuerschlossUmgeschlossen) && !is_bool($tuerschlossUmgeschlossen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tuerschlossUmgeschlossen, true), gettype($tuerschlossUmgeschlossen)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($tuerschlossUmgeschlossen) && !preg_match('/true|false/', $tuerschlossUmgeschlossen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($tuerschlossUmgeschlossen, true)), __LINE__);
        }
        $this->TuerschlossUmgeschlossen = $tuerschlossUmgeschlossen;
        return $this;
    }
    /**
     * Get SacheVerschlossen value
     * @return bool|null
     */
    public function getSacheVerschlossen()
    {
        return $this->SacheVerschlossen;
    }
    /**
     * Set SacheVerschlossen value
     * @param bool $sacheVerschlossen
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setSacheVerschlossen($sacheVerschlossen = null)
    {
        // validation for constraint: boolean
        if (!is_null($sacheVerschlossen) && !is_bool($sacheVerschlossen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sacheVerschlossen, true), gettype($sacheVerschlossen)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($sacheVerschlossen) && !preg_match('/true|false/', $sacheVerschlossen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($sacheVerschlossen, true)), __LINE__);
        }
        $this->SacheVerschlossen = $sacheVerschlossen;
        return $this;
    }
    /**
     * Get AnzahlSchluessel value
     * @return int|null
     */
    public function getAnzahlSchluessel()
    {
        return $this->AnzahlSchluessel;
    }
    /**
     * Set AnzahlSchluessel value
     * @param int $anzahlSchluessel
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setAnzahlSchluessel($anzahlSchluessel = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlSchluessel) && !(is_int($anzahlSchluessel) || ctype_digit($anzahlSchluessel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlSchluessel, true), gettype($anzahlSchluessel)), __LINE__);
        }
        $this->AnzahlSchluessel = $anzahlSchluessel;
        return $this;
    }
    /**
     * Get NachschluesselSelbstGefertigt value
     * @return bool|null
     */
    public function getNachschluesselSelbstGefertigt()
    {
        return $this->NachschluesselSelbstGefertigt;
    }
    /**
     * Set NachschluesselSelbstGefertigt value
     * @param bool $nachschluesselSelbstGefertigt
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setNachschluesselSelbstGefertigt($nachschluesselSelbstGefertigt = null)
    {
        // validation for constraint: boolean
        if (!is_null($nachschluesselSelbstGefertigt) && !is_bool($nachschluesselSelbstGefertigt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nachschluesselSelbstGefertigt, true), gettype($nachschluesselSelbstGefertigt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($nachschluesselSelbstGefertigt) && !preg_match('/true|false/', $nachschluesselSelbstGefertigt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($nachschluesselSelbstGefertigt, true)), __LINE__);
        }
        $this->NachschluesselSelbstGefertigt = $nachschluesselSelbstGefertigt;
        return $this;
    }
    /**
     * Get NachschluesselSelbstGefertigtBeschreibung value
     * @return string|null
     */
    public function getNachschluesselSelbstGefertigtBeschreibung()
    {
        return $this->NachschluesselSelbstGefertigtBeschreibung;
    }
    /**
     * Set NachschluesselSelbstGefertigtBeschreibung value
     * @param string $nachschluesselSelbstGefertigtBeschreibung
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setNachschluesselSelbstGefertigtBeschreibung($nachschluesselSelbstGefertigtBeschreibung = null)
    {
        // validation for constraint: string
        if (!is_null($nachschluesselSelbstGefertigtBeschreibung) && !is_string($nachschluesselSelbstGefertigtBeschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nachschluesselSelbstGefertigtBeschreibung, true), gettype($nachschluesselSelbstGefertigtBeschreibung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($nachschluesselSelbstGefertigtBeschreibung) && mb_strlen($nachschluesselSelbstGefertigtBeschreibung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($nachschluesselSelbstGefertigtBeschreibung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($nachschluesselSelbstGefertigtBeschreibung) && mb_strlen($nachschluesselSelbstGefertigtBeschreibung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($nachschluesselSelbstGefertigtBeschreibung)), __LINE__);
        }
        $this->NachschluesselSelbstGefertigtBeschreibung = $nachschluesselSelbstGefertigtBeschreibung;
        return $this;
    }
    /**
     * Get SchluesselAufbewahrungsort value
     * @return string|null
     */
    public function getSchluesselAufbewahrungsort()
    {
        return $this->SchluesselAufbewahrungsort;
    }
    /**
     * Set SchluesselAufbewahrungsort value
     * @param string $schluesselAufbewahrungsort
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setSchluesselAufbewahrungsort($schluesselAufbewahrungsort = null)
    {
        // validation for constraint: string
        if (!is_null($schluesselAufbewahrungsort) && !is_string($schluesselAufbewahrungsort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schluesselAufbewahrungsort, true), gettype($schluesselAufbewahrungsort)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($schluesselAufbewahrungsort) && mb_strlen($schluesselAufbewahrungsort) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($schluesselAufbewahrungsort)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($schluesselAufbewahrungsort) && mb_strlen($schluesselAufbewahrungsort) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($schluesselAufbewahrungsort)), __LINE__);
        }
        $this->SchluesselAufbewahrungsort = $schluesselAufbewahrungsort;
        return $this;
    }
    /**
     * Get SchluesselverlustDatum value
     * @return string|null
     */
    public function getSchluesselverlustDatum()
    {
        return $this->SchluesselverlustDatum;
    }
    /**
     * Set SchluesselverlustDatum value
     * @param string $schluesselverlustDatum
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setSchluesselverlustDatum($schluesselverlustDatum = null)
    {
        // validation for constraint: string
        if (!is_null($schluesselverlustDatum) && !is_string($schluesselverlustDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schluesselverlustDatum, true), gettype($schluesselverlustDatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($schluesselverlustDatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $schluesselverlustDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($schluesselverlustDatum, true)), __LINE__);
        }
        $this->SchluesselverlustDatum = $schluesselverlustDatum;
        return $this;
    }
    /**
     * Get FremdeInRaeumen value
     * @return bool|null
     */
    public function getFremdeInRaeumen()
    {
        return $this->FremdeInRaeumen;
    }
    /**
     * Set FremdeInRaeumen value
     * @param bool $fremdeInRaeumen
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setFremdeInRaeumen($fremdeInRaeumen = null)
    {
        // validation for constraint: boolean
        if (!is_null($fremdeInRaeumen) && !is_bool($fremdeInRaeumen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fremdeInRaeumen, true), gettype($fremdeInRaeumen)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($fremdeInRaeumen) && !preg_match('/true|false/', $fremdeInRaeumen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($fremdeInRaeumen, true)), __LINE__);
        }
        $this->FremdeInRaeumen = $fremdeInRaeumen;
        return $this;
    }
    /**
     * Get FremdeAlleingelassen value
     * @return bool|null
     */
    public function getFremdeAlleingelassen()
    {
        return $this->FremdeAlleingelassen;
    }
    /**
     * Set FremdeAlleingelassen value
     * @param bool $fremdeAlleingelassen
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setFremdeAlleingelassen($fremdeAlleingelassen = null)
    {
        // validation for constraint: boolean
        if (!is_null($fremdeAlleingelassen) && !is_bool($fremdeAlleingelassen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fremdeAlleingelassen, true), gettype($fremdeAlleingelassen)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($fremdeAlleingelassen) && !preg_match('/true|false/', $fremdeAlleingelassen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($fremdeAlleingelassen, true)), __LINE__);
        }
        $this->FremdeAlleingelassen = $fremdeAlleingelassen;
        return $this;
    }
    /**
     * Get Nachschluesseldiebstahl value
     * @return string|null
     */
    public function getNachschluesseldiebstahl()
    {
        return $this->Nachschluesseldiebstahl;
    }
    /**
     * Set Nachschluesseldiebstahl value
     * @param string $nachschluesseldiebstahl
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setNachschluesseldiebstahl($nachschluesseldiebstahl = null)
    {
        // validation for constraint: string
        if (!is_null($nachschluesseldiebstahl) && !is_string($nachschluesseldiebstahl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nachschluesseldiebstahl, true), gettype($nachschluesseldiebstahl)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($nachschluesseldiebstahl) && mb_strlen($nachschluesseldiebstahl) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($nachschluesseldiebstahl)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($nachschluesseldiebstahl) && mb_strlen($nachschluesseldiebstahl) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($nachschluesseldiebstahl)), __LINE__);
        }
        $this->Nachschluesseldiebstahl = $nachschluesseldiebstahl;
        return $this;
    }
    /**
     * Get SachenAusserhalbVersicherungsort value
     * @return bool|null
     */
    public function getSachenAusserhalbVersicherungsort()
    {
        return $this->SachenAusserhalbVersicherungsort;
    }
    /**
     * Set SachenAusserhalbVersicherungsort value
     * @param bool $sachenAusserhalbVersicherungsort
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setSachenAusserhalbVersicherungsort($sachenAusserhalbVersicherungsort = null)
    {
        // validation for constraint: boolean
        if (!is_null($sachenAusserhalbVersicherungsort) && !is_bool($sachenAusserhalbVersicherungsort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sachenAusserhalbVersicherungsort, true), gettype($sachenAusserhalbVersicherungsort)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($sachenAusserhalbVersicherungsort) && !preg_match('/true|false/', $sachenAusserhalbVersicherungsort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($sachenAusserhalbVersicherungsort, true)), __LINE__);
        }
        $this->SachenAusserhalbVersicherungsort = $sachenAusserhalbVersicherungsort;
        return $this;
    }
    /**
     * Get Abstellort value
     * @return string|null
     */
    public function getAbstellort()
    {
        return $this->Abstellort;
    }
    /**
     * Set Abstellort value
     * @uses \BiPRO\EnumType\ST_Abstellort::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Abstellort::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $abstellort
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setAbstellort($abstellort = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Abstellort::valueIsValid($abstellort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Abstellort', is_array($abstellort) ? implode(', ', $abstellort) : var_export($abstellort, true), implode(', ', \BiPRO\EnumType\ST_Abstellort::getValidValues())), __LINE__);
        }
        $this->Abstellort = $abstellort;
        return $this;
    }
    /**
     * Get LetzteSichtung value
     * @return string|null
     */
    public function getLetzteSichtung()
    {
        return $this->LetzteSichtung;
    }
    /**
     * Set LetzteSichtung value
     * @param string $letzteSichtung
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setLetzteSichtung($letzteSichtung = null)
    {
        // validation for constraint: string
        if (!is_null($letzteSichtung) && !is_string($letzteSichtung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($letzteSichtung, true), gettype($letzteSichtung)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?)
        if (!is_null($letzteSichtung) && !preg_match('/[0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?/', $letzteSichtung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?', var_export($letzteSichtung, true)), __LINE__);
        }
        $this->LetzteSichtung = $letzteSichtung;
        return $this;
    }
    /**
     * Get ArtDerSicherung value
     * @return string|null
     */
    public function getArtDerSicherung()
    {
        return $this->ArtDerSicherung;
    }
    /**
     * Set ArtDerSicherung value
     * @uses \BiPRO\EnumType\ST_ArtDerSicherung::valueIsValid()
     * @uses \BiPRO\EnumType\ST_ArtDerSicherung::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artDerSicherung
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setArtDerSicherung($artDerSicherung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_ArtDerSicherung::valueIsValid($artDerSicherung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_ArtDerSicherung', is_array($artDerSicherung) ? implode(', ', $artDerSicherung) : var_export($artDerSicherung, true), implode(', ', \BiPRO\EnumType\ST_ArtDerSicherung::getValidValues())), __LINE__);
        }
        $this->ArtDerSicherung = $artDerSicherung;
        return $this;
    }
    /**
     * Get GebrauchBeendet value
     * @return bool|null
     */
    public function getGebrauchBeendet()
    {
        return $this->GebrauchBeendet;
    }
    /**
     * Set GebrauchBeendet value
     * @param bool $gebrauchBeendet
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setGebrauchBeendet($gebrauchBeendet = null)
    {
        // validation for constraint: boolean
        if (!is_null($gebrauchBeendet) && !is_bool($gebrauchBeendet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($gebrauchBeendet, true), gettype($gebrauchBeendet)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($gebrauchBeendet) && !preg_match('/true|false/', $gebrauchBeendet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($gebrauchBeendet, true)), __LINE__);
        }
        $this->GebrauchBeendet = $gebrauchBeendet;
        return $this;
    }
    /**
     * Get StehlgutlisteEingereicht value
     * @return bool|null
     */
    public function getStehlgutlisteEingereicht()
    {
        return $this->StehlgutlisteEingereicht;
    }
    /**
     * Set StehlgutlisteEingereicht value
     * @param bool $stehlgutlisteEingereicht
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setStehlgutlisteEingereicht($stehlgutlisteEingereicht = null)
    {
        // validation for constraint: boolean
        if (!is_null($stehlgutlisteEingereicht) && !is_bool($stehlgutlisteEingereicht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($stehlgutlisteEingereicht, true), gettype($stehlgutlisteEingereicht)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($stehlgutlisteEingereicht) && !preg_match('/true|false/', $stehlgutlisteEingereicht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($stehlgutlisteEingereicht, true)), __LINE__);
        }
        $this->StehlgutlisteEingereicht = $stehlgutlisteEingereicht;
        return $this;
    }
    /**
     * Get StehlgutlisteEingereichtDatum value
     * @return string|null
     */
    public function getStehlgutlisteEingereichtDatum()
    {
        return $this->StehlgutlisteEingereichtDatum;
    }
    /**
     * Set StehlgutlisteEingereichtDatum value
     * @param string $stehlgutlisteEingereichtDatum
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setStehlgutlisteEingereichtDatum($stehlgutlisteEingereichtDatum = null)
    {
        // validation for constraint: string
        if (!is_null($stehlgutlisteEingereichtDatum) && !is_string($stehlgutlisteEingereichtDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stehlgutlisteEingereichtDatum, true), gettype($stehlgutlisteEingereichtDatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($stehlgutlisteEingereichtDatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $stehlgutlisteEingereichtDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($stehlgutlisteEingereichtDatum, true)), __LINE__);
        }
        $this->StehlgutlisteEingereichtDatum = $stehlgutlisteEingereichtDatum;
        return $this;
    }
    /**
     * Get ZeitraumAusserhalbVersicherungsort value
     * @return \BiPRO\StructType\CT_Zeitraum2|null
     */
    public function getZeitraumAusserhalbVersicherungsort()
    {
        return $this->ZeitraumAusserhalbVersicherungsort;
    }
    /**
     * Set ZeitraumAusserhalbVersicherungsort value
     * @param \BiPRO\StructType\CT_Zeitraum2 $zeitraumAusserhalbVersicherungsort
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setZeitraumAusserhalbVersicherungsort(\BiPRO\StructType\CT_Zeitraum2 $zeitraumAusserhalbVersicherungsort = null)
    {
        $this->ZeitraumAusserhalbVersicherungsort = $zeitraumAusserhalbVersicherungsort;
        return $this;
    }
    /**
     * Get Abstellzeitraum value
     * @return \BiPRO\StructType\CT_Zeitraum2|null
     */
    public function getAbstellzeitraum()
    {
        return $this->Abstellzeitraum;
    }
    /**
     * Set Abstellzeitraum value
     * @param \BiPRO\StructType\CT_Zeitraum2 $abstellzeitraum
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setAbstellzeitraum(\BiPRO\StructType\CT_Zeitraum2 $abstellzeitraum = null)
    {
        $this->Abstellzeitraum = $abstellzeitraum;
        return $this;
    }
    /**
     * Get RaumBehaeltnis value
     * @return \BiPRO\StructType\CT_RaumBehaeltnis|null
     */
    public function getRaumBehaeltnis()
    {
        return $this->RaumBehaeltnis;
    }
    /**
     * Set RaumBehaeltnis value
     * @param \BiPRO\StructType\CT_RaumBehaeltnis $raumBehaeltnis
     * @return \BiPRO\StructType\CT_Diebstahlschaden
     */
    public function setRaumBehaeltnis(\BiPRO\StructType\CT_RaumBehaeltnis $raumBehaeltnis = null)
    {
        $this->RaumBehaeltnis = $raumBehaeltnis;
        return $this;
    }
}
