<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Betriebsstaette StructType
 * Meta information extracted from the WSDL
 * - documentation: Ort, an dem sich die Waren, Betriebseinrichtungen, bzw die zu versichernden Anlagen befinden.
 * @subpackage Structs
 */
class CT_Betriebsstaette extends CT_Gegenstand
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Gibt an, um welche Art von Betriebsstätte es sich handelt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtID;
    /**
     * The Objektanschrift
     * Meta information extracted from the WSDL
     * - documentation: Zur Abbildung einer Anschrift der Betriebsstätte.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Objektanschrift
     */
    public $Objektanschrift;
    /**
     * Constructor method for CT_Betriebsstaette
     * @uses CT_Betriebsstaette::setArtID()
     * @uses CT_Betriebsstaette::setObjektanschrift()
     * @param string $artID
     * @param \BiPRO\StructType\CT_Objektanschrift $objektanschrift
     */
    public function __construct($artID = null, \BiPRO\StructType\CT_Objektanschrift $objektanschrift = null)
    {
        $this
            ->setArtID($artID)
            ->setObjektanschrift($objektanschrift);
    }
    /**
     * Get ArtID value
     * @return string|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_Betriebsstaette::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Betriebsstaette::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_Betriebsstaette
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Betriebsstaette::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Betriebsstaette', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_Betriebsstaette::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Objektanschrift value
     * @return \BiPRO\StructType\CT_Objektanschrift|null
     */
    public function getObjektanschrift()
    {
        return $this->Objektanschrift;
    }
    /**
     * Set Objektanschrift value
     * @param \BiPRO\StructType\CT_Objektanschrift $objektanschrift
     * @return \BiPRO\StructType\CT_Betriebsstaette
     */
    public function setObjektanschrift(\BiPRO\StructType\CT_Objektanschrift $objektanschrift = null)
    {
        $this->Objektanschrift = $objektanschrift;
        return $this;
    }
}
