<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Betriebsleistung StructType
 * Meta information extracted from the WSDL
 * - documentation: Messgröße für die Nutzung eines technischen Geräts, z. B. eines Fahrzeugs. Die Betriebsleistung kann z. B. die Fahrleistung (Kilometerstand) oder die Nutzungsdauer (Betriebsstunden) sein.
 * @subpackage Structs
 */
class CT_Betriebsleistung extends CT_Objekt
{
    /**
     * The Wert
     * Meta information extracted from the WSDL
     * - documentation: Wert der Betriebsleistung gemäß Werteinheit, z.B. Kilometerstand, Betriebsstunden.Fehlt die Werteinheit, MUSS der Wert in Kilometer angegeben werden (also der Kilometerstand).
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Wert;
    /**
     * The Werteinheit
     * Meta information extracted from the WSDL
     * - documentation: Werteinheit der Betriebsleistung, in Kilometer, Meilen oder Stunden.Fehlt die Werteinheit, MUSS die Betriebsleistung in Kilometer angegeben werden (also der Kilometerstand).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Werteinheit;
    /**
     * The Ermittlungsdatum
     * Meta information extracted from the WSDL
     * - documentation: Datum der Ermittlung der Betriebsleistung. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Ermittlungsdatum;
    /**
     * The Ermittlungsart
     * Meta information extracted from the WSDL
     * - documentation: Art der Ermittlung der Betriebsleistung.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ermittlungsart;
    /**
     * Constructor method for CT_Betriebsleistung
     * @uses CT_Betriebsleistung::setWert()
     * @uses CT_Betriebsleistung::setWerteinheit()
     * @uses CT_Betriebsleistung::setErmittlungsdatum()
     * @uses CT_Betriebsleistung::setErmittlungsart()
     * @param float $wert
     * @param string $werteinheit
     * @param string $ermittlungsdatum
     * @param string $ermittlungsart
     */
    public function __construct($wert = null, $werteinheit = null, $ermittlungsdatum = null, $ermittlungsart = null)
    {
        $this
            ->setWert($wert)
            ->setWerteinheit($werteinheit)
            ->setErmittlungsdatum($ermittlungsdatum)
            ->setErmittlungsart($ermittlungsart);
    }
    /**
     * Get Wert value
     * @return float|null
     */
    public function getWert()
    {
        return $this->Wert;
    }
    /**
     * Set Wert value
     * @param float $wert
     * @return \BiPRO\StructType\CT_Betriebsleistung
     */
    public function setWert($wert = null)
    {
        // validation for constraint: float
        if (!is_null($wert) && !(is_float($wert) || is_numeric($wert))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($wert, true), gettype($wert)), __LINE__);
        }
        $this->Wert = $wert;
        return $this;
    }
    /**
     * Get Werteinheit value
     * @return string|null
     */
    public function getWerteinheit()
    {
        return $this->Werteinheit;
    }
    /**
     * Set Werteinheit value
     * @uses \BiPRO\EnumType\ST_Werteinheit::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Werteinheit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $werteinheit
     * @return \BiPRO\StructType\CT_Betriebsleistung
     */
    public function setWerteinheit($werteinheit = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Werteinheit::valueIsValid($werteinheit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Werteinheit', is_array($werteinheit) ? implode(', ', $werteinheit) : var_export($werteinheit, true), implode(', ', \BiPRO\EnumType\ST_Werteinheit::getValidValues())), __LINE__);
        }
        $this->Werteinheit = $werteinheit;
        return $this;
    }
    /**
     * Get Ermittlungsdatum value
     * @return string|null
     */
    public function getErmittlungsdatum()
    {
        return $this->Ermittlungsdatum;
    }
    /**
     * Set Ermittlungsdatum value
     * @param string $ermittlungsdatum
     * @return \BiPRO\StructType\CT_Betriebsleistung
     */
    public function setErmittlungsdatum($ermittlungsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($ermittlungsdatum) && !is_string($ermittlungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ermittlungsdatum, true), gettype($ermittlungsdatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($ermittlungsdatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $ermittlungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($ermittlungsdatum, true)), __LINE__);
        }
        $this->Ermittlungsdatum = $ermittlungsdatum;
        return $this;
    }
    /**
     * Get Ermittlungsart value
     * @return string|null
     */
    public function getErmittlungsart()
    {
        return $this->Ermittlungsart;
    }
    /**
     * Set Ermittlungsart value
     * @uses \BiPRO\EnumType\ST_Ermittlungsart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Ermittlungsart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ermittlungsart
     * @return \BiPRO\StructType\CT_Betriebsleistung
     */
    public function setErmittlungsart($ermittlungsart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Ermittlungsart::valueIsValid($ermittlungsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Ermittlungsart', is_array($ermittlungsart) ? implode(', ', $ermittlungsart) : var_export($ermittlungsart, true), implode(', ', \BiPRO\EnumType\ST_Ermittlungsart::getValidValues())), __LINE__);
        }
        $this->Ermittlungsart = $ermittlungsart;
        return $this;
    }
}
