<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Beteiligungsanteil StructType
 * Meta information extracted from the WSDL
 * - documentation: Die Klasse Beteiligungsanteil spezifiziert den Anteil eines Versicherers innerhalb eines Beteiligungsverhälnisses.
 * @subpackage Structs
 */
class CT_Beteiligungsanteil extends CT_Objekt
{
    /**
     * The AnteilVU
     * Meta information extracted from the WSDL
     * - documentation: Anteil des VU am Beteiligungsverhältnis | Prozentanteil ohne Prozentzeichen z.B. 50 = 50% oder 12,5 = 12,5%
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 1
     * @var float
     */
    public $AnteilVU;
    /**
     * The Unternehmen
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \BiPRO\StructType\CT_Unternehmen
     */
    public $Unternehmen;
    /**
     * The VUFuehrend
     * Meta information extracted from the WSDL
     * - documentation: JA = VU ist führender VersichererNEIN = VU ist nicht-führender beteiligter Versicherer
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $VUFuehrend;
    /**
     * The Vertragsnummer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Vertragsnummer
     */
    public $Vertragsnummer;
    /**
     * Constructor method for CT_Beteiligungsanteil
     * @uses CT_Beteiligungsanteil::setAnteilVU()
     * @uses CT_Beteiligungsanteil::setUnternehmen()
     * @uses CT_Beteiligungsanteil::setVUFuehrend()
     * @uses CT_Beteiligungsanteil::setVertragsnummer()
     * @param float $anteilVU
     * @param \BiPRO\StructType\CT_Unternehmen $unternehmen
     * @param bool $vUFuehrend
     * @param \BiPRO\StructType\CT_Vertragsnummer $vertragsnummer
     */
    public function __construct($anteilVU = null, \BiPRO\StructType\CT_Unternehmen $unternehmen = null, $vUFuehrend = null, \BiPRO\StructType\CT_Vertragsnummer $vertragsnummer = null)
    {
        $this
            ->setAnteilVU($anteilVU)
            ->setUnternehmen($unternehmen)
            ->setVUFuehrend($vUFuehrend)
            ->setVertragsnummer($vertragsnummer);
    }
    /**
     * Get AnteilVU value
     * @return float
     */
    public function getAnteilVU()
    {
        return $this->AnteilVU;
    }
    /**
     * Set AnteilVU value
     * @param float $anteilVU
     * @return \BiPRO\StructType\CT_Beteiligungsanteil
     */
    public function setAnteilVU($anteilVU = null)
    {
        // validation for constraint: float
        if (!is_null($anteilVU) && !(is_float($anteilVU) || is_numeric($anteilVU))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($anteilVU, true), gettype($anteilVU)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($anteilVU) && $anteilVU < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($anteilVU, true)), __LINE__);
        }
        $this->AnteilVU = $anteilVU;
        return $this;
    }
    /**
     * Get Unternehmen value
     * @return \BiPRO\StructType\CT_Unternehmen
     */
    public function getUnternehmen()
    {
        return $this->Unternehmen;
    }
    /**
     * Set Unternehmen value
     * @param \BiPRO\StructType\CT_Unternehmen $unternehmen
     * @return \BiPRO\StructType\CT_Beteiligungsanteil
     */
    public function setUnternehmen(\BiPRO\StructType\CT_Unternehmen $unternehmen = null)
    {
        $this->Unternehmen = $unternehmen;
        return $this;
    }
    /**
     * Get VUFuehrend value
     * @return bool|null
     */
    public function getVUFuehrend()
    {
        return $this->VUFuehrend;
    }
    /**
     * Set VUFuehrend value
     * @param bool $vUFuehrend
     * @return \BiPRO\StructType\CT_Beteiligungsanteil
     */
    public function setVUFuehrend($vUFuehrend = null)
    {
        // validation for constraint: boolean
        if (!is_null($vUFuehrend) && !is_bool($vUFuehrend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vUFuehrend, true), gettype($vUFuehrend)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($vUFuehrend) && !preg_match('/true|false/', $vUFuehrend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($vUFuehrend, true)), __LINE__);
        }
        $this->VUFuehrend = $vUFuehrend;
        return $this;
    }
    /**
     * Get Vertragsnummer value
     * @return \BiPRO\StructType\CT_Vertragsnummer|null
     */
    public function getVertragsnummer()
    {
        return $this->Vertragsnummer;
    }
    /**
     * Set Vertragsnummer value
     * @param \BiPRO\StructType\CT_Vertragsnummer $vertragsnummer
     * @return \BiPRO\StructType\CT_Beteiligungsanteil
     */
    public function setVertragsnummer(\BiPRO\StructType\CT_Vertragsnummer $vertragsnummer = null)
    {
        $this->Vertragsnummer = $vertragsnummer;
        return $this;
    }
}
