<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Berechnungsgrundlage StructType
 * Meta information extracted from the WSDL
 * - documentation: Über das Objekt Berechnungsgrundlage können Angaben dazu erfolgen, ob bestimmte Faktoren in die Bestimmung des Werts eingeflossen sind. Erfolgt eine solche Angabe nicht, so gelten folgende
 * Standardannahmen:(Letzte/Summe)ErhalteneZulagen:Zulagen berücksichtigt - jaGezahlteBeitragssumme: Zulagen berücksichtigt - neinGarantierteRente/Erlebensfallleistung:Zulagen berücksichtigt - jaSteuern berücksichtigt - jaGesamte/Beitragsfreie
 * Rente/Erlebens-/Todesfallleistung:Zulagen berücksichtigt - jaHochrechnungszins - Pflichtangabe (bei fondsgebundenen)Wertentwicklung gem. Hochrechnungszins nach Fondskosten - jaSteuern berücksichtigt - neinGarantierteTodesfallleistung:Zulagen
 * berücksichtigt - jaRückkaufswert:Zulagen berücksichtigt - jaStornokosten berücksichtigt - jaSteuern berücksichtigt - jaVertragswert:Zulagen berücksichtigt - jaSteuern berücksichtigt - ja
 * @subpackage Structs
 */
class CT_Berechnungsgrundlage extends CT_Objekt
{
    /**
     * The Zulagen
     * Meta information extracted from the WSDL
     * - documentation: Staatliche Zulagen wurden bei der Berechnung berücksichtigt.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Zulagen;
    /**
     * The Stornokosten
     * Meta information extracted from the WSDL
     * - documentation: Stornokosten wurden bei der Berechnung berücksichtigt.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Stornokosten;
    /**
     * The Steuern
     * Meta information extracted from the WSDL
     * - documentation: Von der Gesellschaft abzuführende Steuern (z.B. Abgeltungssteuer) wurden bei der Berechnung berücksichtigt.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Steuern;
    /**
     * The WertentwicklungNachFondskosten
     * Meta information extracted from the WSDL
     * - documentation: Die Wertentwicklung wurde anhand des unterstellten Hochrechnungszins nach Fondskosten (=ja) berechnet. (nein = Wertentwicklung gemäß Hochrechnungszins vor Fondskosten).
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $WertentwicklungNachFondskosten;
    /**
     * The Hochrechnungszins
     * Meta information extracted from the WSDL
     * - documentation: Unterstellte Wertentwicklung nach oder vor Berücksichtigung von Fondskosten gemäß Angabe im Attribut "WertentwicklungNachFondskosten". | Prozentanteil ohne Prozentzeichen z.B. 50 = 50% oder 12,5 = 12,5%
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var float
     */
    public $Hochrechnungszins;
    /**
     * Constructor method for CT_Berechnungsgrundlage
     * @uses CT_Berechnungsgrundlage::setZulagen()
     * @uses CT_Berechnungsgrundlage::setStornokosten()
     * @uses CT_Berechnungsgrundlage::setSteuern()
     * @uses CT_Berechnungsgrundlage::setWertentwicklungNachFondskosten()
     * @uses CT_Berechnungsgrundlage::setHochrechnungszins()
     * @param bool $zulagen
     * @param bool $stornokosten
     * @param bool $steuern
     * @param bool $wertentwicklungNachFondskosten
     * @param float $hochrechnungszins
     */
    public function __construct($zulagen = null, $stornokosten = null, $steuern = null, $wertentwicklungNachFondskosten = null, $hochrechnungszins = null)
    {
        $this
            ->setZulagen($zulagen)
            ->setStornokosten($stornokosten)
            ->setSteuern($steuern)
            ->setWertentwicklungNachFondskosten($wertentwicklungNachFondskosten)
            ->setHochrechnungszins($hochrechnungszins);
    }
    /**
     * Get Zulagen value
     * @return bool|null
     */
    public function getZulagen()
    {
        return $this->Zulagen;
    }
    /**
     * Set Zulagen value
     * @param bool $zulagen
     * @return \BiPRO\StructType\CT_Berechnungsgrundlage
     */
    public function setZulagen($zulagen = null)
    {
        // validation for constraint: boolean
        if (!is_null($zulagen) && !is_bool($zulagen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($zulagen, true), gettype($zulagen)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($zulagen) && !preg_match('/true|false/', $zulagen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($zulagen, true)), __LINE__);
        }
        $this->Zulagen = $zulagen;
        return $this;
    }
    /**
     * Get Stornokosten value
     * @return bool|null
     */
    public function getStornokosten()
    {
        return $this->Stornokosten;
    }
    /**
     * Set Stornokosten value
     * @param bool $stornokosten
     * @return \BiPRO\StructType\CT_Berechnungsgrundlage
     */
    public function setStornokosten($stornokosten = null)
    {
        // validation for constraint: boolean
        if (!is_null($stornokosten) && !is_bool($stornokosten)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($stornokosten, true), gettype($stornokosten)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($stornokosten) && !preg_match('/true|false/', $stornokosten)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($stornokosten, true)), __LINE__);
        }
        $this->Stornokosten = $stornokosten;
        return $this;
    }
    /**
     * Get Steuern value
     * @return bool|null
     */
    public function getSteuern()
    {
        return $this->Steuern;
    }
    /**
     * Set Steuern value
     * @param bool $steuern
     * @return \BiPRO\StructType\CT_Berechnungsgrundlage
     */
    public function setSteuern($steuern = null)
    {
        // validation for constraint: boolean
        if (!is_null($steuern) && !is_bool($steuern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($steuern, true), gettype($steuern)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($steuern) && !preg_match('/true|false/', $steuern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($steuern, true)), __LINE__);
        }
        $this->Steuern = $steuern;
        return $this;
    }
    /**
     * Get WertentwicklungNachFondskosten value
     * @return bool|null
     */
    public function getWertentwicklungNachFondskosten()
    {
        return $this->WertentwicklungNachFondskosten;
    }
    /**
     * Set WertentwicklungNachFondskosten value
     * @param bool $wertentwicklungNachFondskosten
     * @return \BiPRO\StructType\CT_Berechnungsgrundlage
     */
    public function setWertentwicklungNachFondskosten($wertentwicklungNachFondskosten = null)
    {
        // validation for constraint: boolean
        if (!is_null($wertentwicklungNachFondskosten) && !is_bool($wertentwicklungNachFondskosten)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($wertentwicklungNachFondskosten, true), gettype($wertentwicklungNachFondskosten)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($wertentwicklungNachFondskosten) && !preg_match('/true|false/', $wertentwicklungNachFondskosten)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($wertentwicklungNachFondskosten, true)), __LINE__);
        }
        $this->WertentwicklungNachFondskosten = $wertentwicklungNachFondskosten;
        return $this;
    }
    /**
     * Get Hochrechnungszins value
     * @return float|null
     */
    public function getHochrechnungszins()
    {
        return $this->Hochrechnungszins;
    }
    /**
     * Set Hochrechnungszins value
     * @param float $hochrechnungszins
     * @return \BiPRO\StructType\CT_Berechnungsgrundlage
     */
    public function setHochrechnungszins($hochrechnungszins = null)
    {
        // validation for constraint: float
        if (!is_null($hochrechnungszins) && !(is_float($hochrechnungszins) || is_numeric($hochrechnungszins))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hochrechnungszins, true), gettype($hochrechnungszins)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($hochrechnungszins) && $hochrechnungszins < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($hochrechnungszins, true)), __LINE__);
        }
        $this->Hochrechnungszins = $hochrechnungszins;
        return $this;
    }
}
