<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Beitrag StructType
 * Meta information extracted from the WSDL
 * - documentation: Zu zahlende, vorgegebene oder berechnete Beiträge.Beiträge werden auf der nächst höheren Ebene aggregiert.Beispiel für Versicherungen:Tarifbeitrag, Gesamtbeitrag Brutto ohne Überschussverrechnung (Schlüssel 07)./.
 * Überschüsse= Nettobeitrag inklusive etwaigem Ratenzahlungszuschlag (Schlüssel 02)+ Versicherungssteuer= Beitrag inklusive etwaiger Steuer (Schlüssel 01)Verwendungsbeispiel ArtID=10: An einem Produktbaustein wird ein Objekt Beitrag (ArtID=07,
 * Betrag=100, Waehrung=EUR...) angegeben und ein Objekt Beitrag (ArtID=10, Prozentsatz=40,Erhebung=Zeitraum[2 Jahre]...). Das heißt, der Tarifbeitrag beträgt 40 €/Monat in den ersten zwei Jahren und anschließend 100 €/Monat für den Rest der
 * Aufschubzeit.
 * @subpackage Structs
 */
class CT_Beitrag extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Beitrag
     */
    public $ArtID;
    /**
     * The Betrag
     * Meta information extracted from the WSDL
     * - documentation: Beitragsbetrag
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Betrag
     */
    public $Betrag;
    /**
     * The Zahlungsweise
     * Meta information extracted from the WSDL
     * - documentation: Zahlungsweise für die der Beitrag in diesem Beitragsobjekt (ggf. abweichend von der gewünschten Zahlweise im Produktbaustein) angegeben ist.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zahlungsweise;
    /**
     * The Prozentsatz
     * Meta information extracted from the WSDL
     * - documentation: Dient der Darstellung verminderter Anfangsbeiträge als Prozentsatz des vereinbarten Regel- bzw. Zielbeitrags. MUSS angegeben werden, wenn ArtID gleich 21 ist (DARF andernfalls NICHT angegeben werden). | Prozentanteil ohne
     * Prozentzeichen z.B. 50 = 50% oder 12,5 = 12,5%
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var float
     */
    public $Prozentsatz;
    /**
     * The Dauer
     * Meta information extracted from the WSDL
     * - documentation: MUSS befüllt werden, wenn das Endedatum unbestimmt ist.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Dauer;
    /**
     * The Erhebung
     * Meta information extracted from the WSDL
     * - documentation: Zeitraum der Beitragszahlung.Gibt an in welchem Zeitraum dieser Beitrag zu zahlen ist. Es handelt sich nicht um den Abrechnungszeitraum einer einzelnen Beitragsbuchung.Der Zeitraum MUSS konkret angegeben werden.Lebenslang zu zahlende
     * Beiträge werden über einen Erhebungszeitraum mit definiertem Beginn ohne Angabe eines Endtermins dargestellt. Bei einmaligen Zahlungen MUSS der konkrete Zeitpunkt angegeben werden. Abweichend davon gilt bei Foerderung, dass Einmalige Zahlungen
     * (Zahlungsweise = 6 einmalig) einem eindeutigen Förderungsjahr zugeordnet werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum
     */
    public $Erhebung;
    /**
     * The VermoegenswirksameLeistung
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_VermoegenswirksameLeistung
     */
    public $VermoegenswirksameLeistung;
    /**
     * The Steuer
     * Meta information extracted from the WSDL
     * - documentation: Gibt die Steueranteile im Beitrag (bei ArtID = 01) an.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Steuer[]
     */
    public $Steuer;
    /**
     * The Beitragsfoerderung
     * Meta information extracted from the WSDL
     * - documentation: Informationen zur Förderung des entsprechenden Beitrags.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Beitragsfoerderung
     */
    public $Beitragsfoerderung;
    /**
     * The Beitragsschuldner
     * Meta information extracted from the WSDL
     * - documentation: Beitragsschuldner des Beitrags.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Beitragsschuldner
     */
    public $Beitragsschuldner;
    /**
     * The BeitragImRueckstand
     * Meta information extracted from the WSDL
     * - documentation: Weist aus, ob dieser Beitrag im Rückstand ist.Ja = Beitrag ist im RückstandNein = sonst
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $BeitragImRueckstand;
    /**
     * Constructor method for CT_Beitrag
     * @uses CT_Beitrag::setArtID()
     * @uses CT_Beitrag::setBetrag()
     * @uses CT_Beitrag::setZahlungsweise()
     * @uses CT_Beitrag::setProzentsatz()
     * @uses CT_Beitrag::setDauer()
     * @uses CT_Beitrag::setErhebung()
     * @uses CT_Beitrag::setVermoegenswirksameLeistung()
     * @uses CT_Beitrag::setSteuer()
     * @uses CT_Beitrag::setBeitragsfoerderung()
     * @uses CT_Beitrag::setBeitragsschuldner()
     * @uses CT_Beitrag::setBeitragImRueckstand()
     * @param \BiPRO\StructType\STE_Beitrag $artID
     * @param \BiPRO\StructType\CT_Betrag $betrag
     * @param string $zahlungsweise
     * @param float $prozentsatz
     * @param string $dauer
     * @param \BiPRO\StructType\CT_Zeitraum $erhebung
     * @param \BiPRO\StructType\CT_VermoegenswirksameLeistung $vermoegenswirksameLeistung
     * @param \BiPRO\StructType\CT_Steuer[] $steuer
     * @param \BiPRO\StructType\CT_Beitragsfoerderung $beitragsfoerderung
     * @param \BiPRO\StructType\CT_Beitragsschuldner $beitragsschuldner
     * @param bool $beitragImRueckstand
     */
    public function __construct(\BiPRO\StructType\STE_Beitrag $artID = null, \BiPRO\StructType\CT_Betrag $betrag = null, $zahlungsweise = null, $prozentsatz = null, $dauer = null, \BiPRO\StructType\CT_Zeitraum $erhebung = null, \BiPRO\StructType\CT_VermoegenswirksameLeistung $vermoegenswirksameLeistung = null, array $steuer = array(), \BiPRO\StructType\CT_Beitragsfoerderung $beitragsfoerderung = null, \BiPRO\StructType\CT_Beitragsschuldner $beitragsschuldner = null, $beitragImRueckstand = null)
    {
        $this
            ->setArtID($artID)
            ->setBetrag($betrag)
            ->setZahlungsweise($zahlungsweise)
            ->setProzentsatz($prozentsatz)
            ->setDauer($dauer)
            ->setErhebung($erhebung)
            ->setVermoegenswirksameLeistung($vermoegenswirksameLeistung)
            ->setSteuer($steuer)
            ->setBeitragsfoerderung($beitragsfoerderung)
            ->setBeitragsschuldner($beitragsschuldner)
            ->setBeitragImRueckstand($beitragImRueckstand);
    }
    /**
     * Get ArtID value
     * @return \BiPRO\StructType\STE_Beitrag|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @param \BiPRO\StructType\STE_Beitrag $artID
     * @return \BiPRO\StructType\CT_Beitrag
     */
    public function setArtID(\BiPRO\StructType\STE_Beitrag $artID = null)
    {
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Betrag value
     * @return \BiPRO\StructType\CT_Betrag|null
     */
    public function getBetrag()
    {
        return $this->Betrag;
    }
    /**
     * Set Betrag value
     * @param \BiPRO\StructType\CT_Betrag $betrag
     * @return \BiPRO\StructType\CT_Beitrag
     */
    public function setBetrag(\BiPRO\StructType\CT_Betrag $betrag = null)
    {
        $this->Betrag = $betrag;
        return $this;
    }
    /**
     * Get Zahlungsweise value
     * @return string|null
     */
    public function getZahlungsweise()
    {
        return $this->Zahlungsweise;
    }
    /**
     * Set Zahlungsweise value
     * @uses \BiPRO\EnumType\ST_Zahlungsweise::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Zahlungsweise::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zahlungsweise
     * @return \BiPRO\StructType\CT_Beitrag
     */
    public function setZahlungsweise($zahlungsweise = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Zahlungsweise::valueIsValid($zahlungsweise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Zahlungsweise', is_array($zahlungsweise) ? implode(', ', $zahlungsweise) : var_export($zahlungsweise, true), implode(', ', \BiPRO\EnumType\ST_Zahlungsweise::getValidValues())), __LINE__);
        }
        $this->Zahlungsweise = $zahlungsweise;
        return $this;
    }
    /**
     * Get Prozentsatz value
     * @return float|null
     */
    public function getProzentsatz()
    {
        return $this->Prozentsatz;
    }
    /**
     * Set Prozentsatz value
     * @param float $prozentsatz
     * @return \BiPRO\StructType\CT_Beitrag
     */
    public function setProzentsatz($prozentsatz = null)
    {
        // validation for constraint: float
        if (!is_null($prozentsatz) && !(is_float($prozentsatz) || is_numeric($prozentsatz))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prozentsatz, true), gettype($prozentsatz)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($prozentsatz) && $prozentsatz < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($prozentsatz, true)), __LINE__);
        }
        $this->Prozentsatz = $prozentsatz;
        return $this;
    }
    /**
     * Get Dauer value
     * @return string|null
     */
    public function getDauer()
    {
        return $this->Dauer;
    }
    /**
     * Set Dauer value
     * @uses \BiPRO\EnumType\ST_Dauer::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Dauer::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dauer
     * @return \BiPRO\StructType\CT_Beitrag
     */
    public function setDauer($dauer = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Dauer::valueIsValid($dauer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Dauer', is_array($dauer) ? implode(', ', $dauer) : var_export($dauer, true), implode(', ', \BiPRO\EnumType\ST_Dauer::getValidValues())), __LINE__);
        }
        $this->Dauer = $dauer;
        return $this;
    }
    /**
     * Get Erhebung value
     * @return \BiPRO\StructType\CT_Zeitraum|null
     */
    public function getErhebung()
    {
        return $this->Erhebung;
    }
    /**
     * Set Erhebung value
     * @param \BiPRO\StructType\CT_Zeitraum $erhebung
     * @return \BiPRO\StructType\CT_Beitrag
     */
    public function setErhebung(\BiPRO\StructType\CT_Zeitraum $erhebung = null)
    {
        $this->Erhebung = $erhebung;
        return $this;
    }
    /**
     * Get VermoegenswirksameLeistung value
     * @return \BiPRO\StructType\CT_VermoegenswirksameLeistung|null
     */
    public function getVermoegenswirksameLeistung()
    {
        return $this->VermoegenswirksameLeistung;
    }
    /**
     * Set VermoegenswirksameLeistung value
     * @param \BiPRO\StructType\CT_VermoegenswirksameLeistung $vermoegenswirksameLeistung
     * @return \BiPRO\StructType\CT_Beitrag
     */
    public function setVermoegenswirksameLeistung(\BiPRO\StructType\CT_VermoegenswirksameLeistung $vermoegenswirksameLeistung = null)
    {
        $this->VermoegenswirksameLeistung = $vermoegenswirksameLeistung;
        return $this;
    }
    /**
     * Get Steuer value
     * @return \BiPRO\StructType\CT_Steuer[]|null
     */
    public function getSteuer()
    {
        return $this->Steuer;
    }
    /**
     * This method is responsible for validating the values passed to the setSteuer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSteuer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSteuerForArrayConstraintsFromSetSteuer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_BeitragSteuerItem) {
            // validation for constraint: itemType
            if (!$cT_BeitragSteuerItem instanceof \BiPRO\StructType\CT_Steuer) {
                $invalidValues[] = is_object($cT_BeitragSteuerItem) ? get_class($cT_BeitragSteuerItem) : sprintf('%s(%s)', gettype($cT_BeitragSteuerItem), var_export($cT_BeitragSteuerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Steuer property can only contain items of type \BiPRO\StructType\CT_Steuer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Steuer value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Steuer[] $steuer
     * @return \BiPRO\StructType\CT_Beitrag
     */
    public function setSteuer(array $steuer = array())
    {
        // validation for constraint: array
        if ('' !== ($steuerArrayErrorMessage = self::validateSteuerForArrayConstraintsFromSetSteuer($steuer))) {
            throw new \InvalidArgumentException($steuerArrayErrorMessage, __LINE__);
        }
        $this->Steuer = $steuer;
        return $this;
    }
    /**
     * Add item to Steuer value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Steuer $item
     * @return \BiPRO\StructType\CT_Beitrag
     */
    public function addToSteuer(\BiPRO\StructType\CT_Steuer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Steuer) {
            throw new \InvalidArgumentException(sprintf('The Steuer property can only contain items of type \BiPRO\StructType\CT_Steuer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Steuer[] = $item;
        return $this;
    }
    /**
     * Get Beitragsfoerderung value
     * @return \BiPRO\StructType\CT_Beitragsfoerderung|null
     */
    public function getBeitragsfoerderung()
    {
        return $this->Beitragsfoerderung;
    }
    /**
     * Set Beitragsfoerderung value
     * @param \BiPRO\StructType\CT_Beitragsfoerderung $beitragsfoerderung
     * @return \BiPRO\StructType\CT_Beitrag
     */
    public function setBeitragsfoerderung(\BiPRO\StructType\CT_Beitragsfoerderung $beitragsfoerderung = null)
    {
        $this->Beitragsfoerderung = $beitragsfoerderung;
        return $this;
    }
    /**
     * Get Beitragsschuldner value
     * @return \BiPRO\StructType\CT_Beitragsschuldner|null
     */
    public function getBeitragsschuldner()
    {
        return $this->Beitragsschuldner;
    }
    /**
     * Set Beitragsschuldner value
     * @param \BiPRO\StructType\CT_Beitragsschuldner $beitragsschuldner
     * @return \BiPRO\StructType\CT_Beitrag
     */
    public function setBeitragsschuldner(\BiPRO\StructType\CT_Beitragsschuldner $beitragsschuldner = null)
    {
        $this->Beitragsschuldner = $beitragsschuldner;
        return $this;
    }
    /**
     * Get BeitragImRueckstand value
     * @return bool|null
     */
    public function getBeitragImRueckstand()
    {
        return $this->BeitragImRueckstand;
    }
    /**
     * Set BeitragImRueckstand value
     * @param bool $beitragImRueckstand
     * @return \BiPRO\StructType\CT_Beitrag
     */
    public function setBeitragImRueckstand($beitragImRueckstand = null)
    {
        // validation for constraint: boolean
        if (!is_null($beitragImRueckstand) && !is_bool($beitragImRueckstand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($beitragImRueckstand, true), gettype($beitragImRueckstand)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($beitragImRueckstand) && !preg_match('/true|false/', $beitragImRueckstand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($beitragImRueckstand, true)), __LINE__);
        }
        $this->BeitragImRueckstand = $beitragImRueckstand;
        return $this;
    }
}
