<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Ausweis StructType
 * Meta information extracted from the WSDL
 * - documentation: Legitimationsdaten (Ausweis, Reisepass, etc.)
 * @subpackage Structs
 */
class CT_Ausweis extends CT_Objekt
{
    /**
     * The Ausweistyp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Ausweistyp;
    /**
     * The AusstellendeBehoerde
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $AusstellendeBehoerde;
    /**
     * The Ausweisnummer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Ausweisnummer;
    /**
     * The GueltigBis
     * Meta information extracted from the WSDL
     * - documentation: Das Ablaufdatum eines Personaldokumentes ist für die Identifizierung einer Person relevant. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $GueltigBis;
    /**
     * The Ausstellungsdatum
     * Meta information extracted from the WSDL
     * - documentation: nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Ausstellungsdatum;
    /**
     * Constructor method for CT_Ausweis
     * @uses CT_Ausweis::setAusweistyp()
     * @uses CT_Ausweis::setAusstellendeBehoerde()
     * @uses CT_Ausweis::setAusweisnummer()
     * @uses CT_Ausweis::setGueltigBis()
     * @uses CT_Ausweis::setAusstellungsdatum()
     * @param string $ausweistyp
     * @param string $ausstellendeBehoerde
     * @param string $ausweisnummer
     * @param string $gueltigBis
     * @param string $ausstellungsdatum
     */
    public function __construct($ausweistyp = null, $ausstellendeBehoerde = null, $ausweisnummer = null, $gueltigBis = null, $ausstellungsdatum = null)
    {
        $this
            ->setAusweistyp($ausweistyp)
            ->setAusstellendeBehoerde($ausstellendeBehoerde)
            ->setAusweisnummer($ausweisnummer)
            ->setGueltigBis($gueltigBis)
            ->setAusstellungsdatum($ausstellungsdatum);
    }
    /**
     * Get Ausweistyp value
     * @return string
     */
    public function getAusweistyp()
    {
        return $this->Ausweistyp;
    }
    /**
     * Set Ausweistyp value
     * @uses \BiPRO\EnumType\ST_Ausweistyp::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Ausweistyp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ausweistyp
     * @return \BiPRO\StructType\CT_Ausweis
     */
    public function setAusweistyp($ausweistyp = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Ausweistyp::valueIsValid($ausweistyp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Ausweistyp', is_array($ausweistyp) ? implode(', ', $ausweistyp) : var_export($ausweistyp, true), implode(', ', \BiPRO\EnumType\ST_Ausweistyp::getValidValues())), __LINE__);
        }
        $this->Ausweistyp = $ausweistyp;
        return $this;
    }
    /**
     * Get AusstellendeBehoerde value
     * @return string|null
     */
    public function getAusstellendeBehoerde()
    {
        return $this->AusstellendeBehoerde;
    }
    /**
     * Set AusstellendeBehoerde value
     * @param string $ausstellendeBehoerde
     * @return \BiPRO\StructType\CT_Ausweis
     */
    public function setAusstellendeBehoerde($ausstellendeBehoerde = null)
    {
        // validation for constraint: string
        if (!is_null($ausstellendeBehoerde) && !is_string($ausstellendeBehoerde)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ausstellendeBehoerde, true), gettype($ausstellendeBehoerde)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($ausstellendeBehoerde) && mb_strlen($ausstellendeBehoerde) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($ausstellendeBehoerde)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ausstellendeBehoerde) && mb_strlen($ausstellendeBehoerde) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ausstellendeBehoerde)), __LINE__);
        }
        $this->AusstellendeBehoerde = $ausstellendeBehoerde;
        return $this;
    }
    /**
     * Get Ausweisnummer value
     * @return string|null
     */
    public function getAusweisnummer()
    {
        return $this->Ausweisnummer;
    }
    /**
     * Set Ausweisnummer value
     * @param string $ausweisnummer
     * @return \BiPRO\StructType\CT_Ausweis
     */
    public function setAusweisnummer($ausweisnummer = null)
    {
        // validation for constraint: string
        if (!is_null($ausweisnummer) && !is_string($ausweisnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ausweisnummer, true), gettype($ausweisnummer)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($ausweisnummer) && mb_strlen($ausweisnummer) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($ausweisnummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ausweisnummer) && mb_strlen($ausweisnummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ausweisnummer)), __LINE__);
        }
        $this->Ausweisnummer = $ausweisnummer;
        return $this;
    }
    /**
     * Get GueltigBis value
     * @return string|null
     */
    public function getGueltigBis()
    {
        return $this->GueltigBis;
    }
    /**
     * Set GueltigBis value
     * @param string $gueltigBis
     * @return \BiPRO\StructType\CT_Ausweis
     */
    public function setGueltigBis($gueltigBis = null)
    {
        // validation for constraint: string
        if (!is_null($gueltigBis) && !is_string($gueltigBis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gueltigBis, true), gettype($gueltigBis)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($gueltigBis) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $gueltigBis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($gueltigBis, true)), __LINE__);
        }
        $this->GueltigBis = $gueltigBis;
        return $this;
    }
    /**
     * Get Ausstellungsdatum value
     * @return string|null
     */
    public function getAusstellungsdatum()
    {
        return $this->Ausstellungsdatum;
    }
    /**
     * Set Ausstellungsdatum value
     * @param string $ausstellungsdatum
     * @return \BiPRO\StructType\CT_Ausweis
     */
    public function setAusstellungsdatum($ausstellungsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($ausstellungsdatum) && !is_string($ausstellungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ausstellungsdatum, true), gettype($ausstellungsdatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($ausstellungsdatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $ausstellungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($ausstellungsdatum, true)), __LINE__);
        }
        $this->Ausstellungsdatum = $ausstellungsdatum;
        return $this;
    }
}
