<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Arbeitsmaschine StructType
 * Meta information extracted from the WSDL
 * - documentation: Zur Abbildung von Fahrzeugen folgender WKZs:701 = Abschleppwagen, die behördlich als Arbeitsmaschinen gemäß Dienstanweisung 1 zum §18 Abs. 2 der StVZO anerkannt sind702 = sonstige Arbeitsmaschinen, gemäß Dienstanweisung, die
 * nicht als 705, 712 oder 713 geschlüsselt sind.705 = Straßenreinigungs- und Sprengwagen, Müll- und Fäkalienabfuhrwagen sowie Schneepflüge, auch wenn diese als selbstfahrende Arbeitsmaschinen anerkannt sind gemäß Dienstanweisung 13, 49, 75 oder
 * 88708 = Hub- und Gabelstapler712 = Auto-/Mobilkräne inkl. Bergungsfahrzeuge gemäß Dienstanweisung 50, 53 oder 64713 = Betonpumpen, Betonmischmaschinen gemäß Dienstanweisung 3 oder 36
 * @subpackage Structs
 */
class CT_Arbeitsmaschine extends CT_Fahrzeug
{
    /**
     * The ZulaessigesGesamtgewicht
     * Meta information extracted from the WSDL
     * - documentation: Zulässiges Gesamtgewicht in kg.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $ZulaessigesGesamtgewicht;
    /**
     * The ArbeitsmaschineNutzung
     * Meta information extracted from the WSDL
     * - documentation: Nutzung der Arbeitsmaschine.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_ArbeitsmaschineNutzung
     */
    public $ArbeitsmaschineNutzung;
    /**
     * Constructor method for CT_Arbeitsmaschine
     * @uses CT_Arbeitsmaschine::setZulaessigesGesamtgewicht()
     * @uses CT_Arbeitsmaschine::setArbeitsmaschineNutzung()
     * @param float $zulaessigesGesamtgewicht
     * @param \BiPRO\StructType\CT_ArbeitsmaschineNutzung $arbeitsmaschineNutzung
     */
    public function __construct($zulaessigesGesamtgewicht = null, \BiPRO\StructType\CT_ArbeitsmaschineNutzung $arbeitsmaschineNutzung = null)
    {
        $this
            ->setZulaessigesGesamtgewicht($zulaessigesGesamtgewicht)
            ->setArbeitsmaschineNutzung($arbeitsmaschineNutzung);
    }
    /**
     * Get ZulaessigesGesamtgewicht value
     * @return float|null
     */
    public function getZulaessigesGesamtgewicht()
    {
        return $this->ZulaessigesGesamtgewicht;
    }
    /**
     * Set ZulaessigesGesamtgewicht value
     * @param float $zulaessigesGesamtgewicht
     * @return \BiPRO\StructType\CT_Arbeitsmaschine
     */
    public function setZulaessigesGesamtgewicht($zulaessigesGesamtgewicht = null)
    {
        // validation for constraint: float
        if (!is_null($zulaessigesGesamtgewicht) && !(is_float($zulaessigesGesamtgewicht) || is_numeric($zulaessigesGesamtgewicht))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($zulaessigesGesamtgewicht, true), gettype($zulaessigesGesamtgewicht)), __LINE__);
        }
        $this->ZulaessigesGesamtgewicht = $zulaessigesGesamtgewicht;
        return $this;
    }
    /**
     * Get ArbeitsmaschineNutzung value
     * @return \BiPRO\StructType\CT_ArbeitsmaschineNutzung|null
     */
    public function getArbeitsmaschineNutzung()
    {
        return $this->ArbeitsmaschineNutzung;
    }
    /**
     * Set ArbeitsmaschineNutzung value
     * @param \BiPRO\StructType\CT_ArbeitsmaschineNutzung $arbeitsmaschineNutzung
     * @return \BiPRO\StructType\CT_Arbeitsmaschine
     */
    public function setArbeitsmaschineNutzung(\BiPRO\StructType\CT_ArbeitsmaschineNutzung $arbeitsmaschineNutzung = null)
    {
        $this->ArbeitsmaschineNutzung = $arbeitsmaschineNutzung;
        return $this;
    }
}
