<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_AnzahlBeschaeftigte StructType
 * Meta information extracted from the WSDL
 * - documentation: Anzahl der Beschäftigten einer juristischen Person. Dies wird als Nominell Beschäftigte in MAK (Mitarbeiter-Kapazitäten) und/oder als Effektiv Beschäftigte (alle Mitarbeiter ohne Berücksichtigung des Beschäftigungstyps)
 * angegeben.Mitarbeitende Familienangehörige sowie der Inhaber/Geschäftsführer sind selbst nicht mitzuzählen, sind aber trotzdem mitversichert.Bei einem Unternehmen ohne Beschäftigte darf diese Klasse nicht geliefert werden.Wenn es nur ein Objekt
 * gibt, DARF auf die ArtID verzichtet werden, da von Vollzeitmitarbeitern ausgegangen wird. Werden mehrere Objekte übergeben, MUSS zur Anzahl der nominell Beschäftigten jeweils die ArtID angegeben werden.
 * @subpackage Structs
 */
class CT_AnzahlBeschaeftigte extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Beschäftigte, die im Betrieb des Versicherten tätig sind.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtID;
    /**
     * The Nominell
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der nominell Beschäftigten ohne Berücksichtigung des Beschäftigungstyps.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Nominell;
    /**
     * The Effektiv
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der effektiv Beschäftigten mit Berücksichtigung des Beschäftigungstyps.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Effektiv;
    /**
     * Constructor method for CT_AnzahlBeschaeftigte
     * @uses CT_AnzahlBeschaeftigte::setArtID()
     * @uses CT_AnzahlBeschaeftigte::setNominell()
     * @uses CT_AnzahlBeschaeftigte::setEffektiv()
     * @param string $artID
     * @param int $nominell
     * @param float $effektiv
     */
    public function __construct($artID = null, $nominell = null, $effektiv = null)
    {
        $this
            ->setArtID($artID)
            ->setNominell($nominell)
            ->setEffektiv($effektiv);
    }
    /**
     * Get ArtID value
     * @return string|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_Beschaeftigtentyp::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Beschaeftigtentyp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_AnzahlBeschaeftigte
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Beschaeftigtentyp::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Beschaeftigtentyp', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_Beschaeftigtentyp::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Nominell value
     * @return int|null
     */
    public function getNominell()
    {
        return $this->Nominell;
    }
    /**
     * Set Nominell value
     * @param int $nominell
     * @return \BiPRO\StructType\CT_AnzahlBeschaeftigte
     */
    public function setNominell($nominell = null)
    {
        // validation for constraint: int
        if (!is_null($nominell) && !(is_int($nominell) || ctype_digit($nominell))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nominell, true), gettype($nominell)), __LINE__);
        }
        $this->Nominell = $nominell;
        return $this;
    }
    /**
     * Get Effektiv value
     * @return float|null
     */
    public function getEffektiv()
    {
        return $this->Effektiv;
    }
    /**
     * Set Effektiv value
     * @param float $effektiv
     * @return \BiPRO\StructType\CT_AnzahlBeschaeftigte
     */
    public function setEffektiv($effektiv = null)
    {
        // validation for constraint: float
        if (!is_null($effektiv) && !(is_float($effektiv) || is_numeric($effektiv))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($effektiv, true), gettype($effektiv)), __LINE__);
        }
        $this->Effektiv = $effektiv;
        return $this;
    }
}
