<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_AntwortZeitraum StructType
 * Meta information extracted from the WSDL
 * - documentation: Ableitung der Klasse Antwort zur typisierten Übertragung eines Zeitraumes als Antwort.
 * @subpackage Structs
 */
class CT_AntwortZeitraum extends CT_Antwort
{
    /**
     * The Von
     * Meta information extracted from the WSDL
     * - documentation: Von Datum der Antwort Zeitraum | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Von;
    /**
     * The Bis
     * Meta information extracted from the WSDL
     * - documentation: Bis Datum der Antwort Zeitraum | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Bis;
    /**
     * Constructor method for CT_AntwortZeitraum
     * @uses CT_AntwortZeitraum::setVon()
     * @uses CT_AntwortZeitraum::setBis()
     * @param string $von
     * @param string $bis
     */
    public function __construct($von = null, $bis = null)
    {
        $this
            ->setVon($von)
            ->setBis($bis);
    }
    /**
     * Get Von value
     * @return string
     */
    public function getVon()
    {
        return $this->Von;
    }
    /**
     * Set Von value
     * @param string $von
     * @return \BiPRO\StructType\CT_AntwortZeitraum
     */
    public function setVon($von = null)
    {
        // validation for constraint: string
        if (!is_null($von) && !is_string($von)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($von, true), gettype($von)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($von) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $von)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($von, true)), __LINE__);
        }
        $this->Von = $von;
        return $this;
    }
    /**
     * Get Bis value
     * @return string
     */
    public function getBis()
    {
        return $this->Bis;
    }
    /**
     * Set Bis value
     * @param string $bis
     * @return \BiPRO\StructType\CT_AntwortZeitraum
     */
    public function setBis($bis = null)
    {
        // validation for constraint: string
        if (!is_null($bis) && !is_string($bis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bis, true), gettype($bis)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($bis) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $bis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($bis, true)), __LINE__);
        }
        $this->Bis = $bis;
        return $this;
    }
}
