<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_AntragsdatenKfz StructType
 * @subpackage Structs
 */
class CT_AntragsdatenKfz extends CT_ZusaetzlicheAntragsdaten
{
    /**
     * The Flottennummer
     * Meta information extracted from the WSDL
     * - documentation: Das Fahrzeug soll im Rahmen dieser Flottenvertragsnummer versichert werden.
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Flottennummer;
    /**
     * The IVKErwuenscht
     * Meta information extracted from the WSDL
     * - documentation: Die Ausstellung einer Internationalen Versicherungskarte (IVK) ist vom Versicherungsnehmer gewünscht.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $IVKErwuenscht;
    /**
     * Constructor method for CT_AntragsdatenKfz
     * @uses CT_AntragsdatenKfz::setFlottennummer()
     * @uses CT_AntragsdatenKfz::setIVKErwuenscht()
     * @param string $flottennummer
     * @param bool $iVKErwuenscht
     */
    public function __construct($flottennummer = null, $iVKErwuenscht = null)
    {
        $this
            ->setFlottennummer($flottennummer)
            ->setIVKErwuenscht($iVKErwuenscht);
    }
    /**
     * Get Flottennummer value
     * @return string|null
     */
    public function getFlottennummer()
    {
        return $this->Flottennummer;
    }
    /**
     * Set Flottennummer value
     * @param string $flottennummer
     * @return \BiPRO\StructType\CT_AntragsdatenKfz
     */
    public function setFlottennummer($flottennummer = null)
    {
        // validation for constraint: string
        if (!is_null($flottennummer) && !is_string($flottennummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flottennummer, true), gettype($flottennummer)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($flottennummer) && mb_strlen($flottennummer) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($flottennummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($flottennummer) && mb_strlen($flottennummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($flottennummer)), __LINE__);
        }
        $this->Flottennummer = $flottennummer;
        return $this;
    }
    /**
     * Get IVKErwuenscht value
     * @return bool|null
     */
    public function getIVKErwuenscht()
    {
        return $this->IVKErwuenscht;
    }
    /**
     * Set IVKErwuenscht value
     * @param bool $iVKErwuenscht
     * @return \BiPRO\StructType\CT_AntragsdatenKfz
     */
    public function setIVKErwuenscht($iVKErwuenscht = null)
    {
        // validation for constraint: boolean
        if (!is_null($iVKErwuenscht) && !is_bool($iVKErwuenscht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($iVKErwuenscht, true), gettype($iVKErwuenscht)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($iVKErwuenscht) && !preg_match('/true|false/', $iVKErwuenscht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($iVKErwuenscht, true)), __LINE__);
        }
        $this->IVKErwuenscht = $iVKErwuenscht;
        return $this;
    }
}
