<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Antrag StructType
 * Meta information extracted from the WSDL
 * - documentation: Geschaeftsvorgang Antrag. Darf nicht spartenspezifisch abgeleitet werden, da sonst die spartenuebergreifende Buendelung von Produkten nicht mehr moeglich waere.Die Attribute Modell (ST_Antragsmodell), ArtDerBeratung
 * (ST_ArtDerBeratung) und BedingungenUebergabeForm (ST_BedingungenUebergabeForm) fehlen, da die entsprechenden einfachen Datentypen nicht definiert sind.
 * @subpackage Structs
 */
class CT_Antrag extends CT_TAA
{
    /**
     * The Hauptfaelligkeit
     * Meta information extracted from the WSDL
     * - documentation: nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Hauptfaelligkeit;
    /**
     * The Aktionskennzeichen
     * Meta information extracted from the WSDL
     * - documentation: Internes Kennzeichen einer (z. B. vertrieblichen) Aktion.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Aktionskennzeichen;
    /**
     * The Antragsdatum
     * Meta information extracted from the WSDL
     * - documentation: Datum, an dem der Antrag gestellt wurde. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Antragsdatum;
    /**
     * The BedingungenZurKenntnisGenommen
     * Meta information extracted from the WSDL
     * - documentation: Ja = VN hat Bedingungen zur Kenntnis genommen (gemaess Antragsmodell).Nein = sonst
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $BedingungenZurKenntnisGenommen;
    /**
     * The BesondereVereinbarungen
     * Meta information extracted from the WSDL
     * - documentation: Besondere Vereinbarungen mit dem Kunden zum Antrag.
     * - base: xsd:string
     * - maxLength: 1000
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $BesondereVereinbarungen;
    /**
     * The AktenzeichenVM
     * Meta information extracted from the WSDL
     * - documentation: Zuordnungsmerkmal des Vermittlers, z. B. Niederlassung/Büro des Vermittlers, Sachbearbeiter des Vermittlers, Vertragsnummer des Vermittlers. Das im Antrag übermittelte AktenzeichenVM MUSS vom Versicherer bei der Policierung zum
     * Vertrag gespeichert und bei vertragsbezogenen Geschäftsvorgängen im Objekt Vertrag ausgegeben werden.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $AktenzeichenVM;
    /**
     * The AktenzeichenVN
     * Meta information extracted from the WSDL
     * - documentation: Zuordnungsmerkmal des Versicherungsnehmers (VN), z. B. Niederlassung, Betriebsstätte, Abteilung, Kostenstelle des VN. Das im Antrag übermittelte AktenzeichenVN MUSS vom Versicherer bei der Policierung zum Vertrag gespeichert und
     * bei vertragsbezogenen Geschäftsvorgängen im Objekt Vertrag ausgegeben werden.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $AktenzeichenVN;
    /**
     * The EinwilligungInformationsanfrage
     * Meta information extracted from the WSDL
     * - documentation: Einwilligung zur Informationseinholung bei Dritten.Ja = Einwilligung liegt vorNein = sonst
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $EinwilligungInformationsanfrage;
    /**
     * The VVGBeratungsverzicht
     * Meta information extracted from the WSDL
     * - documentation: Erklärung des Kunden, auf eine Beratung durch den Vermittler zu verzichten.Ja = Kunde hat Entsprechendes erklärtNein = Sonst
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $VVGBeratungsverzicht;
    /**
     * The AntragUnterschrieben
     * Meta information extracted from the WSDL
     * - documentation: Angabe, ob ein unterschriebener Antrag (elektronisch oder materiell) vorliegt.Ja = Ein entsprechender Antrag liegt vorNein = sonst
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $AntragUnterschrieben;
    /**
     * The ZustimmungFinanzdienstleister
     * Meta information extracted from the WSDL
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $ZustimmungFinanzdienstleister;
    /**
     * The DatenschutzerklaerungUnterschrieben
     * Meta information extracted from the WSDL
     * - documentation: Angabe, ob die Datenschutzerklärung vom Kunden unterschrieben wurde.Ja = Datenschutzerklärung wurde vom Kunden unterschriebenNein = sonst
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $DatenschutzerklaerungUnterschrieben;
    /**
     * The Abschlussmodell
     * Meta information extracted from the WSDL
     * - documentation: Art des Abschlussmodells (z.B. Antragsmodell, Invitatiomodell).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Abschlussmodell;
    /**
     * The ArtDerBeratung
     * Meta information extracted from the WSDL
     * - documentation: Art, wie der Kunde vom Vermittler beraten wurde (z.B. durch persönliches Gespräch).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtDerBeratung;
    /**
     * The BedingungUebergabeform
     * Meta information extracted from the WSDL
     * - documentation: Art, wie dem Kunden die VVG-konformen Versicherungsbedingungen ausgehändigt wurden (z.B. durch E-Mail).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BedingungUebergabeform;
    /**
     * The Unterschriftsverfahren
     * Meta information extracted from the WSDL
     * - documentation: Attribut zur Festlegung, wie die Willenserklärung erfolgt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Unterschriftsverfahren;
    /**
     * The DatenschutzerklaerungKenntnisnahme
     * Meta information extracted from the WSDL
     * - documentation: Art, wie der Kunde über die Datenschutzerklärung aufgeklärt wurde (z.B. durch Aushändigung).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DatenschutzerklaerungKenntnisnahme;
    /**
     * The Antragsart
     * Meta information extracted from the WSDL
     * - documentation: deprecated 2.7: Ab Version 2.7 DARF dieses Attribut nicht mehr genutzt werden. Statt dessen MUSS eine entsprechende GeVo-Art im geerbten Attribut Art angegeben werden.Antrag.Antragsart=01 (Neuantrag) MUSS über Antrag.Art=100001010
     * (Antrag-Neugeschäft - Neuantrag) abgebildet werden.Antrag.Antragsart=02 (Ersatzantrag) MUSS über Antrag.Art=100001030 (Antrag-Neugeschäft - Ersatzantrag) abgebildet werden.Antrag.Antragsart=03 (Versichererwechsel) MUSS über Antrag.Art=100001050
     * (Antrag-Neugeschäft - Versichererwechsel) abgebildet werden.Antrag.Antragsart=04 (Umstellungsantrag / Tarifwechsel) MUSS über Antrag.Art=120022000 (Vertrag-Änderung - Tarifumstellung) abgebildet werden.Antrag.Antragsart=05 (Fahrzeugwechsel) MUSS
     * über Antrag.Art=120010111 (Vertrag-Änderung - Fahrzeugwechsel) abgebildet werden.Antrag.Antragsart=06 (Überführung in eine andere Schicht...) MUSS über Antrag.Art=100001040 (Antrag-Neugeschäft - Überführung in andere Schicht) abgebildet
     * werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Antragsart;
    /**
     * The Vertragsnummer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Vertragsnummer
     */
    public $Vertragsnummer;
    /**
     * The ZusaetzlicheAntragsdaten
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_ZusaetzlicheAntragsdaten[]
     */
    public $ZusaetzlicheAntragsdaten;
    /**
     * The Beitragszahler
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Beitragszahler
     */
    public $Beitragszahler;
    /**
     * Constructor method for CT_Antrag
     * @uses CT_Antrag::setHauptfaelligkeit()
     * @uses CT_Antrag::setAktionskennzeichen()
     * @uses CT_Antrag::setAntragsdatum()
     * @uses CT_Antrag::setBedingungenZurKenntnisGenommen()
     * @uses CT_Antrag::setBesondereVereinbarungen()
     * @uses CT_Antrag::setAktenzeichenVM()
     * @uses CT_Antrag::setAktenzeichenVN()
     * @uses CT_Antrag::setEinwilligungInformationsanfrage()
     * @uses CT_Antrag::setVVGBeratungsverzicht()
     * @uses CT_Antrag::setAntragUnterschrieben()
     * @uses CT_Antrag::setZustimmungFinanzdienstleister()
     * @uses CT_Antrag::setDatenschutzerklaerungUnterschrieben()
     * @uses CT_Antrag::setAbschlussmodell()
     * @uses CT_Antrag::setArtDerBeratung()
     * @uses CT_Antrag::setBedingungUebergabeform()
     * @uses CT_Antrag::setUnterschriftsverfahren()
     * @uses CT_Antrag::setDatenschutzerklaerungKenntnisnahme()
     * @uses CT_Antrag::setAntragsart()
     * @uses CT_Antrag::setVertragsnummer()
     * @uses CT_Antrag::setZusaetzlicheAntragsdaten()
     * @uses CT_Antrag::setBeitragszahler()
     * @param string $hauptfaelligkeit
     * @param string $aktionskennzeichen
     * @param string $antragsdatum
     * @param bool $bedingungenZurKenntnisGenommen
     * @param string $besondereVereinbarungen
     * @param string $aktenzeichenVM
     * @param string $aktenzeichenVN
     * @param bool $einwilligungInformationsanfrage
     * @param bool $vVGBeratungsverzicht
     * @param bool $antragUnterschrieben
     * @param bool $zustimmungFinanzdienstleister
     * @param bool $datenschutzerklaerungUnterschrieben
     * @param string $abschlussmodell
     * @param string $artDerBeratung
     * @param string $bedingungUebergabeform
     * @param string $unterschriftsverfahren
     * @param string $datenschutzerklaerungKenntnisnahme
     * @param string $antragsart
     * @param \BiPRO\StructType\CT_Vertragsnummer $vertragsnummer
     * @param \BiPRO\StructType\CT_ZusaetzlicheAntragsdaten[] $zusaetzlicheAntragsdaten
     * @param \BiPRO\StructType\CT_Beitragszahler $beitragszahler
     */
    public function __construct($hauptfaelligkeit = null, $aktionskennzeichen = null, $antragsdatum = null, $bedingungenZurKenntnisGenommen = null, $besondereVereinbarungen = null, $aktenzeichenVM = null, $aktenzeichenVN = null, $einwilligungInformationsanfrage = null, $vVGBeratungsverzicht = null, $antragUnterschrieben = null, $zustimmungFinanzdienstleister = null, $datenschutzerklaerungUnterschrieben = null, $abschlussmodell = null, $artDerBeratung = null, $bedingungUebergabeform = null, $unterschriftsverfahren = null, $datenschutzerklaerungKenntnisnahme = null, $antragsart = null, \BiPRO\StructType\CT_Vertragsnummer $vertragsnummer = null, array $zusaetzlicheAntragsdaten = array(), \BiPRO\StructType\CT_Beitragszahler $beitragszahler = null)
    {
        $this
            ->setHauptfaelligkeit($hauptfaelligkeit)
            ->setAktionskennzeichen($aktionskennzeichen)
            ->setAntragsdatum($antragsdatum)
            ->setBedingungenZurKenntnisGenommen($bedingungenZurKenntnisGenommen)
            ->setBesondereVereinbarungen($besondereVereinbarungen)
            ->setAktenzeichenVM($aktenzeichenVM)
            ->setAktenzeichenVN($aktenzeichenVN)
            ->setEinwilligungInformationsanfrage($einwilligungInformationsanfrage)
            ->setVVGBeratungsverzicht($vVGBeratungsverzicht)
            ->setAntragUnterschrieben($antragUnterschrieben)
            ->setZustimmungFinanzdienstleister($zustimmungFinanzdienstleister)
            ->setDatenschutzerklaerungUnterschrieben($datenschutzerklaerungUnterschrieben)
            ->setAbschlussmodell($abschlussmodell)
            ->setArtDerBeratung($artDerBeratung)
            ->setBedingungUebergabeform($bedingungUebergabeform)
            ->setUnterschriftsverfahren($unterschriftsverfahren)
            ->setDatenschutzerklaerungKenntnisnahme($datenschutzerklaerungKenntnisnahme)
            ->setAntragsart($antragsart)
            ->setVertragsnummer($vertragsnummer)
            ->setZusaetzlicheAntragsdaten($zusaetzlicheAntragsdaten)
            ->setBeitragszahler($beitragszahler);
    }
    /**
     * Get Hauptfaelligkeit value
     * @return string|null
     */
    public function getHauptfaelligkeit()
    {
        return $this->Hauptfaelligkeit;
    }
    /**
     * Set Hauptfaelligkeit value
     * @param string $hauptfaelligkeit
     * @return \BiPRO\StructType\CT_Antrag
     */
    public function setHauptfaelligkeit($hauptfaelligkeit = null)
    {
        // validation for constraint: string
        if (!is_null($hauptfaelligkeit) && !is_string($hauptfaelligkeit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hauptfaelligkeit, true), gettype($hauptfaelligkeit)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($hauptfaelligkeit) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $hauptfaelligkeit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($hauptfaelligkeit, true)), __LINE__);
        }
        $this->Hauptfaelligkeit = $hauptfaelligkeit;
        return $this;
    }
    /**
     * Get Aktionskennzeichen value
     * @return string|null
     */
    public function getAktionskennzeichen()
    {
        return $this->Aktionskennzeichen;
    }
    /**
     * Set Aktionskennzeichen value
     * @param string $aktionskennzeichen
     * @return \BiPRO\StructType\CT_Antrag
     */
    public function setAktionskennzeichen($aktionskennzeichen = null)
    {
        // validation for constraint: string
        if (!is_null($aktionskennzeichen) && !is_string($aktionskennzeichen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aktionskennzeichen, true), gettype($aktionskennzeichen)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($aktionskennzeichen) && mb_strlen($aktionskennzeichen) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($aktionskennzeichen)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($aktionskennzeichen) && mb_strlen($aktionskennzeichen) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($aktionskennzeichen)), __LINE__);
        }
        $this->Aktionskennzeichen = $aktionskennzeichen;
        return $this;
    }
    /**
     * Get Antragsdatum value
     * @return string|null
     */
    public function getAntragsdatum()
    {
        return $this->Antragsdatum;
    }
    /**
     * Set Antragsdatum value
     * @param string $antragsdatum
     * @return \BiPRO\StructType\CT_Antrag
     */
    public function setAntragsdatum($antragsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($antragsdatum) && !is_string($antragsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($antragsdatum, true), gettype($antragsdatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($antragsdatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $antragsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($antragsdatum, true)), __LINE__);
        }
        $this->Antragsdatum = $antragsdatum;
        return $this;
    }
    /**
     * Get BedingungenZurKenntnisGenommen value
     * @return bool|null
     */
    public function getBedingungenZurKenntnisGenommen()
    {
        return $this->BedingungenZurKenntnisGenommen;
    }
    /**
     * Set BedingungenZurKenntnisGenommen value
     * @param bool $bedingungenZurKenntnisGenommen
     * @return \BiPRO\StructType\CT_Antrag
     */
    public function setBedingungenZurKenntnisGenommen($bedingungenZurKenntnisGenommen = null)
    {
        // validation for constraint: boolean
        if (!is_null($bedingungenZurKenntnisGenommen) && !is_bool($bedingungenZurKenntnisGenommen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bedingungenZurKenntnisGenommen, true), gettype($bedingungenZurKenntnisGenommen)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($bedingungenZurKenntnisGenommen) && !preg_match('/true|false/', $bedingungenZurKenntnisGenommen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($bedingungenZurKenntnisGenommen, true)), __LINE__);
        }
        $this->BedingungenZurKenntnisGenommen = $bedingungenZurKenntnisGenommen;
        return $this;
    }
    /**
     * Get BesondereVereinbarungen value
     * @return string|null
     */
    public function getBesondereVereinbarungen()
    {
        return $this->BesondereVereinbarungen;
    }
    /**
     * Set BesondereVereinbarungen value
     * @param string $besondereVereinbarungen
     * @return \BiPRO\StructType\CT_Antrag
     */
    public function setBesondereVereinbarungen($besondereVereinbarungen = null)
    {
        // validation for constraint: string
        if (!is_null($besondereVereinbarungen) && !is_string($besondereVereinbarungen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($besondereVereinbarungen, true), gettype($besondereVereinbarungen)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($besondereVereinbarungen) && mb_strlen($besondereVereinbarungen) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen($besondereVereinbarungen)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($besondereVereinbarungen) && mb_strlen($besondereVereinbarungen) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($besondereVereinbarungen)), __LINE__);
        }
        $this->BesondereVereinbarungen = $besondereVereinbarungen;
        return $this;
    }
    /**
     * Get AktenzeichenVM value
     * @return string|null
     */
    public function getAktenzeichenVM()
    {
        return $this->AktenzeichenVM;
    }
    /**
     * Set AktenzeichenVM value
     * @param string $aktenzeichenVM
     * @return \BiPRO\StructType\CT_Antrag
     */
    public function setAktenzeichenVM($aktenzeichenVM = null)
    {
        // validation for constraint: string
        if (!is_null($aktenzeichenVM) && !is_string($aktenzeichenVM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aktenzeichenVM, true), gettype($aktenzeichenVM)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($aktenzeichenVM) && mb_strlen($aktenzeichenVM) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($aktenzeichenVM)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($aktenzeichenVM) && mb_strlen($aktenzeichenVM) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($aktenzeichenVM)), __LINE__);
        }
        $this->AktenzeichenVM = $aktenzeichenVM;
        return $this;
    }
    /**
     * Get AktenzeichenVN value
     * @return string|null
     */
    public function getAktenzeichenVN()
    {
        return $this->AktenzeichenVN;
    }
    /**
     * Set AktenzeichenVN value
     * @param string $aktenzeichenVN
     * @return \BiPRO\StructType\CT_Antrag
     */
    public function setAktenzeichenVN($aktenzeichenVN = null)
    {
        // validation for constraint: string
        if (!is_null($aktenzeichenVN) && !is_string($aktenzeichenVN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aktenzeichenVN, true), gettype($aktenzeichenVN)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($aktenzeichenVN) && mb_strlen($aktenzeichenVN) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($aktenzeichenVN)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($aktenzeichenVN) && mb_strlen($aktenzeichenVN) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($aktenzeichenVN)), __LINE__);
        }
        $this->AktenzeichenVN = $aktenzeichenVN;
        return $this;
    }
    /**
     * Get EinwilligungInformationsanfrage value
     * @return bool|null
     */
    public function getEinwilligungInformationsanfrage()
    {
        return $this->EinwilligungInformationsanfrage;
    }
    /**
     * Set EinwilligungInformationsanfrage value
     * @param bool $einwilligungInformationsanfrage
     * @return \BiPRO\StructType\CT_Antrag
     */
    public function setEinwilligungInformationsanfrage($einwilligungInformationsanfrage = null)
    {
        // validation for constraint: boolean
        if (!is_null($einwilligungInformationsanfrage) && !is_bool($einwilligungInformationsanfrage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($einwilligungInformationsanfrage, true), gettype($einwilligungInformationsanfrage)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($einwilligungInformationsanfrage) && !preg_match('/true|false/', $einwilligungInformationsanfrage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($einwilligungInformationsanfrage, true)), __LINE__);
        }
        $this->EinwilligungInformationsanfrage = $einwilligungInformationsanfrage;
        return $this;
    }
    /**
     * Get VVGBeratungsverzicht value
     * @return bool|null
     */
    public function getVVGBeratungsverzicht()
    {
        return $this->VVGBeratungsverzicht;
    }
    /**
     * Set VVGBeratungsverzicht value
     * @param bool $vVGBeratungsverzicht
     * @return \BiPRO\StructType\CT_Antrag
     */
    public function setVVGBeratungsverzicht($vVGBeratungsverzicht = null)
    {
        // validation for constraint: boolean
        if (!is_null($vVGBeratungsverzicht) && !is_bool($vVGBeratungsverzicht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vVGBeratungsverzicht, true), gettype($vVGBeratungsverzicht)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($vVGBeratungsverzicht) && !preg_match('/true|false/', $vVGBeratungsverzicht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($vVGBeratungsverzicht, true)), __LINE__);
        }
        $this->VVGBeratungsverzicht = $vVGBeratungsverzicht;
        return $this;
    }
    /**
     * Get AntragUnterschrieben value
     * @return bool|null
     */
    public function getAntragUnterschrieben()
    {
        return $this->AntragUnterschrieben;
    }
    /**
     * Set AntragUnterschrieben value
     * @param bool $antragUnterschrieben
     * @return \BiPRO\StructType\CT_Antrag
     */
    public function setAntragUnterschrieben($antragUnterschrieben = null)
    {
        // validation for constraint: boolean
        if (!is_null($antragUnterschrieben) && !is_bool($antragUnterschrieben)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($antragUnterschrieben, true), gettype($antragUnterschrieben)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($antragUnterschrieben) && !preg_match('/true|false/', $antragUnterschrieben)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($antragUnterschrieben, true)), __LINE__);
        }
        $this->AntragUnterschrieben = $antragUnterschrieben;
        return $this;
    }
    /**
     * Get ZustimmungFinanzdienstleister value
     * @return bool|null
     */
    public function getZustimmungFinanzdienstleister()
    {
        return $this->ZustimmungFinanzdienstleister;
    }
    /**
     * Set ZustimmungFinanzdienstleister value
     * @param bool $zustimmungFinanzdienstleister
     * @return \BiPRO\StructType\CT_Antrag
     */
    public function setZustimmungFinanzdienstleister($zustimmungFinanzdienstleister = null)
    {
        // validation for constraint: boolean
        if (!is_null($zustimmungFinanzdienstleister) && !is_bool($zustimmungFinanzdienstleister)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($zustimmungFinanzdienstleister, true), gettype($zustimmungFinanzdienstleister)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($zustimmungFinanzdienstleister) && !preg_match('/true|false/', $zustimmungFinanzdienstleister)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($zustimmungFinanzdienstleister, true)), __LINE__);
        }
        $this->ZustimmungFinanzdienstleister = $zustimmungFinanzdienstleister;
        return $this;
    }
    /**
     * Get DatenschutzerklaerungUnterschrieben value
     * @return bool|null
     */
    public function getDatenschutzerklaerungUnterschrieben()
    {
        return $this->DatenschutzerklaerungUnterschrieben;
    }
    /**
     * Set DatenschutzerklaerungUnterschrieben value
     * @param bool $datenschutzerklaerungUnterschrieben
     * @return \BiPRO\StructType\CT_Antrag
     */
    public function setDatenschutzerklaerungUnterschrieben($datenschutzerklaerungUnterschrieben = null)
    {
        // validation for constraint: boolean
        if (!is_null($datenschutzerklaerungUnterschrieben) && !is_bool($datenschutzerklaerungUnterschrieben)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($datenschutzerklaerungUnterschrieben, true), gettype($datenschutzerklaerungUnterschrieben)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($datenschutzerklaerungUnterschrieben) && !preg_match('/true|false/', $datenschutzerklaerungUnterschrieben)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($datenschutzerklaerungUnterschrieben, true)), __LINE__);
        }
        $this->DatenschutzerklaerungUnterschrieben = $datenschutzerklaerungUnterschrieben;
        return $this;
    }
    /**
     * Get Abschlussmodell value
     * @return string|null
     */
    public function getAbschlussmodell()
    {
        return $this->Abschlussmodell;
    }
    /**
     * Set Abschlussmodell value
     * @uses \BiPRO\EnumType\ST_Abschlussmodell::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Abschlussmodell::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $abschlussmodell
     * @return \BiPRO\StructType\CT_Antrag
     */
    public function setAbschlussmodell($abschlussmodell = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Abschlussmodell::valueIsValid($abschlussmodell)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Abschlussmodell', is_array($abschlussmodell) ? implode(', ', $abschlussmodell) : var_export($abschlussmodell, true), implode(', ', \BiPRO\EnumType\ST_Abschlussmodell::getValidValues())), __LINE__);
        }
        $this->Abschlussmodell = $abschlussmodell;
        return $this;
    }
    /**
     * Get ArtDerBeratung value
     * @return string|null
     */
    public function getArtDerBeratung()
    {
        return $this->ArtDerBeratung;
    }
    /**
     * Set ArtDerBeratung value
     * @uses \BiPRO\EnumType\ST_ArtDerBeratung::valueIsValid()
     * @uses \BiPRO\EnumType\ST_ArtDerBeratung::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artDerBeratung
     * @return \BiPRO\StructType\CT_Antrag
     */
    public function setArtDerBeratung($artDerBeratung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_ArtDerBeratung::valueIsValid($artDerBeratung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_ArtDerBeratung', is_array($artDerBeratung) ? implode(', ', $artDerBeratung) : var_export($artDerBeratung, true), implode(', ', \BiPRO\EnumType\ST_ArtDerBeratung::getValidValues())), __LINE__);
        }
        $this->ArtDerBeratung = $artDerBeratung;
        return $this;
    }
    /**
     * Get BedingungUebergabeform value
     * @return string|null
     */
    public function getBedingungUebergabeform()
    {
        return $this->BedingungUebergabeform;
    }
    /**
     * Set BedingungUebergabeform value
     * @uses \BiPRO\EnumType\ST_BedingungUebergabeform::valueIsValid()
     * @uses \BiPRO\EnumType\ST_BedingungUebergabeform::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bedingungUebergabeform
     * @return \BiPRO\StructType\CT_Antrag
     */
    public function setBedingungUebergabeform($bedingungUebergabeform = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_BedingungUebergabeform::valueIsValid($bedingungUebergabeform)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_BedingungUebergabeform', is_array($bedingungUebergabeform) ? implode(', ', $bedingungUebergabeform) : var_export($bedingungUebergabeform, true), implode(', ', \BiPRO\EnumType\ST_BedingungUebergabeform::getValidValues())), __LINE__);
        }
        $this->BedingungUebergabeform = $bedingungUebergabeform;
        return $this;
    }
    /**
     * Get Unterschriftsverfahren value
     * @return string|null
     */
    public function getUnterschriftsverfahren()
    {
        return $this->Unterschriftsverfahren;
    }
    /**
     * Set Unterschriftsverfahren value
     * @uses \BiPRO\EnumType\ST_Unterschriftsverfahren::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Unterschriftsverfahren::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unterschriftsverfahren
     * @return \BiPRO\StructType\CT_Antrag
     */
    public function setUnterschriftsverfahren($unterschriftsverfahren = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Unterschriftsverfahren::valueIsValid($unterschriftsverfahren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Unterschriftsverfahren', is_array($unterschriftsverfahren) ? implode(', ', $unterschriftsverfahren) : var_export($unterschriftsverfahren, true), implode(', ', \BiPRO\EnumType\ST_Unterschriftsverfahren::getValidValues())), __LINE__);
        }
        $this->Unterschriftsverfahren = $unterschriftsverfahren;
        return $this;
    }
    /**
     * Get DatenschutzerklaerungKenntnisnahme value
     * @return string|null
     */
    public function getDatenschutzerklaerungKenntnisnahme()
    {
        return $this->DatenschutzerklaerungKenntnisnahme;
    }
    /**
     * Set DatenschutzerklaerungKenntnisnahme value
     * @uses \BiPRO\EnumType\ST_DatenschutzerklaerungKenntnisnahme::valueIsValid()
     * @uses \BiPRO\EnumType\ST_DatenschutzerklaerungKenntnisnahme::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $datenschutzerklaerungKenntnisnahme
     * @return \BiPRO\StructType\CT_Antrag
     */
    public function setDatenschutzerklaerungKenntnisnahme($datenschutzerklaerungKenntnisnahme = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_DatenschutzerklaerungKenntnisnahme::valueIsValid($datenschutzerklaerungKenntnisnahme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_DatenschutzerklaerungKenntnisnahme', is_array($datenschutzerklaerungKenntnisnahme) ? implode(', ', $datenschutzerklaerungKenntnisnahme) : var_export($datenschutzerklaerungKenntnisnahme, true), implode(', ', \BiPRO\EnumType\ST_DatenschutzerklaerungKenntnisnahme::getValidValues())), __LINE__);
        }
        $this->DatenschutzerklaerungKenntnisnahme = $datenschutzerklaerungKenntnisnahme;
        return $this;
    }
    /**
     * Get Antragsart value
     * @return string|null
     */
    public function getAntragsart()
    {
        return $this->Antragsart;
    }
    /**
     * Set Antragsart value
     * @uses \BiPRO\EnumType\ST_Antragsart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Antragsart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $antragsart
     * @return \BiPRO\StructType\CT_Antrag
     */
    public function setAntragsart($antragsart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Antragsart::valueIsValid($antragsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Antragsart', is_array($antragsart) ? implode(', ', $antragsart) : var_export($antragsart, true), implode(', ', \BiPRO\EnumType\ST_Antragsart::getValidValues())), __LINE__);
        }
        $this->Antragsart = $antragsart;
        return $this;
    }
    /**
     * Get Vertragsnummer value
     * @return \BiPRO\StructType\CT_Vertragsnummer|null
     */
    public function getVertragsnummer()
    {
        return $this->Vertragsnummer;
    }
    /**
     * Set Vertragsnummer value
     * @param \BiPRO\StructType\CT_Vertragsnummer $vertragsnummer
     * @return \BiPRO\StructType\CT_Antrag
     */
    public function setVertragsnummer(\BiPRO\StructType\CT_Vertragsnummer $vertragsnummer = null)
    {
        $this->Vertragsnummer = $vertragsnummer;
        return $this;
    }
    /**
     * Get ZusaetzlicheAntragsdaten value
     * @return \BiPRO\StructType\CT_ZusaetzlicheAntragsdaten[]|null
     */
    public function getZusaetzlicheAntragsdaten()
    {
        return $this->ZusaetzlicheAntragsdaten;
    }
    /**
     * This method is responsible for validating the values passed to the setZusaetzlicheAntragsdaten method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZusaetzlicheAntragsdaten method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZusaetzlicheAntragsdatenForArrayConstraintsFromSetZusaetzlicheAntragsdaten(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_AntragZusaetzlicheAntragsdatenItem) {
            // validation for constraint: itemType
            if (!$cT_AntragZusaetzlicheAntragsdatenItem instanceof \BiPRO\StructType\CT_ZusaetzlicheAntragsdaten) {
                $invalidValues[] = is_object($cT_AntragZusaetzlicheAntragsdatenItem) ? get_class($cT_AntragZusaetzlicheAntragsdatenItem) : sprintf('%s(%s)', gettype($cT_AntragZusaetzlicheAntragsdatenItem), var_export($cT_AntragZusaetzlicheAntragsdatenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ZusaetzlicheAntragsdaten property can only contain items of type \BiPRO\StructType\CT_ZusaetzlicheAntragsdaten, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ZusaetzlicheAntragsdaten value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_ZusaetzlicheAntragsdaten[] $zusaetzlicheAntragsdaten
     * @return \BiPRO\StructType\CT_Antrag
     */
    public function setZusaetzlicheAntragsdaten(array $zusaetzlicheAntragsdaten = array())
    {
        // validation for constraint: array
        if ('' !== ($zusaetzlicheAntragsdatenArrayErrorMessage = self::validateZusaetzlicheAntragsdatenForArrayConstraintsFromSetZusaetzlicheAntragsdaten($zusaetzlicheAntragsdaten))) {
            throw new \InvalidArgumentException($zusaetzlicheAntragsdatenArrayErrorMessage, __LINE__);
        }
        $this->ZusaetzlicheAntragsdaten = $zusaetzlicheAntragsdaten;
        return $this;
    }
    /**
     * Add item to ZusaetzlicheAntragsdaten value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_ZusaetzlicheAntragsdaten $item
     * @return \BiPRO\StructType\CT_Antrag
     */
    public function addToZusaetzlicheAntragsdaten(\BiPRO\StructType\CT_ZusaetzlicheAntragsdaten $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_ZusaetzlicheAntragsdaten) {
            throw new \InvalidArgumentException(sprintf('The ZusaetzlicheAntragsdaten property can only contain items of type \BiPRO\StructType\CT_ZusaetzlicheAntragsdaten, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ZusaetzlicheAntragsdaten[] = $item;
        return $this;
    }
    /**
     * Get Beitragszahler value
     * @return \BiPRO\StructType\CT_Beitragszahler|null
     */
    public function getBeitragszahler()
    {
        return $this->Beitragszahler;
    }
    /**
     * Set Beitragszahler value
     * @param \BiPRO\StructType\CT_Beitragszahler $beitragszahler
     * @return \BiPRO\StructType\CT_Antrag
     */
    public function setBeitragszahler(\BiPRO\StructType\CT_Beitragszahler $beitragszahler = null)
    {
        $this->Beitragszahler = $beitragszahler;
        return $this;
    }
}
