<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Anspruchsteller StructType
 * Meta information extracted from the WSDL
 * - documentation: Partner, der einen Anspruch stellt.
 * @subpackage Structs
 */
class CT_Anspruchsteller extends CT_Partnerrolle
{
    /**
     * The VerwandschaftVPAST
     * Meta information extracted from the WSDL
     * - documentation: JA = Zwischen Versicherungnehmer (VN) oder versicherter Person (VP) und dem Anspruchsteller (AST) besteht ein Familien- oder VerwandtschaftsverhältnisNEIN = Zwischen VN / VP und AST besteht kein Familien- oder
     * Verwandtschaftsverhältnis
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $VerwandschaftVPAST;
    /**
     * The HaeuslicheGemeinschaftVPAST
     * Meta information extracted from the WSDL
     * - documentation: JA = Versicherungnehmer (VN) oder versicherter Person (VP) und Anspruchsteller (AST) leben in häuslicher GemeinschaftNEIN = VN / VP und AST leben nicht in häuslicher Gemeinschaft
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $HaeuslicheGemeinschaftVPAST;
    /**
     * The ArbeitsVertragsverhaeltnisVPAST
     * Meta information extracted from the WSDL
     * - documentation: JA = Zwischen Versicherungnehmer (VN) oder versicherter Person (VP) und Anspruchsteller (AST) besteht ein Arbeits- oder VertragsverhältnisNEIN = Zwischen VN / VP und AST besteht kein Arbeits- oder Vertragsverhältnis
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $ArbeitsVertragsverhaeltnisVPAST;
    /**
     * The ArtVertragsverhaeltnis
     * Meta information extracted from the WSDL
     * - documentation: Art des Vertragsverhältnisses zwischen Versicherungnehmer oder versicherter Person und Anspruchsteller.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtVertragsverhaeltnis;
    /**
     * The BeschreibungVertragsverhaeltnis
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung des Vertragsverhältnisses zwischen Versicherungnehmer oder versicherter Person und Anspruchsteller.
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $BeschreibungVertragsverhaeltnis;
    /**
     * The Anspruchsanteil
     * Meta information extracted from the WSDL
     * - documentation: Anteil, den dieser Anspruchsteller am Gesamtgegenstandswert geltend macht. | Prozentanteil ohne Prozentzeichen z.B. 50 = 50% oder 12,5 = 12,5%
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var float
     */
    public $Anspruchsanteil;
    /**
     * Constructor method for CT_Anspruchsteller
     * @uses CT_Anspruchsteller::setVerwandschaftVPAST()
     * @uses CT_Anspruchsteller::setHaeuslicheGemeinschaftVPAST()
     * @uses CT_Anspruchsteller::setArbeitsVertragsverhaeltnisVPAST()
     * @uses CT_Anspruchsteller::setArtVertragsverhaeltnis()
     * @uses CT_Anspruchsteller::setBeschreibungVertragsverhaeltnis()
     * @uses CT_Anspruchsteller::setAnspruchsanteil()
     * @param bool $verwandschaftVPAST
     * @param bool $haeuslicheGemeinschaftVPAST
     * @param bool $arbeitsVertragsverhaeltnisVPAST
     * @param string $artVertragsverhaeltnis
     * @param string $beschreibungVertragsverhaeltnis
     * @param float $anspruchsanteil
     */
    public function __construct($verwandschaftVPAST = null, $haeuslicheGemeinschaftVPAST = null, $arbeitsVertragsverhaeltnisVPAST = null, $artVertragsverhaeltnis = null, $beschreibungVertragsverhaeltnis = null, $anspruchsanteil = null)
    {
        $this
            ->setVerwandschaftVPAST($verwandschaftVPAST)
            ->setHaeuslicheGemeinschaftVPAST($haeuslicheGemeinschaftVPAST)
            ->setArbeitsVertragsverhaeltnisVPAST($arbeitsVertragsverhaeltnisVPAST)
            ->setArtVertragsverhaeltnis($artVertragsverhaeltnis)
            ->setBeschreibungVertragsverhaeltnis($beschreibungVertragsverhaeltnis)
            ->setAnspruchsanteil($anspruchsanteil);
    }
    /**
     * Get VerwandschaftVPAST value
     * @return bool|null
     */
    public function getVerwandschaftVPAST()
    {
        return $this->VerwandschaftVPAST;
    }
    /**
     * Set VerwandschaftVPAST value
     * @param bool $verwandschaftVPAST
     * @return \BiPRO\StructType\CT_Anspruchsteller
     */
    public function setVerwandschaftVPAST($verwandschaftVPAST = null)
    {
        // validation for constraint: boolean
        if (!is_null($verwandschaftVPAST) && !is_bool($verwandschaftVPAST)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($verwandschaftVPAST, true), gettype($verwandschaftVPAST)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($verwandschaftVPAST) && !preg_match('/true|false/', $verwandschaftVPAST)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($verwandschaftVPAST, true)), __LINE__);
        }
        $this->VerwandschaftVPAST = $verwandschaftVPAST;
        return $this;
    }
    /**
     * Get HaeuslicheGemeinschaftVPAST value
     * @return bool|null
     */
    public function getHaeuslicheGemeinschaftVPAST()
    {
        return $this->HaeuslicheGemeinschaftVPAST;
    }
    /**
     * Set HaeuslicheGemeinschaftVPAST value
     * @param bool $haeuslicheGemeinschaftVPAST
     * @return \BiPRO\StructType\CT_Anspruchsteller
     */
    public function setHaeuslicheGemeinschaftVPAST($haeuslicheGemeinschaftVPAST = null)
    {
        // validation for constraint: boolean
        if (!is_null($haeuslicheGemeinschaftVPAST) && !is_bool($haeuslicheGemeinschaftVPAST)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($haeuslicheGemeinschaftVPAST, true), gettype($haeuslicheGemeinschaftVPAST)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($haeuslicheGemeinschaftVPAST) && !preg_match('/true|false/', $haeuslicheGemeinschaftVPAST)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($haeuslicheGemeinschaftVPAST, true)), __LINE__);
        }
        $this->HaeuslicheGemeinschaftVPAST = $haeuslicheGemeinschaftVPAST;
        return $this;
    }
    /**
     * Get ArbeitsVertragsverhaeltnisVPAST value
     * @return bool|null
     */
    public function getArbeitsVertragsverhaeltnisVPAST()
    {
        return $this->ArbeitsVertragsverhaeltnisVPAST;
    }
    /**
     * Set ArbeitsVertragsverhaeltnisVPAST value
     * @param bool $arbeitsVertragsverhaeltnisVPAST
     * @return \BiPRO\StructType\CT_Anspruchsteller
     */
    public function setArbeitsVertragsverhaeltnisVPAST($arbeitsVertragsverhaeltnisVPAST = null)
    {
        // validation for constraint: boolean
        if (!is_null($arbeitsVertragsverhaeltnisVPAST) && !is_bool($arbeitsVertragsverhaeltnisVPAST)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($arbeitsVertragsverhaeltnisVPAST, true), gettype($arbeitsVertragsverhaeltnisVPAST)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($arbeitsVertragsverhaeltnisVPAST) && !preg_match('/true|false/', $arbeitsVertragsverhaeltnisVPAST)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($arbeitsVertragsverhaeltnisVPAST, true)), __LINE__);
        }
        $this->ArbeitsVertragsverhaeltnisVPAST = $arbeitsVertragsverhaeltnisVPAST;
        return $this;
    }
    /**
     * Get ArtVertragsverhaeltnis value
     * @return string|null
     */
    public function getArtVertragsverhaeltnis()
    {
        return $this->ArtVertragsverhaeltnis;
    }
    /**
     * Set ArtVertragsverhaeltnis value
     * @uses \BiPRO\EnumType\ST_Vertragsart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Vertragsart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artVertragsverhaeltnis
     * @return \BiPRO\StructType\CT_Anspruchsteller
     */
    public function setArtVertragsverhaeltnis($artVertragsverhaeltnis = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Vertragsart::valueIsValid($artVertragsverhaeltnis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Vertragsart', is_array($artVertragsverhaeltnis) ? implode(', ', $artVertragsverhaeltnis) : var_export($artVertragsverhaeltnis, true), implode(', ', \BiPRO\EnumType\ST_Vertragsart::getValidValues())), __LINE__);
        }
        $this->ArtVertragsverhaeltnis = $artVertragsverhaeltnis;
        return $this;
    }
    /**
     * Get BeschreibungVertragsverhaeltnis value
     * @return string|null
     */
    public function getBeschreibungVertragsverhaeltnis()
    {
        return $this->BeschreibungVertragsverhaeltnis;
    }
    /**
     * Set BeschreibungVertragsverhaeltnis value
     * @param string $beschreibungVertragsverhaeltnis
     * @return \BiPRO\StructType\CT_Anspruchsteller
     */
    public function setBeschreibungVertragsverhaeltnis($beschreibungVertragsverhaeltnis = null)
    {
        // validation for constraint: string
        if (!is_null($beschreibungVertragsverhaeltnis) && !is_string($beschreibungVertragsverhaeltnis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beschreibungVertragsverhaeltnis, true), gettype($beschreibungVertragsverhaeltnis)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($beschreibungVertragsverhaeltnis) && mb_strlen($beschreibungVertragsverhaeltnis) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($beschreibungVertragsverhaeltnis)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($beschreibungVertragsverhaeltnis) && mb_strlen($beschreibungVertragsverhaeltnis) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($beschreibungVertragsverhaeltnis)), __LINE__);
        }
        $this->BeschreibungVertragsverhaeltnis = $beschreibungVertragsverhaeltnis;
        return $this;
    }
    /**
     * Get Anspruchsanteil value
     * @return float|null
     */
    public function getAnspruchsanteil()
    {
        return $this->Anspruchsanteil;
    }
    /**
     * Set Anspruchsanteil value
     * @param float $anspruchsanteil
     * @return \BiPRO\StructType\CT_Anspruchsteller
     */
    public function setAnspruchsanteil($anspruchsanteil = null)
    {
        // validation for constraint: float
        if (!is_null($anspruchsanteil) && !(is_float($anspruchsanteil) || is_numeric($anspruchsanteil))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($anspruchsanteil, true), gettype($anspruchsanteil)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($anspruchsanteil) && $anspruchsanteil < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($anspruchsanteil, true)), __LINE__);
        }
        $this->Anspruchsanteil = $anspruchsanteil;
        return $this;
    }
}
