<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Anhaenger StructType
 * Meta information extracted from the WSDL
 * - documentation: WKZ 5xx
 * @subpackage Structs
 */
class CT_Anhaenger extends CT_Fahrzeug
{
    /**
     * The ZulaessigesGesamtgewicht
     * Meta information extracted from the WSDL
     * - documentation: Zulässiges Gesamtgewicht in kg.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $ZulaessigesGesamtgewicht;
    /**
     * The Nutzlast
     * Meta information extracted from the WSDL
     * - documentation: Nutzlast in kg.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Nutzlast;
    /**
     * The Aufbauten
     * Meta information extracted from the WSDL
     * - documentation: Schlüssel gemäß "Verzeichnis zur Systematisierung von Kraftfahrzeugen und ihren Anhängern" des Kraftfahrtbundesamts (das jeweils aktuelle Verzeichnis findet sich auf der Website des Kraftfahrtbundesamts unter nachfolgendem Link
     * im Abschnitt "Bekanntmachungen zur Fahrzeugsystematik": https://www.kba.de/DE/Statistik/statistik_node.html)
     * - base: xsd:string
     * - length: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aufbauten;
    /**
     * The AufbautenText
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung der Aufbauten als Text, falls im Attribut Aufbauten der Wert "99" geschlüsselt ist.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $AufbautenText;
    /**
     * The ZiehendesKfzBeiVUVersichert
     * Meta information extracted from the WSDL
     * - documentation: Das ziehende Fahrzeug ist beim selben Versicherer versichert.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $ZiehendesKfzBeiVUVersichert;
    /**
     * The AnhaengerNutzung
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_AnhaengerNutzung
     */
    public $AnhaengerNutzung;
    /**
     * The Schlingerdaempfung
     * Meta information extracted from the WSDL
     * - documentation: Schlingerdämpfung des Anhängers.Ja= Schlingerdämpfung vorhanden.Nein=Schlingerdämpfung nicht vorhanden.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Schlingerdaempfung;
    /**
     * The AufbautenHersteller
     * Meta information extracted from the WSDL
     * - documentation: Angaben zum Hersteller des Aufbaus eines Anhängers.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $AufbautenHersteller;
    /**
     * Constructor method for CT_Anhaenger
     * @uses CT_Anhaenger::setZulaessigesGesamtgewicht()
     * @uses CT_Anhaenger::setNutzlast()
     * @uses CT_Anhaenger::setAufbauten()
     * @uses CT_Anhaenger::setAufbautenText()
     * @uses CT_Anhaenger::setZiehendesKfzBeiVUVersichert()
     * @uses CT_Anhaenger::setAnhaengerNutzung()
     * @uses CT_Anhaenger::setSchlingerdaempfung()
     * @uses CT_Anhaenger::setAufbautenHersteller()
     * @param float $zulaessigesGesamtgewicht
     * @param float $nutzlast
     * @param string $aufbauten
     * @param string $aufbautenText
     * @param bool $ziehendesKfzBeiVUVersichert
     * @param \BiPRO\StructType\CT_AnhaengerNutzung $anhaengerNutzung
     * @param bool $schlingerdaempfung
     * @param string $aufbautenHersteller
     */
    public function __construct($zulaessigesGesamtgewicht = null, $nutzlast = null, $aufbauten = null, $aufbautenText = null, $ziehendesKfzBeiVUVersichert = null, \BiPRO\StructType\CT_AnhaengerNutzung $anhaengerNutzung = null, $schlingerdaempfung = null, $aufbautenHersteller = null)
    {
        $this
            ->setZulaessigesGesamtgewicht($zulaessigesGesamtgewicht)
            ->setNutzlast($nutzlast)
            ->setAufbauten($aufbauten)
            ->setAufbautenText($aufbautenText)
            ->setZiehendesKfzBeiVUVersichert($ziehendesKfzBeiVUVersichert)
            ->setAnhaengerNutzung($anhaengerNutzung)
            ->setSchlingerdaempfung($schlingerdaempfung)
            ->setAufbautenHersteller($aufbautenHersteller);
    }
    /**
     * Get ZulaessigesGesamtgewicht value
     * @return float|null
     */
    public function getZulaessigesGesamtgewicht()
    {
        return $this->ZulaessigesGesamtgewicht;
    }
    /**
     * Set ZulaessigesGesamtgewicht value
     * @param float $zulaessigesGesamtgewicht
     * @return \BiPRO\StructType\CT_Anhaenger
     */
    public function setZulaessigesGesamtgewicht($zulaessigesGesamtgewicht = null)
    {
        // validation for constraint: float
        if (!is_null($zulaessigesGesamtgewicht) && !(is_float($zulaessigesGesamtgewicht) || is_numeric($zulaessigesGesamtgewicht))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($zulaessigesGesamtgewicht, true), gettype($zulaessigesGesamtgewicht)), __LINE__);
        }
        $this->ZulaessigesGesamtgewicht = $zulaessigesGesamtgewicht;
        return $this;
    }
    /**
     * Get Nutzlast value
     * @return float|null
     */
    public function getNutzlast()
    {
        return $this->Nutzlast;
    }
    /**
     * Set Nutzlast value
     * @param float $nutzlast
     * @return \BiPRO\StructType\CT_Anhaenger
     */
    public function setNutzlast($nutzlast = null)
    {
        // validation for constraint: float
        if (!is_null($nutzlast) && !(is_float($nutzlast) || is_numeric($nutzlast))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nutzlast, true), gettype($nutzlast)), __LINE__);
        }
        $this->Nutzlast = $nutzlast;
        return $this;
    }
    /**
     * Get Aufbauten value
     * @return string|null
     */
    public function getAufbauten()
    {
        return $this->Aufbauten;
    }
    /**
     * Set Aufbauten value
     * @param string $aufbauten
     * @return \BiPRO\StructType\CT_Anhaenger
     */
    public function setAufbauten($aufbauten = null)
    {
        // validation for constraint: string
        if (!is_null($aufbauten) && !is_string($aufbauten)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aufbauten, true), gettype($aufbauten)), __LINE__);
        }
        // validation for constraint: length(4)
        if (!is_null($aufbauten) && mb_strlen($aufbauten) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 4', mb_strlen($aufbauten)), __LINE__);
        }
        $this->Aufbauten = $aufbauten;
        return $this;
    }
    /**
     * Get AufbautenText value
     * @return string|null
     */
    public function getAufbautenText()
    {
        return $this->AufbautenText;
    }
    /**
     * Set AufbautenText value
     * @param string $aufbautenText
     * @return \BiPRO\StructType\CT_Anhaenger
     */
    public function setAufbautenText($aufbautenText = null)
    {
        // validation for constraint: string
        if (!is_null($aufbautenText) && !is_string($aufbautenText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aufbautenText, true), gettype($aufbautenText)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($aufbautenText) && mb_strlen($aufbautenText) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($aufbautenText)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($aufbautenText) && mb_strlen($aufbautenText) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($aufbautenText)), __LINE__);
        }
        $this->AufbautenText = $aufbautenText;
        return $this;
    }
    /**
     * Get ZiehendesKfzBeiVUVersichert value
     * @return bool|null
     */
    public function getZiehendesKfzBeiVUVersichert()
    {
        return $this->ZiehendesKfzBeiVUVersichert;
    }
    /**
     * Set ZiehendesKfzBeiVUVersichert value
     * @param bool $ziehendesKfzBeiVUVersichert
     * @return \BiPRO\StructType\CT_Anhaenger
     */
    public function setZiehendesKfzBeiVUVersichert($ziehendesKfzBeiVUVersichert = null)
    {
        // validation for constraint: boolean
        if (!is_null($ziehendesKfzBeiVUVersichert) && !is_bool($ziehendesKfzBeiVUVersichert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ziehendesKfzBeiVUVersichert, true), gettype($ziehendesKfzBeiVUVersichert)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($ziehendesKfzBeiVUVersichert) && !preg_match('/true|false/', $ziehendesKfzBeiVUVersichert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($ziehendesKfzBeiVUVersichert, true)), __LINE__);
        }
        $this->ZiehendesKfzBeiVUVersichert = $ziehendesKfzBeiVUVersichert;
        return $this;
    }
    /**
     * Get AnhaengerNutzung value
     * @return \BiPRO\StructType\CT_AnhaengerNutzung|null
     */
    public function getAnhaengerNutzung()
    {
        return $this->AnhaengerNutzung;
    }
    /**
     * Set AnhaengerNutzung value
     * @param \BiPRO\StructType\CT_AnhaengerNutzung $anhaengerNutzung
     * @return \BiPRO\StructType\CT_Anhaenger
     */
    public function setAnhaengerNutzung(\BiPRO\StructType\CT_AnhaengerNutzung $anhaengerNutzung = null)
    {
        $this->AnhaengerNutzung = $anhaengerNutzung;
        return $this;
    }
    /**
     * Get Schlingerdaempfung value
     * @return bool|null
     */
    public function getSchlingerdaempfung()
    {
        return $this->Schlingerdaempfung;
    }
    /**
     * Set Schlingerdaempfung value
     * @param bool $schlingerdaempfung
     * @return \BiPRO\StructType\CT_Anhaenger
     */
    public function setSchlingerdaempfung($schlingerdaempfung = null)
    {
        // validation for constraint: boolean
        if (!is_null($schlingerdaempfung) && !is_bool($schlingerdaempfung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($schlingerdaempfung, true), gettype($schlingerdaempfung)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($schlingerdaempfung) && !preg_match('/true|false/', $schlingerdaempfung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($schlingerdaempfung, true)), __LINE__);
        }
        $this->Schlingerdaempfung = $schlingerdaempfung;
        return $this;
    }
    /**
     * Get AufbautenHersteller value
     * @return string|null
     */
    public function getAufbautenHersteller()
    {
        return $this->AufbautenHersteller;
    }
    /**
     * Set AufbautenHersteller value
     * @param string $aufbautenHersteller
     * @return \BiPRO\StructType\CT_Anhaenger
     */
    public function setAufbautenHersteller($aufbautenHersteller = null)
    {
        // validation for constraint: string
        if (!is_null($aufbautenHersteller) && !is_string($aufbautenHersteller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aufbautenHersteller, true), gettype($aufbautenHersteller)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($aufbautenHersteller) && mb_strlen($aufbautenHersteller) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($aufbautenHersteller)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($aufbautenHersteller) && mb_strlen($aufbautenHersteller) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($aufbautenHersteller)), __LINE__);
        }
        $this->AufbautenHersteller = $aufbautenHersteller;
        return $this;
    }
}
