<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Aktivitaetsrolle StructType
 * @subpackage Structs
 */
abstract class CT_Aktivitaetsrolle extends CT_Objekt
{
    /**
     * The AktivitaetID
     * Meta information extracted from the WSDL
     * - documentation: Typ fuer alle IDs.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $AktivitaetID;
    /**
     * Constructor method for CT_Aktivitaetsrolle
     * @uses CT_Aktivitaetsrolle::setAktivitaetID()
     * @param string $aktivitaetID
     */
    public function __construct($aktivitaetID = null)
    {
        $this
            ->setAktivitaetID($aktivitaetID);
    }
    /**
     * Get AktivitaetID value
     * @return string
     */
    public function getAktivitaetID()
    {
        return $this->AktivitaetID;
    }
    /**
     * Set AktivitaetID value
     * @param string $aktivitaetID
     * @return \BiPRO\StructType\CT_Aktivitaetsrolle
     */
    public function setAktivitaetID($aktivitaetID = null)
    {
        // validation for constraint: string
        if (!is_null($aktivitaetID) && !is_string($aktivitaetID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aktivitaetID, true), gettype($aktivitaetID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($aktivitaetID) && mb_strlen($aktivitaetID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($aktivitaetID)), __LINE__);
        }
        $this->AktivitaetID = $aktivitaetID;
        return $this;
    }
}
