<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Abbuchung StructType
 * Meta information extracted from the WSDL
 * - documentation: Die einmalige bzw. regelmäßige Abbuchung eines bestimmten Betrags zu bzw. ab einem konkreten Zeitpunkt.Die Angabe des Zeitpunkts MUSS mittels dem Attribut Stichtag erfolgen.Im Attribut Zahlweise MUSS angegeben werden, ob es sich um
 * eine einmalige oder wiederkehrende Abbuchung handelt. Ist Zahlweise kontinuierlich (z.B. monatlich, jährlich) belegt, MUSS das Datum "Stichtag" als erster Abbuchungstag belegt bzw. interpretiert werden.Bsp.: Zahlweise = 8 (monatlich), Stichtag =
 * 2013-04-01 bedeutet: Ab dem 1.4.2013 wird monatlich der angegebene Betrag abgebucht.Im Kontext SEPA sind nur Abbuchungen in Euro erlaubt. Die "Waehrung" MUSS also mit "EUR" (Euro) belegt werden.
 * @subpackage Structs
 */
class CT_Abbuchung extends CT_Geldwert
{
    /**
     * The Zahlweise
     * Meta information extracted from the WSDL
     * - documentation: Angabe der Zahlweise und damit der Frequenz der Abbuchung.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Zahlweise;
    /**
     * Constructor method for CT_Abbuchung
     * @uses CT_Abbuchung::setZahlweise()
     * @param string $zahlweise
     */
    public function __construct($zahlweise = null)
    {
        $this
            ->setZahlweise($zahlweise);
    }
    /**
     * Get Zahlweise value
     * @return string
     */
    public function getZahlweise()
    {
        return $this->Zahlweise;
    }
    /**
     * Set Zahlweise value
     * @uses \BiPRO\EnumType\ST_Zahlungsweise::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Zahlungsweise::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zahlweise
     * @return \BiPRO\StructType\CT_Abbuchung
     */
    public function setZahlweise($zahlweise = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Zahlungsweise::valueIsValid($zahlweise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Zahlungsweise', is_array($zahlweise) ? implode(', ', $zahlweise) : var_export($zahlweise, true), implode(', ', \BiPRO\EnumType\ST_Zahlungsweise::getValidValues())), __LINE__);
        }
        $this->Zahlweise = $zahlweise;
        return $this;
    }
}
