<?php

namespace BiPRO\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getData
     * Meta information extracted from the WSDL
     * - documentation: Auskunft über Schäden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \BiPRO\StructType\GetData $parameters
     * @return \BiPRO\StructType\GetDataResponse|bool
     */
    public function getData(\BiPRO\StructType\GetData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \BiPRO\StructType\GetDataResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
