<?php

namespace BiPRO\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ST_ZahlungsStatus EnumType
 * Meta information extracted from the WSDL
 * - documentation: Kennzeichnet den Status der Zahlung.
 * @subpackage Enumerations
 */
class ST_ZahlungsStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'bezahlt'
     * @return string 'bezahlt'
     */
    const VALUE_BEZAHLT = 'bezahlt';
    /**
     * Constant for value 'teilbezahlt'
     * @return string 'teilbezahlt'
     */
    const VALUE_TEILBEZAHLT = 'teilbezahlt';
    /**
     * Constant for value 'unbezahlt'
     * @return string 'unbezahlt'
     */
    const VALUE_UNBEZAHLT = 'unbezahlt';
    /**
     * Constant for value 'inArbeit'
     * Meta information extracted from the WSDL
     * - documentation: Die Zahlung befindet sich in Arbeit.
     * @return string 'inArbeit'
     */
    const VALUE_IN_ARBEIT = 'inArbeit';
    /**
     * Return allowed values
     * @uses self::VALUE_BEZAHLT
     * @uses self::VALUE_TEILBEZAHLT
     * @uses self::VALUE_UNBEZAHLT
     * @uses self::VALUE_IN_ARBEIT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BEZAHLT,
            self::VALUE_TEILBEZAHLT,
            self::VALUE_UNBEZAHLT,
            self::VALUE_IN_ARBEIT,
        );
    }
}
