<?php

namespace BiPRO\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ST_Status EnumType
 * Meta information extracted from the WSDL
 * - documentation: Im Status wird lediglich eine positive oder negative Aussage zur Verarbeitung übermittelt. Die exakte Ausprägung des globalen Status kann aus Objekten vom Typ Meldung entnommen werden.
 * @subpackage Enumerations
 */
class ST_Status extends AbstractStructEnumBase
{
    /**
     * Constant for value 'OK'
     * Meta information extracted from the WSDL
     * - documentation: Die Verarbeitung konnte fehlerfrei abgeschlossen werden.
     * @return string 'OK'
     */
    const VALUE_OK = 'OK';
    /**
     * Constant for value 'NOK'
     * Meta information extracted from the WSDL
     * - documentation: Die Verarbeitung konnte aufgrund eines Fehlers nicht abgeschlossen werden.
     * @return string 'NOK'
     */
    const VALUE_NOK = 'NOK';
    /**
     * Return allowed values
     * @uses self::VALUE_OK
     * @uses self::VALUE_NOK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OK,
            self::VALUE_NOK,
        );
    }
}
