<?php

namespace BiPRO\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ST_Meldung EnumType
 * Meta information extracted from the WSDL
 * - documentation: 00001-00999 Allgemeine Meldung (projektübergreifend)01000-09999 spezifische Meldung (Tarifierung/Angebot/Antrag Allg.)01100-01399 spezifische Meldung (SHU)01400-01499 spezifische Meldung (Kfz)01500-01599 spezifische Meldung
 * (Leben)02000-02999 spezifische Meldung (Dateiübertragung)03000-03999 spezifische Meldung (Externe Navigation in VU-Portale)04000-04099 spezifische Meldung (Übertragung von Lieferungen)05000-05099 spezifische Meldungen
 * (Berechnungsservices)05100-05109 spezifische Meldungen (Konvertierung Bankdaten)05200-05299 spezifische Meldungen (Förderdaten)99999 Sonstiges Details sind der Norm 320 (Fehlertypen) zu entnehmen.
 * @subpackage Enumerations
 */
class ST_Meldung extends AbstractStructEnumBase
{
    /**
     * Constant for value '00001'
     * Meta information extracted from the WSDL
     * - documentation: Die Verarbeitung konnte aufgrund unvollständiger oder fehlerhafter Daten nicht abgeschlossen werden.
     * @return string '00001'
     */
    const VALUE_00001 = '00001';
    /**
     * Constant for value '00002'
     * Meta information extracted from the WSDL
     * - documentation: Die Verarbeitung konnte aufgrund uneindeutiger Daten nicht abgeschlossen werden.
     * @return string '00002'
     */
    const VALUE_00002 = '00002';
    /**
     * Constant for value '00007'
     * Meta information extracted from the WSDL
     * - documentation: XML Schema-Validierung fehlgeschlagen. Dieser Schlüssel MUSS geliefert werden, wenn eine Prüfung der BiPRO XML-Strukturen anhand des Service-spezifischen XML-Schemas (einschl. aller Sub-Schemata) fehlgeschlagen ist.
     * @return string '00007'
     */
    const VALUE_00007 = '00007';
    /**
     * Constant for value '00008'
     * Meta information extracted from the WSDL
     * - documentation: Der Schlüssel 00008 MUSS verwendet werden, wenn Regeln, die in einer WS-Policy beschrieben wurden, verletzt werden. Der Schlüssel DARF NICHT verwendet werden, wenn BiPRO in einer Norm einen spezifischen Fehlercode für die
     * Verletzung einer Regel definiert hat, die Regel jedoch in Form einer WS-Policy beschrieben wurde. Beispiel: Laut Norm 420 ist im Falle einer fehlerhaften Dokumentanforderung bei getOffer() ein Fehlercode 00103 in MeldungID zu liefern. Diese Regel
     * lässt sich als inhaltsbezogene WS-Policy formulieren und prüfen. Im Falle eines Fehlers DARF der Provider NICHT die allgemeine MeldungID 00008 für WS-Policy fehlgeschlagen liefern.
     * @return string '00008'
     */
    const VALUE_00008 = '00008';
    /**
     * Constant for value '00009'
     * Meta information extracted from the WSDL
     * - documentation: Die Funktion wird nicht unterstützt (nicht implementiert). Dieser Schlüssel wird verwendet, wenn eine in der WSDL-Datei angebotene Funktion vom Service nicht implementiert wurde. In diesem Fall DARF der Service einen SOAP-Fault mit
     * BiproException im detail-Bereich werfen. Im Meldungsobjekt ist dann ein Fehler zu schlüssel und mit dem Schlüssel 00009 zu konkretisieren.
     * @return string '00009'
     */
    const VALUE_00009 = '00009';
    /**
     * Constant for value '00010'
     * Meta information extracted from the WSDL
     * - documentation: Die übermittelte Feldlänge wird nicht unterstützt, ein Abschneiden von Daten wurde notwendig. Zusätzlich MUSS im Fehlertext (Meldung.Text) die maximale Feldlänge zum Feld angegeben werden.
     * @return string '00010'
     */
    const VALUE_00010 = '00010';
    /**
     * Constant for value '00101'
     * Meta information extracted from the WSDL
     * - documentation: Die im Attribut Quelle referenzierten Daten wurden ausgewertet und für die Ermittlung und Aufbereitung des Verarbeitungsergebnisses verwendet.
     * @return string '00101'
     */
    const VALUE_00101 = '00101';
    /**
     * Constant for value '00102'
     * Meta information extracted from the WSDL
     * - documentation: Die im Attribut Quelle referenzierten Daten wurden für die Durchführung der Verarbeitung sowie Ermittlung und Aufbereitung des Verarbeitungsergebnisses verändert und überschrieben.
     * @return string '00102'
     */
    const VALUE_00102 = '00102';
    /**
     * Constant for value '00103'
     * Meta information extracted from the WSDL
     * - documentation: Die angeforderten Dokumente werden nicht unterstützt.
     * @return string '00103'
     */
    const VALUE_00103 = '00103';
    /**
     * Constant for value '00104'
     * Meta information extracted from the WSDL
     * - documentation: Die Vorgangsnummer (Geschaeftsvorgang.Vorgangsnummer) ist bereits vergeben.
     * @return string '00104'
     */
    const VALUE_00104 = '00104';
    /**
     * Constant for value '00105'
     * Meta information extracted from the WSDL
     * - documentation: Fachliche Eingangbestätigung. Der Vorgang konnte ordnungsgemäß erfasst und angelegt werden. Eine fallabschließende Verarbeitung konnte nicht durchgeführt werden (Schwebe).
     * @return string '00105'
     */
    const VALUE_00105 = '00105';
    /**
     * Constant for value '00106'
     * Meta information extracted from the WSDL
     * - documentation: Antrag policiert. Der Vorgang konnte ordnungsgemäß erfasst und fallabschließend bearbeitet werden.
     * @return string '00106'
     */
    const VALUE_00106 = '00106';
    /**
     * Constant for value '00107'
     * Meta information extracted from the WSDL
     * - documentation: Verbindliches Angebot im Sinne des Invitatiomodells erstellt. Der Vorgang konnte ordnungsgemäß erfasst und fallabschließend bearbeitet werden.
     * @return string '00107'
     */
    const VALUE_00107 = '00107';
    /**
     * Constant for value '00108'
     * Meta information extracted from the WSDL
     * - documentation: Die gewünschte Versandart wird nicht unterstützt.
     * @return string '00108'
     */
    const VALUE_00108 = '00108';
    /**
     * Constant for value '00109'
     * Meta information extracted from the WSDL
     * - documentation: Nachtrag erstellt
     * @return string '00109'
     */
    const VALUE_00109 = '00109';
    /**
     * Constant for value '00900'
     * Meta information extracted from the WSDL
     * - documentation: Sicherheitsinformationen im Header nicht vorhanden oder im falschen Format. Ursache beim Consumer. Diese Meldung kann durch Hinweise mit einer MeldungID 00901-00920 ergänzt werden.
     * @return string '00900'
     */
    const VALUE_00900 = '00900';
    /**
     * Constant for value '00901'
     * Meta information extracted from the WSDL
     * - documentation: SOAP-Header nicht ermittelbar
     * @return string '00901'
     */
    const VALUE_00901 = '00901';
    /**
     * Constant for value '00905'
     * Meta information extracted from the WSDL
     * - documentation: Kein WS-Security-Header vorhanden
     * @return string '00905'
     */
    const VALUE_00905 = '00905';
    /**
     * Constant for value '00906'
     * Meta information extracted from the WSDL
     * - documentation: Leerer WS-Security-Header
     * @return string '00906'
     */
    const VALUE_00906 = '00906';
    /**
     * Constant for value '00907'
     * Meta information extracted from the WSDL
     * - documentation: Unzulässiger WS-Security-Header
     * @return string '00907'
     */
    const VALUE_00907 = '00907';
    /**
     * Constant for value '00908'
     * Meta information extracted from the WSDL
     * - documentation: Kein wsse:UsernameToken vorhanden
     * @return string '00908'
     */
    const VALUE_00908 = '00908';
    /**
     * Constant for value '00909'
     * Meta information extracted from the WSDL
     * - documentation: Kein SecurityContext-Identifier vorhanden
     * @return string '00909'
     */
    const VALUE_00909 = '00909';
    /**
     * Constant for value '00910'
     * Meta information extracted from the WSDL
     * - documentation: wst:TokenType nicht korrekt oder nicht vorhanden
     * @return string '00910'
     */
    const VALUE_00910 = '00910';
    /**
     * Constant for value '00911'
     * Meta information extracted from the WSDL
     * - documentation: wst:RequestType nicht korrekt oder nicht vorhanden
     * @return string '00911'
     */
    const VALUE_00911 = '00911';
    /**
     * Constant for value '00912'
     * Meta information extracted from the WSDL
     * - documentation: wst:CancelTarget nicht vorhanden
     * @return string '00912'
     */
    const VALUE_00912 = '00912';
    /**
     * Constant for value '00913'
     * Meta information extracted from the WSDL
     * - documentation: wsse:SecurityTokenReference nicht vorhanden
     * @return string '00913'
     */
    const VALUE_00913 = '00913';
    /**
     * Constant for value '00914'
     * Meta information extracted from the WSDL
     * - documentation: wsse:Reference nicht vorhanden
     * @return string '00914'
     */
    const VALUE_00914 = '00914';
    /**
     * Constant for value '00915'
     * Meta information extracted from the WSDL
     * - documentation: wsse:Reference ohne URI-Attribut
     * @return string '00915'
     */
    const VALUE_00915 = '00915';
    /**
     * Constant for value '00916'
     * Meta information extracted from the WSDL
     * - documentation: SCT im Header stimmt nicht mit Referenz im Body überein.
     * @return string '00916'
     */
    const VALUE_00916 = '00916';
    /**
     * Constant for value '00917'
     * Meta information extracted from the WSDL
     * - documentation: WS-Security-Header enthält kein Security-ContextToken
     * @return string '00917'
     */
    const VALUE_00917 = '00917';
    /**
     * Constant for value '00919'
     * Meta information extracted from the WSDL
     * - documentation: Kein korrekter SecurityContext-Identifier
     * @return string '00919'
     */
    const VALUE_00919 = '00919';
    /**
     * Constant for value '00920'
     * Meta information extracted from the WSDL
     * - documentation: VDG: Keine Berechtigung für die Web-Anwendung des angegebenen Mandanten
     * @return string '00920'
     */
    const VALUE_00920 = '00920';
    /**
     * Constant for value '00930'
     * Meta information extracted from the WSDL
     * - documentation: Der Service kann nicht aufgerufen werden. Mögliche Ursachen sind z.B. eine fehlgeschlagene Validierung oder der Aufruf eines ungültigen Services. Diese Meldung kann durch Hinweise mit einer MeldungID 00931-00932 ergänzt werden.
     * @return string '00930'
     */
    const VALUE_00930 = '00930';
    /**
     * Constant for value '00931'
     * Meta information extracted from the WSDL
     * - documentation: Validierung des Bodys fehlgeschlagen
     * @return string '00931'
     */
    const VALUE_00931 = '00931';
    /**
     * Constant for value '00932'
     * Meta information extracted from the WSDL
     * - documentation: Fehler bei der Verarbeitung (Technischer Fehler, der bei Service-Abarbeitung auftritt)
     * @return string '00932'
     */
    const VALUE_00932 = '00932';
    /**
     * Constant for value '00940'
     * Meta information extracted from the WSDL
     * - documentation: Vorübergehende technische Störung auf Seiten des Providers. Diese Meldung kann durch Hinweise mit einer MeldungID 00941-00949 ergänzt werden.
     * @return string '00940'
     */
    const VALUE_00940 = '00940';
    /**
     * Constant for value '00941'
     * Meta information extracted from the WSDL
     * - documentation: Fehler bei der Erstellung der RequestSecurityTokenResponse
     * @return string '00941'
     */
    const VALUE_00941 = '00941';
    /**
     * Constant for value '00942'
     * Meta information extracted from the WSDL
     * - documentation: VDG: Zum Benutzer ist beim VDG kein Auth.-Verfahren hinterlegt.
     * @return string '00942'
     */
    const VALUE_00942 = '00942';
    /**
     * Constant for value '00943'
     * Meta information extracted from the WSDL
     * - documentation: VDG: Technischer Fehler beim Zugriff auf die Mandantendaten
     * @return string '00943'
     */
    const VALUE_00943 = '00943';
    /**
     * Constant for value '00944'
     * Meta information extracted from the WSDL
     * - documentation: VDG: Auth.-Verfahren weder secovid, securid noch schwach
     * @return string '00944'
     */
    const VALUE_00944 = '00944';
    /**
     * Constant for value '00945'
     * Meta information extracted from the WSDL
     * - documentation: VDG: Für den Benutzer ist auf dem Server kein Passwort hinterlegt à Vergabe eines Passworts durch den Benutzer über die Webapp. per OTP erforderlich
     * @return string '00945'
     */
    const VALUE_00945 = '00945';
    /**
     * Constant for value '00946'
     * Meta information extracted from the WSDL
     * - documentation: VDG: Fehler bei der Initialisierung des TicketIssuers
     * @return string '00946'
     */
    const VALUE_00946 = '00946';
    /**
     * Constant for value '00947'
     * Meta information extracted from the WSDL
     * - documentation: VDG: Es kann kein Ticket erstellt werden.
     * @return string '00947'
     */
    const VALUE_00947 = '00947';
    /**
     * Constant for value '00948'
     * Meta information extracted from the WSDL
     * - documentation: VDG: Bei der Ticket-Herausgabe ist ein Fehler aufgetreten.
     * @return string '00948'
     */
    const VALUE_00948 = '00948';
    /**
     * Constant for value '00949'
     * Meta information extracted from the WSDL
     * - documentation: VDG: Fehler beim Zugriff auf die VDG-Datenbanken (i.d.R. technischer Fehler)
     * @return string '00949'
     */
    const VALUE_00949 = '00949';
    /**
     * Constant for value '00960'
     * Meta information extracted from the WSDL
     * - documentation: Der Benutzer kann mit den übergebenen Credentials nicht authentifiziert werden. Diverse Ursachen: z.B. falsche Kennung, Passwort oder OTP, ungültiges SCT. Diese Meldung kann durch Hinweise mit einer MeldungID 00961-00963 ergänzt
     * werden.
     * @return string '00960'
     */
    const VALUE_00960 = '00960';
    /**
     * Constant for value '00961'
     * Meta information extracted from the WSDL
     * - documentation: Credentials (Username, Paßwort, OTP) ungültig
     * @return string '00961'
     */
    const VALUE_00961 = '00961';
    /**
     * Constant for value '00962'
     * Meta information extracted from the WSDL
     * - documentation: Session (SCT) ungültig
     * @return string '00962'
     */
    const VALUE_00962 = '00962';
    /**
     * Constant for value '00963'
     * Meta information extracted from the WSDL
     * - documentation: Timestamp / Signatur ungültig
     * @return string '00963'
     */
    const VALUE_00963 = '00963';
    /**
     * Constant for value '00964'
     * Meta information extracted from the WSDL
     * - documentation: Account gesperrt
     * @return string '00964'
     */
    const VALUE_00964 = '00964';
    /**
     * Constant for value '00965'
     * Meta information extracted from the WSDL
     * - documentation: Zu viele Fehlversuche, Account wurde gesperrt
     * @return string '00965'
     */
    const VALUE_00965 = '00965';
    /**
     * Constant for value '00966'
     * Meta information extracted from the WSDL
     * - documentation: Passwort abgelaufen
     * @return string '00966'
     */
    const VALUE_00966 = '00966';
    /**
     * Constant for value '01000'
     * Meta information extracted from the WSDL
     * - documentation: Die Verarbeitung konnte nicht durchgeführt werden. Dieser Schlüssel MUSS im Bereich TAA dann verwendet werden, wenn eine exakte Schlüsselung aufgrund anderer definierter Schlüssel nicht möglich ist.
     * @return string '01000'
     */
    const VALUE_01000 = '01000';
    /**
     * Constant for value '01001'
     * Meta information extracted from the WSDL
     * - documentation: Eine der angeforderten Zahlungsweisen wird nicht unterstützt.
     * @return string '01001'
     */
    const VALUE_01001 = '01001';
    /**
     * Constant for value '01002'
     * Meta information extracted from the WSDL
     * - documentation: Das Unterschriftverfahren wird nicht unterstützt
     * @return string '01002'
     */
    const VALUE_01002 = '01002';
    /**
     * Constant for value '01003'
     * Meta information extracted from the WSDL
     * - documentation: Für die Durchführung einer Tarifierung ist die Beantwortung von Risikofragen notwendig
     * @return string '01003'
     */
    const VALUE_01003 = '01003';
    /**
     * Constant for value '01004'
     * Meta information extracted from the WSDL
     * - documentation: Die angeforderten Dokumente konnten erfolgreich aufbereitet werden.
     * @return string '01004'
     */
    const VALUE_01004 = '01004';
    /**
     * Constant for value '01005'
     * Meta information extracted from the WSDL
     * - documentation: Die Tarifierung wurde auf Basis der übermittelten Daten erfolgreich durchgeführt
     * @return string '01005'
     */
    const VALUE_01005 = '01005';
    /**
     * Constant for value '01006'
     * Meta information extracted from the WSDL
     * - documentation: Das Verarbeitungsergebnis wurde auf Basis der übermittelten Angaben sowie zusätzlicher Annahmen ermittelt und aufbereitet. Die Beantwortung von Risikofragen kann zu einem abweichenden Ergebnis führen
     * @return string '01006'
     */
    const VALUE_01006 = '01006';
    /**
     * Constant for value '01007'
     * Meta information extracted from the WSDL
     * - documentation: Die für den Kontext relevanten Risikofragen wurden vollständig ermittelt
     * @return string '01007'
     */
    const VALUE_01007 = '01007';
    /**
     * Constant for value '01008'
     * Meta information extracted from the WSDL
     * - documentation: Die für den Kontext relevanten Risikofragen wurden teilweise ermittelt. Für eine vollständige Ermittlung ist ein erneuter Aufruf einschließlich der Antworten auf die bereits gestellten Fragen erforderlich
     * @return string '01008'
     */
    const VALUE_01008 = '01008';
    /**
     * Constant for value '01009'
     * Meta information extracted from the WSDL
     * - documentation: Art, Umfang und Qualität reichen für eine Einsendung der Antragsdaten und eine Weiterverarbeitung aus. Für eine fallabschließende Verarbeitung fehlen jedoch weitere Angaben
     * @return string '01009'
     */
    const VALUE_01009 = '01009';
    /**
     * Constant for value '01010'
     * Meta information extracted from the WSDL
     * - documentation: Mindestens eines der angeforderten Dokumente steht nicht zur Verfügung. Möglicherweise ist eine ID fehlerhaft oder der Bereitstellungszeitraum abgelaufen.
     * @return string '01010'
     */
    const VALUE_01010 = '01010';
    /**
     * Constant for value '01011'
     * Meta information extracted from the WSDL
     * - documentation: Die unter der Vorgangsnummer gespeicherte Daten stimmen nicht mit den im Request übermittelten Daten überein.
     * @return string '01011'
     */
    const VALUE_01011 = '01011';
    /**
     * Constant for value '01013'
     * Meta information extracted from the WSDL
     * - documentation: Es liegen nicht alle erforderlichen Unterschriften vor
     * @return string '01013'
     */
    const VALUE_01013 = '01013';
    /**
     * Constant for value '01014'
     * Meta information extracted from the WSDL
     * - documentation: Die Anforderung mehrerer Zahlungsweisen wird technisch nicht unterstützt
     * @return string '01014'
     */
    const VALUE_01014 = '01014';
    /**
     * Constant for value '01015'
     * Meta information extracted from the WSDL
     * - documentation: Es konnte kein Tarif ermittelt werden
     * @return string '01015'
     */
    const VALUE_01015 = '01015';
    /**
     * Constant for value '01016'
     * Meta information extracted from the WSDL
     * - documentation: Tarifierung aufgrund der vorgegebenen Beiträge nicht möglich.
     * @return string '01016'
     */
    const VALUE_01016 = '01016';
    /**
     * Constant for value '01030'
     * Meta information extracted from the WSDL
     * - documentation: (vorläufige) Deckungszusage erteilt
     * @return string '01030'
     */
    const VALUE_01030 = '01030';
    /**
     * Constant for value '01100'
     * Meta information extracted from the WSDL
     * - documentation: Auskunft erfolgreich
     * @return string '01100'
     */
    const VALUE_01100 = '01100';
    /**
     * Constant for value '01101'
     * Meta information extracted from the WSDL
     * - documentation: Objekt mit dem angegebenen Schlüssel konnte nicht identifiziert werden
     * @return string '01101'
     */
    const VALUE_01101 = '01101';
    /**
     * Constant for value '01102'
     * Meta information extracted from the WSDL
     * - documentation: Provider unterstützt nur den Abruf des aktuellen Zustands
     * @return string '01102'
     */
    const VALUE_01102 = '01102';
    /**
     * Constant for value '01103'
     * Meta information extracted from the WSDL
     * - documentation: Provider unterstützt keinen Abruf von Daten zu Anträgen
     * @return string '01103'
     */
    const VALUE_01103 = '01103';
    /**
     * Constant for value '01110'
     * Meta information extracted from the WSDL
     * - documentation: Die gewünschte Auskunft ist nicht möglich.
     * @return string '01110'
     */
    const VALUE_01110 = '01110';
    /**
     * Constant for value '01111'
     * Meta information extracted from the WSDL
     * - documentation: Der gelieferte Datenumfang entspricht nicht den angefragten Informationsarten.
     * @return string '01111'
     */
    const VALUE_01111 = '01111';
    /**
     * Constant for value '01112'
     * Meta information extracted from the WSDL
     * - documentation: Die Informationsart ist für den angefragten Vertrag nicht unterstützt.
     * @return string '01112'
     */
    const VALUE_01112 = '01112';
    /**
     * Constant for value '01113'
     * Meta information extracted from the WSDL
     * - documentation: Die Implementierung unterstützt die angefragte Informationsart nicht.
     * @return string '01113'
     */
    const VALUE_01113 = '01113';
    /**
     * Constant for value '01200'
     * Meta information extracted from the WSDL
     * - documentation: Änderungsantrag erfolgreich erstellt
     * @return string '01200'
     */
    const VALUE_01200 = '01200';
    /**
     * Constant for value '01201'
     * Meta information extracted from the WSDL
     * - documentation: Tarifierung nicht möglich, da Tarif zum Gültig-ab-Datum noch nicht bekannt
     * @return string '01201'
     */
    const VALUE_01201 = '01201';
    /**
     * Constant for value '01202'
     * Meta information extracted from the WSDL
     * - documentation: Änderung im derzeitigen Tarif des Vertrags nicht möglich
     * @return string '01202'
     */
    const VALUE_01202 = '01202';
    /**
     * Constant for value '01203'
     * Meta information extracted from the WSDL
     * - documentation: Änderung zum gewünschten Datum nicht möglich
     * @return string '01203'
     */
    const VALUE_01203 = '01203';
    /**
     * Constant for value '01204'
     * Meta information extracted from the WSDL
     * - documentation: Geschäftsvorgangsart (GeVoArt) wird nicht unterstützt
     * @return string '01204'
     */
    const VALUE_01204 = '01204';
    /**
     * Constant for value '01402'
     * Meta information extracted from the WSDL
     * - documentation: Suchanfrage brachte zu viele möglichen Treffer, bitte konkretisieren. In diesem Fall muss der Filtermechanismus verwendet werden, um die Suchanfrage weiter einzuschränken, damit eine auslieferbare Trefferliste erzeugt werden kann.
     * @return string '01402'
     */
    const VALUE_01402 = '01402';
    /**
     * Constant for value '01403'
     * Meta information extracted from the WSDL
     * - documentation: Einschränkung auf eine maximale Zeichenanzahl unzulässig. Dieser Schlüssel ist für das Fehlermanagement des Generischen Listenservice (N480.0) relevant.
     * @return string '01403'
     */
    const VALUE_01403 = '01403';
    /**
     * Constant for value '01404'
     * Meta information extracted from the WSDL
     * - documentation: Der Gültigkeitszeitraum für den Kontext ist abgelaufen. Dieser Schlüssel wird im Fehlermanagement des Generischen Listenservice (N480.0) angwendet. Der Service Consumer darf einen neuen Kontext eröffnen unter Anwendung der
     * Funktion wsen:Enumerate erzeugen.
     * @return string '01404'
     */
    const VALUE_01404 = '01404';
    /**
     * Constant for value '01405'
     * Meta information extracted from the WSDL
     * - documentation: Der folgende Kontext wird unterstützt. Dieser Schlüssel wird angewendet, um die vom Generischen Listenservice (N480.0) unterstützten fachlichen Kontexte zu melden.
     * @return string '01405'
     */
    const VALUE_01405 = '01405';
    /**
     * Constant for value '04000'
     * Meta information extracted from the WSDL
     * - documentation: Aufruf des Transferservice erfolgreich.
     * @return string '04000'
     */
    const VALUE_04000 = '04000';
    /**
     * Constant for value '04001'
     * Meta information extracted from the WSDL
     * - documentation: Zur angefragten Such-Kategorie liegen keine Lieferungen vor.
     * @return string '04001'
     */
    const VALUE_04001 = '04001';
    /**
     * Constant for value '04002'
     * Meta information extracted from the WSDL
     * - documentation: Bereits bestätigte Lieferungen können nicht angefragt werden.
     * @return string '04002'
     */
    const VALUE_04002 = '04002';
    /**
     * Constant for value '04003'
     * Meta information extracted from the WSDL
     * - documentation: Zur angefragten ID kann keine Lieferung identifiziert werden.
     * @return string '04003'
     */
    const VALUE_04003 = '04003';
    /**
     * Constant for value '04004'
     * Meta information extracted from the WSDL
     * - documentation: Quittierung der Lieferung nicht möglich.
     * @return string '04004'
     */
    const VALUE_04004 = '04004';
    /**
     * Constant for value '04005'
     * Meta information extracted from the WSDL
     * - documentation: Granularität der Such-Kategorie wird nicht unterstützt.
     * @return string '04005'
     */
    const VALUE_04005 = '04005';
    /**
     * Constant for value '04006'
     * Meta information extracted from the WSDL
     * - documentation: Das in VerfuegbarBis angegebene Datum ist überschritten.
     * @return string '04006'
     */
    const VALUE_04006 = '04006';
    /**
     * Constant for value '99999'
     * Meta information extracted from the WSDL
     * - documentation: Sonstiges
     * @return string '99999'
     */
    const VALUE_99999 = '99999';
    /**
     * Constant for value '05000'
     * Meta information extracted from the WSDL
     * - documentation: Ergebnisermittlung erfolgreich
     * @return string '05000'
     */
    const VALUE_05000 = '05000';
    /**
     * Constant for value '05001'
     * Meta information extracted from the WSDL
     * - documentation: Ergebnisermittlung fehlgeschlagen
     * @return string '05001'
     */
    const VALUE_05001 = '05001';
    /**
     * Constant for value '05100'
     * Meta information extracted from the WSDL
     * - documentation: Zur Konvertierung genutzte Liste (z.B. Bundesbank oder Swift)
     * @return string '05100'
     */
    const VALUE_05100 = '05100';
    /**
     * Constant for value '05200'
     * Meta information extracted from the WSDL
     * - documentation: Förderdatenvorprüfung erfolgreich durchgeführt
     * @return string '05200'
     */
    const VALUE_05200 = '05200';
    /**
     * Constant for value '05201'
     * Meta information extracted from the WSDL
     * - documentation: Förderdatenvorprüfung mit Warnung durchgeführt
     * @return string '05201'
     */
    const VALUE_05201 = '05201';
    /**
     * Constant for value '05202'
     * Meta information extracted from the WSDL
     * - documentation: Förderdatenantrag angenommen
     * @return string '05202'
     */
    const VALUE_05202 = '05202';
    /**
     * Constant for value '05203'
     * Meta information extracted from the WSDL
     * - documentation: Förderdatenantrag mit Warnungen angenommen
     * @return string '05203'
     */
    const VALUE_05203 = '05203';
    /**
     * Constant for value '01406'
     * Meta information extracted from the WSDL
     * - documentation: Gemäß Annahmerichtlinien kann keine eVB ausgestellt werden.
     * @return string '01406'
     */
    const VALUE_01406 = '01406';
    /**
     * Constant for value '01407'
     * Meta information extracted from the WSDL
     * - documentation: Eine Kfz-Deckung kann nur im gesetzlichen Mindestumfang angeboten werden.
     * @return string '01407'
     */
    const VALUE_01407 = '01407';
    /**
     * Constant for value '01408'
     * Meta information extracted from the WSDL
     * - documentation: Antrag abgelehnt, es liegt im gegebenen Fall kein Annahmezwang vor.
     * @return string '01408'
     */
    const VALUE_01408 = '01408';
    /**
     * Return allowed values
     * @uses self::VALUE_00001
     * @uses self::VALUE_00002
     * @uses self::VALUE_00007
     * @uses self::VALUE_00008
     * @uses self::VALUE_00009
     * @uses self::VALUE_00010
     * @uses self::VALUE_00101
     * @uses self::VALUE_00102
     * @uses self::VALUE_00103
     * @uses self::VALUE_00104
     * @uses self::VALUE_00105
     * @uses self::VALUE_00106
     * @uses self::VALUE_00107
     * @uses self::VALUE_00108
     * @uses self::VALUE_00109
     * @uses self::VALUE_00900
     * @uses self::VALUE_00901
     * @uses self::VALUE_00905
     * @uses self::VALUE_00906
     * @uses self::VALUE_00907
     * @uses self::VALUE_00908
     * @uses self::VALUE_00909
     * @uses self::VALUE_00910
     * @uses self::VALUE_00911
     * @uses self::VALUE_00912
     * @uses self::VALUE_00913
     * @uses self::VALUE_00914
     * @uses self::VALUE_00915
     * @uses self::VALUE_00916
     * @uses self::VALUE_00917
     * @uses self::VALUE_00919
     * @uses self::VALUE_00920
     * @uses self::VALUE_00930
     * @uses self::VALUE_00931
     * @uses self::VALUE_00932
     * @uses self::VALUE_00940
     * @uses self::VALUE_00941
     * @uses self::VALUE_00942
     * @uses self::VALUE_00943
     * @uses self::VALUE_00944
     * @uses self::VALUE_00945
     * @uses self::VALUE_00946
     * @uses self::VALUE_00947
     * @uses self::VALUE_00948
     * @uses self::VALUE_00949
     * @uses self::VALUE_00960
     * @uses self::VALUE_00961
     * @uses self::VALUE_00962
     * @uses self::VALUE_00963
     * @uses self::VALUE_00964
     * @uses self::VALUE_00965
     * @uses self::VALUE_00966
     * @uses self::VALUE_01000
     * @uses self::VALUE_01001
     * @uses self::VALUE_01002
     * @uses self::VALUE_01003
     * @uses self::VALUE_01004
     * @uses self::VALUE_01005
     * @uses self::VALUE_01006
     * @uses self::VALUE_01007
     * @uses self::VALUE_01008
     * @uses self::VALUE_01009
     * @uses self::VALUE_01010
     * @uses self::VALUE_01011
     * @uses self::VALUE_01013
     * @uses self::VALUE_01014
     * @uses self::VALUE_01015
     * @uses self::VALUE_01016
     * @uses self::VALUE_01030
     * @uses self::VALUE_01100
     * @uses self::VALUE_01101
     * @uses self::VALUE_01102
     * @uses self::VALUE_01103
     * @uses self::VALUE_01110
     * @uses self::VALUE_01111
     * @uses self::VALUE_01112
     * @uses self::VALUE_01113
     * @uses self::VALUE_01200
     * @uses self::VALUE_01201
     * @uses self::VALUE_01202
     * @uses self::VALUE_01203
     * @uses self::VALUE_01204
     * @uses self::VALUE_01402
     * @uses self::VALUE_01403
     * @uses self::VALUE_01404
     * @uses self::VALUE_01405
     * @uses self::VALUE_04000
     * @uses self::VALUE_04001
     * @uses self::VALUE_04002
     * @uses self::VALUE_04003
     * @uses self::VALUE_04004
     * @uses self::VALUE_04005
     * @uses self::VALUE_04006
     * @uses self::VALUE_99999
     * @uses self::VALUE_05000
     * @uses self::VALUE_05001
     * @uses self::VALUE_05100
     * @uses self::VALUE_05200
     * @uses self::VALUE_05201
     * @uses self::VALUE_05202
     * @uses self::VALUE_05203
     * @uses self::VALUE_01406
     * @uses self::VALUE_01407
     * @uses self::VALUE_01408
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_00001,
            self::VALUE_00002,
            self::VALUE_00007,
            self::VALUE_00008,
            self::VALUE_00009,
            self::VALUE_00010,
            self::VALUE_00101,
            self::VALUE_00102,
            self::VALUE_00103,
            self::VALUE_00104,
            self::VALUE_00105,
            self::VALUE_00106,
            self::VALUE_00107,
            self::VALUE_00108,
            self::VALUE_00109,
            self::VALUE_00900,
            self::VALUE_00901,
            self::VALUE_00905,
            self::VALUE_00906,
            self::VALUE_00907,
            self::VALUE_00908,
            self::VALUE_00909,
            self::VALUE_00910,
            self::VALUE_00911,
            self::VALUE_00912,
            self::VALUE_00913,
            self::VALUE_00914,
            self::VALUE_00915,
            self::VALUE_00916,
            self::VALUE_00917,
            self::VALUE_00919,
            self::VALUE_00920,
            self::VALUE_00930,
            self::VALUE_00931,
            self::VALUE_00932,
            self::VALUE_00940,
            self::VALUE_00941,
            self::VALUE_00942,
            self::VALUE_00943,
            self::VALUE_00944,
            self::VALUE_00945,
            self::VALUE_00946,
            self::VALUE_00947,
            self::VALUE_00948,
            self::VALUE_00949,
            self::VALUE_00960,
            self::VALUE_00961,
            self::VALUE_00962,
            self::VALUE_00963,
            self::VALUE_00964,
            self::VALUE_00965,
            self::VALUE_00966,
            self::VALUE_01000,
            self::VALUE_01001,
            self::VALUE_01002,
            self::VALUE_01003,
            self::VALUE_01004,
            self::VALUE_01005,
            self::VALUE_01006,
            self::VALUE_01007,
            self::VALUE_01008,
            self::VALUE_01009,
            self::VALUE_01010,
            self::VALUE_01011,
            self::VALUE_01013,
            self::VALUE_01014,
            self::VALUE_01015,
            self::VALUE_01016,
            self::VALUE_01030,
            self::VALUE_01100,
            self::VALUE_01101,
            self::VALUE_01102,
            self::VALUE_01103,
            self::VALUE_01110,
            self::VALUE_01111,
            self::VALUE_01112,
            self::VALUE_01113,
            self::VALUE_01200,
            self::VALUE_01201,
            self::VALUE_01202,
            self::VALUE_01203,
            self::VALUE_01204,
            self::VALUE_01402,
            self::VALUE_01403,
            self::VALUE_01404,
            self::VALUE_01405,
            self::VALUE_04000,
            self::VALUE_04001,
            self::VALUE_04002,
            self::VALUE_04003,
            self::VALUE_04004,
            self::VALUE_04005,
            self::VALUE_04006,
            self::VALUE_99999,
            self::VALUE_05000,
            self::VALUE_05001,
            self::VALUE_05100,
            self::VALUE_05200,
            self::VALUE_05201,
            self::VALUE_05202,
            self::VALUE_05203,
            self::VALUE_01406,
            self::VALUE_01407,
            self::VALUE_01408,
        );
    }
}
