<?php

namespace BiPRO\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ST_InvestmentTransaktionsart EnumType
 * Meta information extracted from the WSDL
 * - documentation: Art einer Investmenttransaktion
 * @subpackage Enumerations
 */
class ST_InvestmentTransaktionsart extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Kauf'
     * Meta information extracted from the WSDL
     * - documentation: Kauf eines Investments
     * @return string 'Kauf'
     */
    const VALUE_KAUF = 'Kauf';
    /**
     * Constant for value 'Verkauf'
     * Meta information extracted from the WSDL
     * - documentation: Verkauf eines Investments
     * @return string 'Verkauf'
     */
    const VALUE_VERKAUF = 'Verkauf';
    /**
     * Constant for value 'Einlieferung'
     * Meta information extracted from the WSDL
     * - documentation: Einlieferung eines Investments in ein Depot
     * @return string 'Einlieferung'
     */
    const VALUE_EINLIEFERUNG = 'Einlieferung';
    /**
     * Constant for value 'Auslieferung'
     * Meta information extracted from the WSDL
     * - documentation: Auslieferung eines Investments aus einem Depot
     * @return string 'Auslieferung'
     */
    const VALUE_AUSLIEFERUNG = 'Auslieferung';
    /**
     * Return allowed values
     * @uses self::VALUE_KAUF
     * @uses self::VALUE_VERKAUF
     * @uses self::VALUE_EINLIEFERUNG
     * @uses self::VALUE_AUSLIEFERUNG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KAUF,
            self::VALUE_VERKAUF,
            self::VALUE_EINLIEFERUNG,
            self::VALUE_AUSLIEFERUNG,
        );
    }
}
