<?php

namespace BiPRO\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ST_Incoterms EnumType
 * Meta information extracted from the WSDL
 * - documentation: Internationale Handelsklauseln der Internationalen Handelskammer (International Chamber of Commerce, ICC)
 * @subpackage Enumerations
 */
class ST_Incoterms extends AbstractStructEnumBase
{
    /**
     * Constant for value 'EXW'
     * Meta information extracted from the WSDL
     * - documentation: Ex Works / Ab Werk
     * @return string 'EXW'
     */
    const VALUE_EXW = 'EXW';
    /**
     * Constant for value 'FCA'
     * Meta information extracted from the WSDL
     * - documentation: Free Carrier / Frei Frachtführer
     * @return string 'FCA'
     */
    const VALUE_FCA = 'FCA';
    /**
     * Constant for value 'CPT'
     * Meta information extracted from the WSDL
     * - documentation: Carriage Paid To / Frachtfrei
     * @return string 'CPT'
     */
    const VALUE_CPT = 'CPT';
    /**
     * Constant for value 'CIP'
     * Meta information extracted from the WSDL
     * - documentation: Carriage and Insurance Paid to / Frachtfrei versichert
     * @return string 'CIP'
     */
    const VALUE_CIP = 'CIP';
    /**
     * Constant for value 'DAT'
     * Meta information extracted from the WSDL
     * - documentation: Delivered At Terminal / Geliefert Terminal
     * @return string 'DAT'
     */
    const VALUE_DAT = 'DAT';
    /**
     * Constant for value 'DAP'
     * Meta information extracted from the WSDL
     * - documentation: Delivered At Place / Geliefert benannter Ort
     * @return string 'DAP'
     */
    const VALUE_DAP = 'DAP';
    /**
     * Constant for value 'DDP'
     * Meta information extracted from the WSDL
     * - documentation: Delivered Duty Paid / Geliefert verzollt
     * @return string 'DDP'
     */
    const VALUE_DDP = 'DDP';
    /**
     * Constant for value 'FAS'
     * Meta information extracted from the WSDL
     * - documentation: Free Alongside Ship / Frei Längsseite Schiff
     * @return string 'FAS'
     */
    const VALUE_FAS = 'FAS';
    /**
     * Constant for value 'FOB'
     * Meta information extracted from the WSDL
     * - documentation: Free On Board / Frei an Bord
     * @return string 'FOB'
     */
    const VALUE_FOB = 'FOB';
    /**
     * Constant for value 'CFR'
     * Meta information extracted from the WSDL
     * - documentation: Cost and Freight / Kosten und Fracht
     * @return string 'CFR'
     */
    const VALUE_CFR = 'CFR';
    /**
     * Constant for value 'CIF'
     * Meta information extracted from the WSDL
     * - documentation: Cost, Insurance and Freight / Kosten, Versicherung und Fracht
     * @return string 'CIF'
     */
    const VALUE_CIF = 'CIF';
    /**
     * Return allowed values
     * @uses self::VALUE_EXW
     * @uses self::VALUE_FCA
     * @uses self::VALUE_CPT
     * @uses self::VALUE_CIP
     * @uses self::VALUE_DAT
     * @uses self::VALUE_DAP
     * @uses self::VALUE_DDP
     * @uses self::VALUE_FAS
     * @uses self::VALUE_FOB
     * @uses self::VALUE_CFR
     * @uses self::VALUE_CIF
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EXW,
            self::VALUE_FCA,
            self::VALUE_CPT,
            self::VALUE_CIP,
            self::VALUE_DAT,
            self::VALUE_DAP,
            self::VALUE_DDP,
            self::VALUE_FAS,
            self::VALUE_FOB,
            self::VALUE_CFR,
            self::VALUE_CIF,
        );
    }
}
