<?php

namespace BiPRO\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ST_Gefahrgutklasse EnumType
 * Meta information extracted from the WSDL
 * - documentation: Detaillierte Angabe der Art des Gefahrgut bzw. Gefahrgutklasse.In Anlehnung an die UN-Liste der Gefahrgutklassen: UN Recommendations on the Transport of Dangerous Goods - Model Regulations(siehe
 * http://www.unece.org/trans/danger/publi/unrec/rev13/13nature_e.html).
 * @subpackage Enumerations
 */
class ST_Gefahrgutklasse extends AbstractStructEnumBase
{
    /**
     * Constant for value '10'
     * Meta information extracted from the WSDL
     * - documentation: Klasse 1 – Explosive Stoffe
     * @return string '10'
     */
    const VALUE_10 = '10';
    /**
     * Constant for value '20'
     * Meta information extracted from the WSDL
     * - documentation: Klasse 2 – Gase und gasförmige Stoffe
     * @return string '20'
     */
    const VALUE_20 = '20';
    /**
     * Constant for value '30'
     * Meta information extracted from the WSDL
     * - documentation: Klasse 3 – Entzündbare flüssige Stoffe
     * @return string '30'
     */
    const VALUE_30 = '30';
    /**
     * Constant for value '40'
     * Meta information extracted from the WSDL
     * - documentation: Klasse 4 – Entzündbare feste Stoffe
     * @return string '40'
     */
    const VALUE_40 = '40';
    /**
     * Constant for value '41'
     * Meta information extracted from the WSDL
     * - documentation: Klasse 4.1 – Entzündbare feste Stoffe, selbstzersetzliche Stoffe und desensibilisierte explosive Stoffe
     * @return string '41'
     */
    const VALUE_41 = '41';
    /**
     * Constant for value '42'
     * Meta information extracted from the WSDL
     * - documentation: Klasse 4.2 – Selbstentzündliche Stoffe
     * @return string '42'
     */
    const VALUE_42 = '42';
    /**
     * Constant for value '43'
     * Meta information extracted from the WSDL
     * - documentation: Klasse 4.3 – Stoffe, die in Berührung mit Wasser entzündliche Gase bilden
     * @return string '43'
     */
    const VALUE_43 = '43';
    /**
     * Constant for value '50'
     * Meta information extracted from the WSDL
     * - documentation: Klasse 5 – Entzündend (oxidierend) wirkende Stoffe
     * @return string '50'
     */
    const VALUE_50 = '50';
    /**
     * Constant for value '51'
     * Meta information extracted from the WSDL
     * - documentation: Klasse 5.1 – Entzündend wirkende Stoffe
     * @return string '51'
     */
    const VALUE_51 = '51';
    /**
     * Constant for value '52'
     * Meta information extracted from the WSDL
     * - documentation: Klasse 5.2 – Organische Peroxide
     * @return string '52'
     */
    const VALUE_52 = '52';
    /**
     * Constant for value '60'
     * Meta information extracted from the WSDL
     * - documentation: Klasse 6 – Giftige Stoffe
     * @return string '60'
     */
    const VALUE_60 = '60';
    /**
     * Constant for value '61'
     * Meta information extracted from the WSDL
     * - documentation: Klasse 6.1 – Giftige Stoffe
     * @return string '61'
     */
    const VALUE_61 = '61';
    /**
     * Constant for value '62'
     * Meta information extracted from the WSDL
     * - documentation: Klasse 6.2 – Ansteckungsgefährliche Stoffe
     * @return string '62'
     */
    const VALUE_62 = '62';
    /**
     * Constant for value '70'
     * Meta information extracted from the WSDL
     * - documentation: Klasse 7 – Radioaktive Stoffe
     * @return string '70'
     */
    const VALUE_70 = '70';
    /**
     * Constant for value '80'
     * Meta information extracted from the WSDL
     * - documentation: Klasse 8 – Ätzende Stoffe
     * @return string '80'
     */
    const VALUE_80 = '80';
    /**
     * Constant for value '90'
     * Meta information extracted from the WSDL
     * - documentation: Klasse 9 – Verschiedene gefährliche Stoffe und Gegenstände
     * @return string '90'
     */
    const VALUE_90 = '90';
    /**
     * Return allowed values
     * @uses self::VALUE_10
     * @uses self::VALUE_20
     * @uses self::VALUE_30
     * @uses self::VALUE_40
     * @uses self::VALUE_41
     * @uses self::VALUE_42
     * @uses self::VALUE_43
     * @uses self::VALUE_50
     * @uses self::VALUE_51
     * @uses self::VALUE_52
     * @uses self::VALUE_60
     * @uses self::VALUE_61
     * @uses self::VALUE_62
     * @uses self::VALUE_70
     * @uses self::VALUE_80
     * @uses self::VALUE_90
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_10,
            self::VALUE_20,
            self::VALUE_30,
            self::VALUE_40,
            self::VALUE_41,
            self::VALUE_42,
            self::VALUE_43,
            self::VALUE_50,
            self::VALUE_51,
            self::VALUE_52,
            self::VALUE_60,
            self::VALUE_61,
            self::VALUE_62,
            self::VALUE_70,
            self::VALUE_80,
            self::VALUE_90,
        );
    }
}
