<?php

namespace BiPRO\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ST_DynamikKategorieID EnumType
 * @subpackage Enumerations
 */
class ST_DynamikKategorieID extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Beitrag'
     * Meta information extracted from the WSDL
     * - documentation: <<Beitragsdynamik>>Hierbei wird die Dynamik auf den Beitrag gerechnet
     * @return string 'Beitrag'
     */
    const VALUE_BEITRAG = 'Beitrag';
    /**
     * Constant for value 'Leistung'
     * Meta information extracted from the WSDL
     * - documentation: <<Leistungsdynamik>>Hierbei wird die Dynamik auf die Leistung (z.B. Versicherungssumme) gerechnet.
     * @return string 'Leistung'
     */
    const VALUE_LEISTUNG = 'Leistung';
    /**
     * Constant for value 'BeitragUndLeistung'
     * Meta information extracted from the WSDL
     * - documentation: <<Beitrags- und Leistungsdynamik>>Regelmaessige Erhoehung der Beitraege bei gleichzeitiger Erhoehung der Leistungen im gleichen Umfang.
     * @return string 'BeitragUndLeistung'
     */
    const VALUE_BEITRAG_UND_LEISTUNG = 'BeitragUndLeistung';
    /**
     * Constant for value 'Einzahlungen'
     * Meta information extracted from the WSDL
     * - documentation: Regelmäßige Anpassung (Erhöhung, Verminderung) der Einzahlungen.
     * @return string 'Einzahlungen'
     */
    const VALUE_EINZAHLUNGEN = 'Einzahlungen';
    /**
     * Return allowed values
     * @uses self::VALUE_BEITRAG
     * @uses self::VALUE_LEISTUNG
     * @uses self::VALUE_BEITRAG_UND_LEISTUNG
     * @uses self::VALUE_EINZAHLUNGEN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BEITRAG,
            self::VALUE_LEISTUNG,
            self::VALUE_BEITRAG_UND_LEISTUNG,
            self::VALUE_EINZAHLUNGEN,
        );
    }
}
