<?php

namespace BiPRO\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ST_Abrechnungsart EnumType
 * Meta information extracted from the WSDL
 * - documentation: Unterscheidung, ob vom Vermittler eingezogenen Prämien mit oder ohne Provision an den Versicherer übermittelt werden.
 * @subpackage Enumerations
 */
class ST_Abrechnungsart extends AbstractStructEnumBase
{
    /**
     * Constant for value '01'
     * Meta information extracted from the WSDL
     * - documentation: Vermittlerabrechnung Gesamtbeitrag (Der Vermittler zieht den Beitrag ein und überweist ohne Abzug der Provision an den Produktgeber)
     * @return string '01'
     */
    const VALUE_01 = '01';
    /**
     * Constant for value '02'
     * Meta information extracted from the WSDL
     * - documentation: Vermittlerabrechnung Abrechnungsbetrag (Der Vermittler zieht den Beitrag ein und überweist abzüglich der Provision an den Produktgeber)
     * @return string '02'
     */
    const VALUE_02 = '02';
    /**
     * Constant for value '03'
     * Meta information extracted from the WSDL
     * - documentation: AbrechnungIn der Abrechnung sind die Posten des Abrechnenden enthalten, die entweder zu einer Forderung oder einer Verbindlichkeit gegenüber dem Abrechnungsempfänger führen und in deren Folge in der Regel eine Finanztransaktion
     * steht. In der Regel werden Abrechnungen turnusmäßig erstellt.
     * @return string '03'
     */
    const VALUE_03 = '03';
    /**
     * Constant for value '04'
     * Meta information extracted from the WSDL
     * - documentation: BuchungsnoteDie Buchungsnote informiert den Abrechnungsempfänger über die beim Abrechnenden getätigten Buchungen des Abrechnenden (in der Regel Provisionen und Kostenübernahmen, bei Vermittlerinkasso auch Beiträge und ggf.
     * Schadenzahlungen) seit der vorherigen Buchungsnote, die noch nicht abgerechnet wurden. In Abgrenzung zur Abrechnung folgt der Buchungsnote keine Finanztransaktion.
     * @return string '04'
     */
    const VALUE_04 = '04';
    /**
     * Constant for value '05'
     * Meta information extracted from the WSDL
     * - documentation: KontoauszugDer Kontoauszug enthält aus Sicht des Abrechnenden ausschließlich Abrechnungsposten für ein benanntes Konto der Versicherungsnebenbuchhaltung und einen benannten Zeitraum (ggf. eingeschränkt auf bestimmte Postenarten).
     * Darin können sowohl bereits abgerechnete, sowie noch nicht abgerechnete Posten enthalten sein.
     * @return string '05'
     */
    const VALUE_05 = '05';
    /**
     * Constant for value '06'
     * Meta information extracted from the WSDL
     * - documentation: OP-ListeDie OP-Liste enthält nur Abrechnungsposten die aus Sicht des Abrechnenden seitens des Abrechnungsempfängers noch zu begleichen sind, in der Regel ist die vertraglich vereinbarte Frist für die Abrechnung überschritten.
     * @return string '06'
     */
    const VALUE_06 = '06';
    /**
     * Return allowed values
     * @uses self::VALUE_01
     * @uses self::VALUE_02
     * @uses self::VALUE_03
     * @uses self::VALUE_04
     * @uses self::VALUE_05
     * @uses self::VALUE_06
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_01,
            self::VALUE_02,
            self::VALUE_03,
            self::VALUE_04,
            self::VALUE_05,
            self::VALUE_06,
        );
    }
}
