<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetEnabledDataSet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEnabledDataSet $parameters
     * @return \StructType\GetEnabledDataSetResponse|bool
     */
    public function GetEnabledDataSet(\StructType\GetEnabledDataSet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEnabledDataSet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSchemaDataSet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSchemaDataSet $parameters
     * @return \StructType\GetSchemaDataSetResponse|bool
     */
    public function GetSchemaDataSet(\StructType\GetSchemaDataSet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSchemaDataSet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUsageLog
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUsageLog $parameters
     * @return \StructType\GetUsageLogResponse|bool
     */
    public function GetUsageLog(\StructType\GetUsageLog $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUsageLog($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetEnabledDataSetResponse|\StructType\GetSchemaDataSetResponse|\StructType\GetUsageLogResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
