<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Execute ServiceType
 * @subpackage Services
 */
class Execute extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ExecuteQuery
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExecuteQuery $parameters
     * @return \StructType\ExecuteQueryResponse|bool
     */
    public function ExecuteQuery(\StructType\ExecuteQuery $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ExecuteQuery($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ExecuteQueryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
