<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://testfo.allianz.ru/PO.Insurance/POInsuranceService?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://testfo.allianz.ru/PO.Insurance/POInsuranceService?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \App\Integration\Providers\Alliance3\ClassMap::get(),
);
/**
 * Samples for Service ServiceType
 */
$service = new \App\Integration\Providers\Alliance3\Actions\Service($options);
/**
 * Sample call for getPolicy operation/method
 */
if ($service->getPolicy(new \App\Integration\Providers\Alliance3\DTO\GetPolicyRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getDictionaryByCode operation/method
 */
if ($service->getDictionaryByCode(new \App\Integration\Providers\Alliance3\DTO\GetDictionaryByCode()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getAllDictionariesExcel operation/method
 */
if ($service->getAllDictionariesExcel(new \App\Integration\Providers\Alliance3\DTO\GetAllDictionariesExcel()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getDictionaryValueCodesByAttribute operation/method
 */
if ($service->getDictionaryValueCodesByAttribute(new \App\Integration\Providers\Alliance3\DTO\GetDictionaryValueCodesByAttribute()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getDictionaryAttributeValueByCode operation/method
 */
if ($service->getDictionaryAttributeValueByCode(new \App\Integration\Providers\Alliance3\DTO\GetDictionaryAttributeValueByCode()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getHashByPolicyCalcId operation/method
 */
if ($service->getHashByPolicyCalcId(new \App\Integration\Providers\Alliance3\DTO\RequestsReplacePolicyOwnerRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for importPolicyWOValidation operation/method
 */
if ($service->importPolicyWOValidation(new \App\Integration\Providers\Alliance3\DTO\ImportPolicyRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getIssueProcessStatus operation/method
 */
if ($service->getIssueProcessStatus(new \App\Integration\Providers\Alliance3\DTO\GetIssueProcessStatusRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for attachDocument operation/method
 */
if ($service->attachDocument(new \App\Integration\Providers\Alliance3\DTO\AttachDocumentRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for printPolicy operation/method
 */
if ($service->printPolicy(new \App\Integration\Providers\Alliance3\DTO\PrintPolicyRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getDictionaries operation/method
 */
if ($service->getDictionaries(new \App\Integration\Providers\Alliance3\DTO\GetDictionaries()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for logIn operation/method
 */
if ($service->logIn(new \App\Integration\Providers\Alliance3\DTO\LoginRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for importPolicy operation/method
 */
if ($service->importPolicy(new \App\Integration\Providers\Alliance3\DTO\ImportPolicyRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for issuePolicy operation/method
 */
if ($service->issuePolicy(new \App\Integration\Providers\Alliance3\DTO\IssuePolicyRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for calcByProductType operation/method
 */
if ($service->calcByProductType(new \App\Integration\Providers\Alliance3\DTO\CalcInsPremRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for getPaymentURL operation/method
 */
if ($service->getPaymentURL(new \App\Integration\Providers\Alliance3\DTO\GetPaymentURLRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for dissolutionPolicy operation/method
 */
if ($service->dissolutionPolicy(new \App\Integration\Providers\Alliance3\DTO\DissolutionPolicyRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for searchPolicies operation/method
 */
if ($service->searchPolicies(new \App\Integration\Providers\Alliance3\DTO\SearchPoliciesRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for hideLogin operation/method
 */
if ($service->hideLogin(new \App\Integration\Providers\Alliance3\DTO\HideLoginRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for issuePolicyAsync operation/method
 */
if ($service->issuePolicyAsync(new \App\Integration\Providers\Alliance3\DTO\IssuePolicyAsyncRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for logOut operation/method
 */
if ($service->logOut($logOut) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for annulPolicy operation/method
 */
if ($service->annulPolicy(new \App\Integration\Providers\Alliance3\DTO\AnnulPolicyRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for printPolicyByState operation/method
 */
if ($service->printPolicyByState(new \App\Integration\Providers\Alliance3\DTO\PrintPolicyRequest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
