<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SourcesOfIncome DTO
 * @subpackage Structs
 */
class SourcesOfIncome extends AbstractStructBase
{
    /**
     * The source
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\DirectoryElemStrInfo[]
     */
    public $source;
    /**
     * Constructor method for SourcesOfIncome
     * @uses SourcesOfIncome::setSource()
     * @param \App\Integration\Providers\Alliance3\DTO\DirectoryElemStrInfo[] $source
     */
    public function __construct(array $source = array())
    {
        $this
            ->setSource($source);
    }
    /**
     * Get source value
     * @return \App\Integration\Providers\Alliance3\DTO\DirectoryElemStrInfo[]|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param \App\Integration\Providers\Alliance3\DTO\DirectoryElemStrInfo[] $source
     * @return \App\Integration\Providers\Alliance3\DTO\SourcesOfIncome
     */
    public function setSource(array $source = array())
    {
        $this->source = $source;
        return $this;
    }
    /**
     * Add item to source value
     * @throws \InvalidArgumentException
     * @param \App\Integration\Providers\Alliance3\DTO\DirectoryElemStrInfo $item
     * @return \App\Integration\Providers\Alliance3\DTO\SourcesOfIncome
     */
    public function addToSource(\App\Integration\Providers\Alliance3\DTO\DirectoryElemStrInfo $item)
    {
        $this->source[] = $item;
        return $this;
    }
}
