<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RiskInfoList DTO
 * @subpackage Structs
 */
class RiskInfoList extends AbstractStructBase
{
    /**
     * The risk
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\RiskInfo[]
     */
    public $risk;
    /**
     * Constructor method for RiskInfoList
     * @uses RiskInfoList::setRisk()
     * @param \App\Integration\Providers\Alliance3\DTO\RiskInfo[] $risk
     */
    public function __construct(array $risk = array())
    {
        $this
            ->setRisk($risk);
    }
    /**
     * Get risk value
     * @return \App\Integration\Providers\Alliance3\DTO\RiskInfo[]|null
     */
    public function getRisk()
    {
        return $this->risk;
    }
    /**
     * Set risk value
     * @param \App\Integration\Providers\Alliance3\DTO\RiskInfo[] $risk
     * @return \App\Integration\Providers\Alliance3\DTO\RiskInfoList
     */
    public function setRisk(array $risk = array())
    {
        $this->risk = $risk;
        return $this;
    }
    /**
     * Add item to risk value
     * @throws \InvalidArgumentException
     * @param \App\Integration\Providers\Alliance3\DTO\RiskInfo $item
     * @return \App\Integration\Providers\Alliance3\DTO\RiskInfoList
     */
    public function addToRisk(\App\Integration\Providers\Alliance3\DTO\RiskInfo $item)
    {
        $this->risk[] = $item;
        return $this;
    }
}
