<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductInfo DTO
 * @subpackage Structs
 */
class ProductInfo extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $code;
    /**
     * The guid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $guid;
    /**
     * Constructor method for ProductInfo
     * @uses ProductInfo::setName()
     * @uses ProductInfo::setCode()
     * @uses ProductInfo::setGuid()
     * @param string $name
     * @param string $code
     * @param string $guid
     */
    public function __construct($name = null, $code = null, $guid = null)
    {
        $this
            ->setName($name)
            ->setCode($code)
            ->setGuid($guid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\Integration\Providers\Alliance3\DTO\ProductInfo
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \App\Integration\Providers\Alliance3\DTO\ProductInfo
     */
    public function setCode($code = null)
    {
        $this->code = $code;
        return $this;
    }
    /**
     * Get guid value
     * @return string|null
     */
    public function getGuid()
    {
        return $this->guid;
    }
    /**
     * Set guid value
     * @param string $guid
     * @return \App\Integration\Providers\Alliance3\DTO\ProductInfo
     */
    public function setGuid($guid = null)
    {
        $this->guid = $guid;
        return $this;
    }
}
