<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PredstavitelListInfo DTO
 * @subpackage Structs
 */
class PredstavitelListInfo extends AbstractStructBase
{
    /**
     * The representatives
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\IdentificRepresentativeInfo[]
     */
    public $representatives;
    /**
     * Constructor method for PredstavitelListInfo
     * @uses PredstavitelListInfo::setRepresentatives()
     * @param \App\Integration\Providers\Alliance3\DTO\IdentificRepresentativeInfo[] $representatives
     */
    public function __construct(array $representatives = array())
    {
        $this
            ->setRepresentatives($representatives);
    }
    /**
     * Get representatives value
     * @return \App\Integration\Providers\Alliance3\DTO\IdentificRepresentativeInfo[]|null
     */
    public function getRepresentatives()
    {
        return $this->representatives;
    }
    /**
     * Set representatives value
     * @param \App\Integration\Providers\Alliance3\DTO\IdentificRepresentativeInfo[] $representatives
     * @return \App\Integration\Providers\Alliance3\DTO\PredstavitelListInfo
     */
    public function setRepresentatives(array $representatives = array())
    {
        $this->representatives = $representatives;
        return $this;
    }
    /**
     * Add item to representatives value
     * @throws \InvalidArgumentException
     * @param \App\Integration\Providers\Alliance3\DTO\IdentificRepresentativeInfo $item
     * @return \App\Integration\Providers\Alliance3\DTO\PredstavitelListInfo
     */
    public function addToRepresentatives(\App\Integration\Providers\Alliance3\DTO\IdentificRepresentativeInfo $item)
    {
        $this->representatives[] = $item;
        return $this;
    }
}
