<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolicyStateItem DTO
 * @subpackage Structs
 */
class PolicyStateItem extends AbstractStructBase
{
    /**
     * The state
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $date;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * Constructor method for PolicyStateItem
     * @uses PolicyStateItem::setState()
     * @uses PolicyStateItem::setDate()
     * @uses PolicyStateItem::setMessage()
     * @param string $state
     * @param string $date
     * @param string $message
     */
    public function __construct($state = null, $date = null, $message = null)
    {
        $this
            ->setState($state)
            ->setDate($date)
            ->setMessage($message);
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \App\Integration\Providers\Alliance3\DTO\PolicyStateItem
     */
    public function setState($state = null)
    {
        $this->state = $state;
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \App\Integration\Providers\Alliance3\DTO\PolicyStateItem
     */
    public function setDate($date = null)
    {
        $this->date = $date;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \App\Integration\Providers\Alliance3\DTO\PolicyStateItem
     */
    public function setMessage($message = null)
    {
        $this->message = $message;
        return $this;
    }
}
