<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Policy DTO
 * Meta information extracted from the WSDL
 * - type: tns:Policy
 * @subpackage Structs
 */
class Policy extends AbstractStructBase
{
    /**
     * The insCompanyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $insCompanyName;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\ProductInfo
     */
    public $product;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $number;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $date;
    /**
     * The dateBeg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateBeg;
    /**
     * The dateEnd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateEnd;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * The paymentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentType;
    /**
     * The prolongation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $prolongation;
    /**
     * The prolongationPolicySeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $prolongationPolicySeries;
    /**
     * The prolongationPolicyNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $prolongationPolicyNumber;
    /**
     * The previousInsurer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $previousInsurer;
    /**
     * The previousNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $previousNumber;
    /**
     * The previousInsComp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\InsCompInfo
     */
    public $previousInsComp;
    /**
     * The prolongationPolicyDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $prolongationPolicyDate;
    /**
     * The policyReplacement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $policyReplacement;
    /**
     * The replacedPolicySeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $replacedPolicySeries;
    /**
     * The replacedPolicyNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $replacedPolicyNumber;
    /**
     * The replacedPolicyDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $replacedPolicyDate;
    /**
     * The replacementDateConclusion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $replacementDateConclusion;
    /**
     * The replacedPolicyInsurant
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $replacedPolicyInsurant;
    /**
     * The replacementDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $replacementDate;
    /**
     * The durationDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $durationDays;
    /**
     * The insurant
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\SubjectInfo
     */
    public $insurant;
    /**
     * The beneficiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\SubjectInfo
     */
    public $beneficiary;
    /**
     * The insuranceObjects
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\InsuranceObjectList
     */
    public $insuranceObjects;
    /**
     * The riskInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\RiskInfoList
     */
    public $riskInfo;
    /**
     * The insPremTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $insPremTotal;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * The specialNotes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $specialNotes;
    /**
     * The departmentCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $departmentCode;
    /**
     * The representative
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\RepresentativeInfo
     */
    public $representative;
    /**
     * The currExchList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\CurrencyExchList
     */
    public $currExchList;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The dealerConractInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\DealerConractInfo
     */
    public $dealerConractInfo;
    /**
     * The pointOfSale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\PointOfSale
     */
    public $pointOfSale;
    /**
     * The userInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\UserInfo
     */
    public $userInfo;
    /**
     * The currCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currCode;
    /**
     * The calcID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $calcID;
    /**
     * The paymentsPlan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\PaymentList
     */
    public $paymentsPlan;
    /**
     * The paymentsFact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\PaymentList
     */
    public $paymentsFact;
    /**
     * The discountAV
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discountAV;
    /**
     * The clientWithoutLoss
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $clientWithoutLoss;
    /**
     * The discountUnderwriter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discountUnderwriter;
    /**
     * The foulOfInsurance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $foulOfInsurance;
    /**
     * The dateCalc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateCalc;
    /**
     * The internalID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $internalID;
    /**
     * The insByPeriods
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\InsuranceByPeriodList
     */
    public $insByPeriods;
    /**
     * The manualRegistration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $manualRegistration;
    /**
     * The manualProlongation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $manualProlongation;
    /**
     * The procentAV
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $procentAV;
    /**
     * The sellerSK
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\UserInfo
     */
    public $sellerSK;
    /**
     * The sozdatelDogovora
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\UserInfo
     */
    public $sozdatelDogovora;
    /**
     * The marketProgrList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\MarketProgrList
     */
    public $marketProgrList;
    /**
     * The additionPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $additionPayment;
    /**
     * The pechatNaBlanke
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $pechatNaBlanke;
    /**
     * The reasonsForReplacement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\ReasonsForReplacementList
     */
    public $reasonsForReplacement;
    /**
     * The blankPolicaNomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $blankPolicaNomer;
    /**
     * The blankPolicaSeria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $blankPolicaSeria;
    /**
     * The kvitanciaNomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $kvitanciaNomer;
    /**
     * The kvitanciaSeria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $kvitanciaSeria;
    /**
     * The prevWasInAnotherInsurer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $prevWasInAnotherInsurer;
    /**
     * The prevLossCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $prevLossCount;
    /**
     * The prevLossCount3dPartFault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $prevLossCount3dPartFault;
    /**
     * The skidkaAvVProc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $skidkaAvVProc;
    /**
     * The skidkaKV
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $skidkaKV;
    /**
     * The insurantDocType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $insurantDocType;
    /**
     * The storeAvProc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $storeAvProc;
    /**
     * The additionalStoreAvProc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $additionalStoreAvProc;
    /**
     * The locality
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $locality;
    /**
     * The region
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $region;
    /**
     * The localityCodeKLADR
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $localityCodeKLADR;
    /**
     * The sequence
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\PolicySequence
     */
    public $sequence;
    /**
     * The blanks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\BlankList
     */
    public $blanks;
    /**
     * The policyCorrected
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $policyCorrected;
    /**
     * The correctedPolicySeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $correctedPolicySeries;
    /**
     * The correctedPolicyNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $correctedPolicyNumber;
    /**
     * The contractCreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contractCreationDate;
    /**
     * The correctedPolicyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $correctedPolicyId;
    /**
     * The replacedPolicyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $replacedPolicyId;
    /**
     * The dateIssue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateIssue;
    /**
     * The sellerCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sellerCode;
    /**
     * The insurantChanges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\SubjectChangesInfo
     */
    public $insurantChanges;
    /**
     * The prevWasInThisPartner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $prevWasInThisPartner;
    /**
     * The ksp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ksp;
    /**
     * The replacedPolicyNumberInChain
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $replacedPolicyNumberInChain;
    /**
     * The insurantRepresentative
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\SubjectRepresentative
     */
    public $insurantRepresentative;
    /**
     * The insurantBankRequisites
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\BankRequisitesList
     */
    public $insurantBankRequisites;
    /**
     * The parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\ParametrList
     */
    public $parameters;
    /**
     * The subrogation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $subrogation;
    /**
     * The ikpCuratora
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ikpCuratora;
    /**
     * The cross
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\Cross
     */
    public $cross;
    /**
     * The beneficiary2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\SubjectInfo
     */
    public $beneficiary2;
    /**
     * The signer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\RepresentativeInfo
     */
    public $signer;
    /**
     * The periodOfInsurance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $periodOfInsurance;
    /**
     * The timeUnitPeriodOfInsurance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $timeUnitPeriodOfInsurance;
    /**
     * The beneficiaries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\Beneficiaries
     */
    public $beneficiaries;
    /**
     * The countYearsWithoutLoss
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $countYearsWithoutLoss;
    /**
     * The countInsEventsPrevPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $countInsEventsPrevPolicy;
    /**
     * The epolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $epolicy;
    /**
     * The onlinePayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $onlinePayment;
    /**
     * The stateHistoryList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\PolicyStateHistoryList
     */
    public $stateHistoryList;
    /**
     * The consentedToPersonalDataProcessing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $consentedToPersonalDataProcessing;
    /**
     * Constructor method for Policy
     * @uses Policy::setInsCompanyName()
     * @uses Policy::setProduct()
     * @uses Policy::setNumber()
     * @uses Policy::setDate()
     * @uses Policy::setDateBeg()
     * @uses Policy::setDateEnd()
     * @uses Policy::setState()
     * @uses Policy::setPaymentType()
     * @uses Policy::setProlongation()
     * @uses Policy::setProlongationPolicySeries()
     * @uses Policy::setProlongationPolicyNumber()
     * @uses Policy::setPreviousInsurer()
     * @uses Policy::setPreviousNumber()
     * @uses Policy::setPreviousInsComp()
     * @uses Policy::setProlongationPolicyDate()
     * @uses Policy::setPolicyReplacement()
     * @uses Policy::setReplacedPolicySeries()
     * @uses Policy::setReplacedPolicyNumber()
     * @uses Policy::setReplacedPolicyDate()
     * @uses Policy::setReplacementDateConclusion()
     * @uses Policy::setReplacedPolicyInsurant()
     * @uses Policy::setReplacementDate()
     * @uses Policy::setDurationDays()
     * @uses Policy::setInsurant()
     * @uses Policy::setBeneficiary()
     * @uses Policy::setInsuranceObjects()
     * @uses Policy::setRiskInfo()
     * @uses Policy::setInsPremTotal()
     * @uses Policy::setComment()
     * @uses Policy::setSpecialNotes()
     * @uses Policy::setDepartmentCode()
     * @uses Policy::setRepresentative()
     * @uses Policy::setCurrExchList()
     * @uses Policy::setID()
     * @uses Policy::setDealerConractInfo()
     * @uses Policy::setPointOfSale()
     * @uses Policy::setUserInfo()
     * @uses Policy::setCurrCode()
     * @uses Policy::setCalcID()
     * @uses Policy::setPaymentsPlan()
     * @uses Policy::setPaymentsFact()
     * @uses Policy::setDiscountAV()
     * @uses Policy::setClientWithoutLoss()
     * @uses Policy::setDiscountUnderwriter()
     * @uses Policy::setFoulOfInsurance()
     * @uses Policy::setDateCalc()
     * @uses Policy::setInternalID()
     * @uses Policy::setInsByPeriods()
     * @uses Policy::setManualRegistration()
     * @uses Policy::setManualProlongation()
     * @uses Policy::setProcentAV()
     * @uses Policy::setSellerSK()
     * @uses Policy::setSozdatelDogovora()
     * @uses Policy::setMarketProgrList()
     * @uses Policy::setAdditionPayment()
     * @uses Policy::setPechatNaBlanke()
     * @uses Policy::setReasonsForReplacement()
     * @uses Policy::setBlankPolicaNomer()
     * @uses Policy::setBlankPolicaSeria()
     * @uses Policy::setKvitanciaNomer()
     * @uses Policy::setKvitanciaSeria()
     * @uses Policy::setPrevWasInAnotherInsurer()
     * @uses Policy::setPrevLossCount()
     * @uses Policy::setPrevLossCount3dPartFault()
     * @uses Policy::setSkidkaAvVProc()
     * @uses Policy::setSkidkaKV()
     * @uses Policy::setInsurantDocType()
     * @uses Policy::setStoreAvProc()
     * @uses Policy::setAdditionalStoreAvProc()
     * @uses Policy::setLocality()
     * @uses Policy::setRegion()
     * @uses Policy::setLocalityCodeKLADR()
     * @uses Policy::setSequence()
     * @uses Policy::setBlanks()
     * @uses Policy::setPolicyCorrected()
     * @uses Policy::setCorrectedPolicySeries()
     * @uses Policy::setCorrectedPolicyNumber()
     * @uses Policy::setContractCreationDate()
     * @uses Policy::setCorrectedPolicyId()
     * @uses Policy::setReplacedPolicyId()
     * @uses Policy::setDateIssue()
     * @uses Policy::setSellerCode()
     * @uses Policy::setInsurantChanges()
     * @uses Policy::setPrevWasInThisPartner()
     * @uses Policy::setKsp()
     * @uses Policy::setReplacedPolicyNumberInChain()
     * @uses Policy::setInsurantRepresentative()
     * @uses Policy::setInsurantBankRequisites()
     * @uses Policy::setParameters()
     * @uses Policy::setSubrogation()
     * @uses Policy::setIkpCuratora()
     * @uses Policy::setCross()
     * @uses Policy::setBeneficiary2()
     * @uses Policy::setSigner()
     * @uses Policy::setPeriodOfInsurance()
     * @uses Policy::setTimeUnitPeriodOfInsurance()
     * @uses Policy::setBeneficiaries()
     * @uses Policy::setCountYearsWithoutLoss()
     * @uses Policy::setCountInsEventsPrevPolicy()
     * @uses Policy::setEpolicy()
     * @uses Policy::setOnlinePayment()
     * @uses Policy::setStateHistoryList()
     * @uses Policy::setConsentedToPersonalDataProcessing()
     * @param string $insCompanyName
     * @param \App\Integration\Providers\Alliance3\DTO\ProductInfo $product
     * @param string $number
     * @param string $date
     * @param string $dateBeg
     * @param string $dateEnd
     * @param string $state
     * @param string $paymentType
     * @param bool $prolongation
     * @param string $prolongationPolicySeries
     * @param string $prolongationPolicyNumber
     * @param string $previousInsurer
     * @param string $previousNumber
     * @param \App\Integration\Providers\Alliance3\DTO\InsCompInfo $previousInsComp
     * @param string $prolongationPolicyDate
     * @param bool $policyReplacement
     * @param string $replacedPolicySeries
     * @param string $replacedPolicyNumber
     * @param string $replacedPolicyDate
     * @param string $replacementDateConclusion
     * @param string $replacedPolicyInsurant
     * @param string $replacementDate
     * @param int $durationDays
     * @param \App\Integration\Providers\Alliance3\DTO\SubjectInfo $insurant
     * @param \App\Integration\Providers\Alliance3\DTO\SubjectInfo $beneficiary
     * @param \App\Integration\Providers\Alliance3\DTO\InsuranceObjectList $insuranceObjects
     * @param \App\Integration\Providers\Alliance3\DTO\RiskInfoList $riskInfo
     * @param float $insPremTotal
     * @param string $comment
     * @param string $specialNotes
     * @param string $departmentCode
     * @param \App\Integration\Providers\Alliance3\DTO\RepresentativeInfo $representative
     * @param \App\Integration\Providers\Alliance3\DTO\CurrencyExchList $currExchList
     * @param string $iD
     * @param \App\Integration\Providers\Alliance3\DTO\DealerConractInfo $dealerConractInfo
     * @param \App\Integration\Providers\Alliance3\DTO\PointOfSale $pointOfSale
     * @param \App\Integration\Providers\Alliance3\DTO\UserInfo $userInfo
     * @param string $currCode
     * @param string $calcID
     * @param \App\Integration\Providers\Alliance3\DTO\PaymentList $paymentsPlan
     * @param \App\Integration\Providers\Alliance3\DTO\PaymentList $paymentsFact
     * @param float $discountAV
     * @param bool $clientWithoutLoss
     * @param float $discountUnderwriter
     * @param bool $foulOfInsurance
     * @param string $dateCalc
     * @param int $internalID
     * @param \App\Integration\Providers\Alliance3\DTO\InsuranceByPeriodList $insByPeriods
     * @param bool $manualRegistration
     * @param bool $manualProlongation
     * @param float $procentAV
     * @param \App\Integration\Providers\Alliance3\DTO\UserInfo $sellerSK
     * @param \App\Integration\Providers\Alliance3\DTO\UserInfo $sozdatelDogovora
     * @param \App\Integration\Providers\Alliance3\DTO\MarketProgrList $marketProgrList
     * @param float $additionPayment
     * @param bool $pechatNaBlanke
     * @param \App\Integration\Providers\Alliance3\DTO\ReasonsForReplacementList $reasonsForReplacement
     * @param string $blankPolicaNomer
     * @param string $blankPolicaSeria
     * @param string $kvitanciaNomer
     * @param string $kvitanciaSeria
     * @param bool $prevWasInAnotherInsurer
     * @param int $prevLossCount
     * @param int $prevLossCount3dPartFault
     * @param bool $skidkaAvVProc
     * @param float $skidkaKV
     * @param string $insurantDocType
     * @param float $storeAvProc
     * @param float $additionalStoreAvProc
     * @param string $locality
     * @param string $region
     * @param string $localityCodeKLADR
     * @param \App\Integration\Providers\Alliance3\DTO\PolicySequence $sequence
     * @param \App\Integration\Providers\Alliance3\DTO\BlankList $blanks
     * @param bool $policyCorrected
     * @param string $correctedPolicySeries
     * @param string $correctedPolicyNumber
     * @param string $contractCreationDate
     * @param int $correctedPolicyId
     * @param int $replacedPolicyId
     * @param string $dateIssue
     * @param string $sellerCode
     * @param \App\Integration\Providers\Alliance3\DTO\SubjectChangesInfo $insurantChanges
     * @param bool $prevWasInThisPartner
     * @param float $ksp
     * @param int $replacedPolicyNumberInChain
     * @param \App\Integration\Providers\Alliance3\DTO\SubjectRepresentative $insurantRepresentative
     * @param \App\Integration\Providers\Alliance3\DTO\BankRequisitesList $insurantBankRequisites
     * @param \App\Integration\Providers\Alliance3\DTO\ParametrList $parameters
     * @param bool $subrogation
     * @param string $ikpCuratora
     * @param \App\Integration\Providers\Alliance3\DTO\Cross $cross
     * @param \App\Integration\Providers\Alliance3\DTO\SubjectInfo $beneficiary2
     * @param \App\Integration\Providers\Alliance3\DTO\RepresentativeInfo $signer
     * @param int $periodOfInsurance
     * @param string $timeUnitPeriodOfInsurance
     * @param \App\Integration\Providers\Alliance3\DTO\Beneficiaries $beneficiaries
     * @param int $countYearsWithoutLoss
     * @param int $countInsEventsPrevPolicy
     * @param bool $epolicy
     * @param bool $onlinePayment
     * @param \App\Integration\Providers\Alliance3\DTO\PolicyStateHistoryList $stateHistoryList
     * @param bool $consentedToPersonalDataProcessing
     */
    public function __construct($insCompanyName = null, \App\Integration\Providers\Alliance3\DTO\ProductInfo $product = null, $number = null, $date = null, $dateBeg = null, $dateEnd = null, $state = null, $paymentType = null, $prolongation = null, $prolongationPolicySeries = null, $prolongationPolicyNumber = null, $previousInsurer = null, $previousNumber = null, \App\Integration\Providers\Alliance3\DTO\InsCompInfo $previousInsComp = null, $prolongationPolicyDate = null, $policyReplacement = null, $replacedPolicySeries = null, $replacedPolicyNumber = null, $replacedPolicyDate = null, $replacementDateConclusion = null, $replacedPolicyInsurant = null, $replacementDate = null, $durationDays = null, \App\Integration\Providers\Alliance3\DTO\SubjectInfo $insurant = null, \App\Integration\Providers\Alliance3\DTO\SubjectInfo $beneficiary = null, \App\Integration\Providers\Alliance3\DTO\InsuranceObjectList $insuranceObjects = null, \App\Integration\Providers\Alliance3\DTO\RiskInfoList $riskInfo = null, $insPremTotal = null, $comment = null, $specialNotes = null, $departmentCode = null, \App\Integration\Providers\Alliance3\DTO\RepresentativeInfo $representative = null, \App\Integration\Providers\Alliance3\DTO\CurrencyExchList $currExchList = null, $iD = null, \App\Integration\Providers\Alliance3\DTO\DealerConractInfo $dealerConractInfo = null, \App\Integration\Providers\Alliance3\DTO\PointOfSale $pointOfSale = null, \App\Integration\Providers\Alliance3\DTO\UserInfo $userInfo = null, $currCode = null, $calcID = null, \App\Integration\Providers\Alliance3\DTO\PaymentList $paymentsPlan = null, \App\Integration\Providers\Alliance3\DTO\PaymentList $paymentsFact = null, $discountAV = null, $clientWithoutLoss = null, $discountUnderwriter = null, $foulOfInsurance = null, $dateCalc = null, $internalID = null, \App\Integration\Providers\Alliance3\DTO\InsuranceByPeriodList $insByPeriods = null, $manualRegistration = null, $manualProlongation = null, $procentAV = null, \App\Integration\Providers\Alliance3\DTO\UserInfo $sellerSK = null, \App\Integration\Providers\Alliance3\DTO\UserInfo $sozdatelDogovora = null, \App\Integration\Providers\Alliance3\DTO\MarketProgrList $marketProgrList = null, $additionPayment = null, $pechatNaBlanke = null, \App\Integration\Providers\Alliance3\DTO\ReasonsForReplacementList $reasonsForReplacement = null, $blankPolicaNomer = null, $blankPolicaSeria = null, $kvitanciaNomer = null, $kvitanciaSeria = null, $prevWasInAnotherInsurer = null, $prevLossCount = null, $prevLossCount3dPartFault = null, $skidkaAvVProc = null, $skidkaKV = null, $insurantDocType = null, $storeAvProc = null, $additionalStoreAvProc = null, $locality = null, $region = null, $localityCodeKLADR = null, \App\Integration\Providers\Alliance3\DTO\PolicySequence $sequence = null, \App\Integration\Providers\Alliance3\DTO\BlankList $blanks = null, $policyCorrected = null, $correctedPolicySeries = null, $correctedPolicyNumber = null, $contractCreationDate = null, $correctedPolicyId = null, $replacedPolicyId = null, $dateIssue = null, $sellerCode = null, \App\Integration\Providers\Alliance3\DTO\SubjectChangesInfo $insurantChanges = null, $prevWasInThisPartner = null, $ksp = null, $replacedPolicyNumberInChain = null, \App\Integration\Providers\Alliance3\DTO\SubjectRepresentative $insurantRepresentative = null, \App\Integration\Providers\Alliance3\DTO\BankRequisitesList $insurantBankRequisites = null, \App\Integration\Providers\Alliance3\DTO\ParametrList $parameters = null, $subrogation = null, $ikpCuratora = null, \App\Integration\Providers\Alliance3\DTO\Cross $cross = null, \App\Integration\Providers\Alliance3\DTO\SubjectInfo $beneficiary2 = null, \App\Integration\Providers\Alliance3\DTO\RepresentativeInfo $signer = null, $periodOfInsurance = null, $timeUnitPeriodOfInsurance = null, \App\Integration\Providers\Alliance3\DTO\Beneficiaries $beneficiaries = null, $countYearsWithoutLoss = null, $countInsEventsPrevPolicy = null, $epolicy = null, $onlinePayment = null, \App\Integration\Providers\Alliance3\DTO\PolicyStateHistoryList $stateHistoryList = null, $consentedToPersonalDataProcessing = null)
    {
        $this
            ->setInsCompanyName($insCompanyName)
            ->setProduct($product)
            ->setNumber($number)
            ->setDate($date)
            ->setDateBeg($dateBeg)
            ->setDateEnd($dateEnd)
            ->setState($state)
            ->setPaymentType($paymentType)
            ->setProlongation($prolongation)
            ->setProlongationPolicySeries($prolongationPolicySeries)
            ->setProlongationPolicyNumber($prolongationPolicyNumber)
            ->setPreviousInsurer($previousInsurer)
            ->setPreviousNumber($previousNumber)
            ->setPreviousInsComp($previousInsComp)
            ->setProlongationPolicyDate($prolongationPolicyDate)
            ->setPolicyReplacement($policyReplacement)
            ->setReplacedPolicySeries($replacedPolicySeries)
            ->setReplacedPolicyNumber($replacedPolicyNumber)
            ->setReplacedPolicyDate($replacedPolicyDate)
            ->setReplacementDateConclusion($replacementDateConclusion)
            ->setReplacedPolicyInsurant($replacedPolicyInsurant)
            ->setReplacementDate($replacementDate)
            ->setDurationDays($durationDays)
            ->setInsurant($insurant)
            ->setBeneficiary($beneficiary)
            ->setInsuranceObjects($insuranceObjects)
            ->setRiskInfo($riskInfo)
            ->setInsPremTotal($insPremTotal)
            ->setComment($comment)
            ->setSpecialNotes($specialNotes)
            ->setDepartmentCode($departmentCode)
            ->setRepresentative($representative)
            ->setCurrExchList($currExchList)
            ->setID($iD)
            ->setDealerConractInfo($dealerConractInfo)
            ->setPointOfSale($pointOfSale)
            ->setUserInfo($userInfo)
            ->setCurrCode($currCode)
            ->setCalcID($calcID)
            ->setPaymentsPlan($paymentsPlan)
            ->setPaymentsFact($paymentsFact)
            ->setDiscountAV($discountAV)
            ->setClientWithoutLoss($clientWithoutLoss)
            ->setDiscountUnderwriter($discountUnderwriter)
            ->setFoulOfInsurance($foulOfInsurance)
            ->setDateCalc($dateCalc)
            ->setInternalID($internalID)
            ->setInsByPeriods($insByPeriods)
            ->setManualRegistration($manualRegistration)
            ->setManualProlongation($manualProlongation)
            ->setProcentAV($procentAV)
            ->setSellerSK($sellerSK)
            ->setSozdatelDogovora($sozdatelDogovora)
            ->setMarketProgrList($marketProgrList)
            ->setAdditionPayment($additionPayment)
            ->setPechatNaBlanke($pechatNaBlanke)
            ->setReasonsForReplacement($reasonsForReplacement)
            ->setBlankPolicaNomer($blankPolicaNomer)
            ->setBlankPolicaSeria($blankPolicaSeria)
            ->setKvitanciaNomer($kvitanciaNomer)
            ->setKvitanciaSeria($kvitanciaSeria)
            ->setPrevWasInAnotherInsurer($prevWasInAnotherInsurer)
            ->setPrevLossCount($prevLossCount)
            ->setPrevLossCount3dPartFault($prevLossCount3dPartFault)
            ->setSkidkaAvVProc($skidkaAvVProc)
            ->setSkidkaKV($skidkaKV)
            ->setInsurantDocType($insurantDocType)
            ->setStoreAvProc($storeAvProc)
            ->setAdditionalStoreAvProc($additionalStoreAvProc)
            ->setLocality($locality)
            ->setRegion($region)
            ->setLocalityCodeKLADR($localityCodeKLADR)
            ->setSequence($sequence)
            ->setBlanks($blanks)
            ->setPolicyCorrected($policyCorrected)
            ->setCorrectedPolicySeries($correctedPolicySeries)
            ->setCorrectedPolicyNumber($correctedPolicyNumber)
            ->setContractCreationDate($contractCreationDate)
            ->setCorrectedPolicyId($correctedPolicyId)
            ->setReplacedPolicyId($replacedPolicyId)
            ->setDateIssue($dateIssue)
            ->setSellerCode($sellerCode)
            ->setInsurantChanges($insurantChanges)
            ->setPrevWasInThisPartner($prevWasInThisPartner)
            ->setKsp($ksp)
            ->setReplacedPolicyNumberInChain($replacedPolicyNumberInChain)
            ->setInsurantRepresentative($insurantRepresentative)
            ->setInsurantBankRequisites($insurantBankRequisites)
            ->setParameters($parameters)
            ->setSubrogation($subrogation)
            ->setIkpCuratora($ikpCuratora)
            ->setCross($cross)
            ->setBeneficiary2($beneficiary2)
            ->setSigner($signer)
            ->setPeriodOfInsurance($periodOfInsurance)
            ->setTimeUnitPeriodOfInsurance($timeUnitPeriodOfInsurance)
            ->setBeneficiaries($beneficiaries)
            ->setCountYearsWithoutLoss($countYearsWithoutLoss)
            ->setCountInsEventsPrevPolicy($countInsEventsPrevPolicy)
            ->setEpolicy($epolicy)
            ->setOnlinePayment($onlinePayment)
            ->setStateHistoryList($stateHistoryList)
            ->setConsentedToPersonalDataProcessing($consentedToPersonalDataProcessing);
    }
    /**
     * Get insCompanyName value
     * @return string|null
     */
    public function getInsCompanyName()
    {
        return $this->insCompanyName;
    }
    /**
     * Set insCompanyName value
     * @param string $insCompanyName
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setInsCompanyName($insCompanyName = null)
    {
        $this->insCompanyName = $insCompanyName;
        return $this;
    }
    /**
     * Get product value
     * @return \App\Integration\Providers\Alliance3\DTO\ProductInfo|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param \App\Integration\Providers\Alliance3\DTO\ProductInfo $product
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setProduct(\App\Integration\Providers\Alliance3\DTO\ProductInfo $product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setNumber($number = null)
    {
        $this->number = $number;
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setDate($date = null)
    {
        $this->date = $date;
        return $this;
    }
    /**
     * Get dateBeg value
     * @return string|null
     */
    public function getDateBeg()
    {
        return $this->dateBeg;
    }
    /**
     * Set dateBeg value
     * @param string $dateBeg
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setDateBeg($dateBeg = null)
    {
        $this->dateBeg = $dateBeg;
        return $this;
    }
    /**
     * Get dateEnd value
     * @return string|null
     */
    public function getDateEnd()
    {
        return $this->dateEnd;
    }
    /**
     * Set dateEnd value
     * @param string $dateEnd
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setDateEnd($dateEnd = null)
    {
        $this->dateEnd = $dateEnd;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setState($state = null)
    {
        $this->state = $state;
        return $this;
    }
    /**
     * Get paymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->paymentType;
    }
    /**
     * Set paymentType value
     * @param string $paymentType
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setPaymentType($paymentType = null)
    {
        $this->paymentType = $paymentType;
        return $this;
    }
    /**
     * Get prolongation value
     * @return bool|null
     */
    public function getProlongation()
    {
        return $this->prolongation;
    }
    /**
     * Set prolongation value
     * @param bool $prolongation
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setProlongation($prolongation = null)
    {
        $this->prolongation = $prolongation;
        return $this;
    }
    /**
     * Get prolongationPolicySeries value
     * @return string|null
     */
    public function getProlongationPolicySeries()
    {
        return $this->prolongationPolicySeries;
    }
    /**
     * Set prolongationPolicySeries value
     * @param string $prolongationPolicySeries
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setProlongationPolicySeries($prolongationPolicySeries = null)
    {
        $this->prolongationPolicySeries = $prolongationPolicySeries;
        return $this;
    }
    /**
     * Get prolongationPolicyNumber value
     * @return string|null
     */
    public function getProlongationPolicyNumber()
    {
        return $this->prolongationPolicyNumber;
    }
    /**
     * Set prolongationPolicyNumber value
     * @param string $prolongationPolicyNumber
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setProlongationPolicyNumber($prolongationPolicyNumber = null)
    {
        $this->prolongationPolicyNumber = $prolongationPolicyNumber;
        return $this;
    }
    /**
     * Get previousInsurer value
     * @return string|null
     */
    public function getPreviousInsurer()
    {
        return $this->previousInsurer;
    }
    /**
     * Set previousInsurer value
     * @param string $previousInsurer
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setPreviousInsurer($previousInsurer = null)
    {
        $this->previousInsurer = $previousInsurer;
        return $this;
    }
    /**
     * Get previousNumber value
     * @return string|null
     */
    public function getPreviousNumber()
    {
        return $this->previousNumber;
    }
    /**
     * Set previousNumber value
     * @param string $previousNumber
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setPreviousNumber($previousNumber = null)
    {
        $this->previousNumber = $previousNumber;
        return $this;
    }
    /**
     * Get previousInsComp value
     * @return \App\Integration\Providers\Alliance3\DTO\InsCompInfo|null
     */
    public function getPreviousInsComp()
    {
        return $this->previousInsComp;
    }
    /**
     * Set previousInsComp value
     * @param \App\Integration\Providers\Alliance3\DTO\InsCompInfo $previousInsComp
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setPreviousInsComp(\App\Integration\Providers\Alliance3\DTO\InsCompInfo $previousInsComp = null)
    {
        $this->previousInsComp = $previousInsComp;
        return $this;
    }
    /**
     * Get prolongationPolicyDate value
     * @return string|null
     */
    public function getProlongationPolicyDate()
    {
        return $this->prolongationPolicyDate;
    }
    /**
     * Set prolongationPolicyDate value
     * @param string $prolongationPolicyDate
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setProlongationPolicyDate($prolongationPolicyDate = null)
    {
        $this->prolongationPolicyDate = $prolongationPolicyDate;
        return $this;
    }
    /**
     * Get policyReplacement value
     * @return bool|null
     */
    public function getPolicyReplacement()
    {
        return $this->policyReplacement;
    }
    /**
     * Set policyReplacement value
     * @param bool $policyReplacement
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setPolicyReplacement($policyReplacement = null)
    {
        $this->policyReplacement = $policyReplacement;
        return $this;
    }
    /**
     * Get replacedPolicySeries value
     * @return string|null
     */
    public function getReplacedPolicySeries()
    {
        return $this->replacedPolicySeries;
    }
    /**
     * Set replacedPolicySeries value
     * @param string $replacedPolicySeries
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setReplacedPolicySeries($replacedPolicySeries = null)
    {
        $this->replacedPolicySeries = $replacedPolicySeries;
        return $this;
    }
    /**
     * Get replacedPolicyNumber value
     * @return string|null
     */
    public function getReplacedPolicyNumber()
    {
        return $this->replacedPolicyNumber;
    }
    /**
     * Set replacedPolicyNumber value
     * @param string $replacedPolicyNumber
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setReplacedPolicyNumber($replacedPolicyNumber = null)
    {
        $this->replacedPolicyNumber = $replacedPolicyNumber;
        return $this;
    }
    /**
     * Get replacedPolicyDate value
     * @return string|null
     */
    public function getReplacedPolicyDate()
    {
        return $this->replacedPolicyDate;
    }
    /**
     * Set replacedPolicyDate value
     * @param string $replacedPolicyDate
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setReplacedPolicyDate($replacedPolicyDate = null)
    {
        $this->replacedPolicyDate = $replacedPolicyDate;
        return $this;
    }
    /**
     * Get replacementDateConclusion value
     * @return string|null
     */
    public function getReplacementDateConclusion()
    {
        return $this->replacementDateConclusion;
    }
    /**
     * Set replacementDateConclusion value
     * @param string $replacementDateConclusion
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setReplacementDateConclusion($replacementDateConclusion = null)
    {
        $this->replacementDateConclusion = $replacementDateConclusion;
        return $this;
    }
    /**
     * Get replacedPolicyInsurant value
     * @return string|null
     */
    public function getReplacedPolicyInsurant()
    {
        return $this->replacedPolicyInsurant;
    }
    /**
     * Set replacedPolicyInsurant value
     * @param string $replacedPolicyInsurant
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setReplacedPolicyInsurant($replacedPolicyInsurant = null)
    {
        $this->replacedPolicyInsurant = $replacedPolicyInsurant;
        return $this;
    }
    /**
     * Get replacementDate value
     * @return string|null
     */
    public function getReplacementDate()
    {
        return $this->replacementDate;
    }
    /**
     * Set replacementDate value
     * @param string $replacementDate
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setReplacementDate($replacementDate = null)
    {
        $this->replacementDate = $replacementDate;
        return $this;
    }
    /**
     * Get durationDays value
     * @return int|null
     */
    public function getDurationDays()
    {
        return $this->durationDays;
    }
    /**
     * Set durationDays value
     * @param int $durationDays
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setDurationDays($durationDays = null)
    {
        $this->durationDays = $durationDays;
        return $this;
    }
    /**
     * Get insurant value
     * @return \App\Integration\Providers\Alliance3\DTO\SubjectInfo|null
     */
    public function getInsurant()
    {
        return $this->insurant;
    }
    /**
     * Set insurant value
     * @param \App\Integration\Providers\Alliance3\DTO\SubjectInfo $insurant
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setInsurant(\App\Integration\Providers\Alliance3\DTO\SubjectInfo $insurant = null)
    {
        $this->insurant = $insurant;
        return $this;
    }
    /**
     * Get beneficiary value
     * @return \App\Integration\Providers\Alliance3\DTO\SubjectInfo|null
     */
    public function getBeneficiary()
    {
        return $this->beneficiary;
    }
    /**
     * Set beneficiary value
     * @param \App\Integration\Providers\Alliance3\DTO\SubjectInfo $beneficiary
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setBeneficiary(\App\Integration\Providers\Alliance3\DTO\SubjectInfo $beneficiary = null)
    {
        $this->beneficiary = $beneficiary;
        return $this;
    }
    /**
     * Get insuranceObjects value
     * @return \App\Integration\Providers\Alliance3\DTO\InsuranceObjectList|null
     */
    public function getInsuranceObjects()
    {
        return $this->insuranceObjects;
    }
    /**
     * Set insuranceObjects value
     * @param \App\Integration\Providers\Alliance3\DTO\InsuranceObjectList $insuranceObjects
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setInsuranceObjects(\App\Integration\Providers\Alliance3\DTO\InsuranceObjectList $insuranceObjects = null)
    {
        $this->insuranceObjects = $insuranceObjects;
        return $this;
    }
    /**
     * Get riskInfo value
     * @return \App\Integration\Providers\Alliance3\DTO\RiskInfoList|null
     */
    public function getRiskInfo()
    {
        return $this->riskInfo;
    }
    /**
     * Set riskInfo value
     * @param \App\Integration\Providers\Alliance3\DTO\RiskInfoList $riskInfo
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setRiskInfo(\App\Integration\Providers\Alliance3\DTO\RiskInfoList $riskInfo = null)
    {
        $this->riskInfo = $riskInfo;
        return $this;
    }
    /**
     * Get insPremTotal value
     * @return float|null
     */
    public function getInsPremTotal()
    {
        return $this->insPremTotal;
    }
    /**
     * Set insPremTotal value
     * @param float $insPremTotal
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setInsPremTotal($insPremTotal = null)
    {
        $this->insPremTotal = $insPremTotal;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setComment($comment = null)
    {
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get specialNotes value
     * @return string|null
     */
    public function getSpecialNotes()
    {
        return $this->specialNotes;
    }
    /**
     * Set specialNotes value
     * @param string $specialNotes
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setSpecialNotes($specialNotes = null)
    {
        $this->specialNotes = $specialNotes;
        return $this;
    }
    /**
     * Get departmentCode value
     * @return string|null
     */
    public function getDepartmentCode()
    {
        return $this->departmentCode;
    }
    /**
     * Set departmentCode value
     * @param string $departmentCode
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setDepartmentCode($departmentCode = null)
    {
        $this->departmentCode = $departmentCode;
        return $this;
    }
    /**
     * Get representative value
     * @return \App\Integration\Providers\Alliance3\DTO\RepresentativeInfo|null
     */
    public function getRepresentative()
    {
        return $this->representative;
    }
    /**
     * Set representative value
     * @param \App\Integration\Providers\Alliance3\DTO\RepresentativeInfo $representative
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setRepresentative(\App\Integration\Providers\Alliance3\DTO\RepresentativeInfo $representative = null)
    {
        $this->representative = $representative;
        return $this;
    }
    /**
     * Get currExchList value
     * @return \App\Integration\Providers\Alliance3\DTO\CurrencyExchList|null
     */
    public function getCurrExchList()
    {
        return $this->currExchList;
    }
    /**
     * Set currExchList value
     * @param \App\Integration\Providers\Alliance3\DTO\CurrencyExchList $currExchList
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setCurrExchList(\App\Integration\Providers\Alliance3\DTO\CurrencyExchList $currExchList = null)
    {
        $this->currExchList = $currExchList;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setID($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get dealerConractInfo value
     * @return \App\Integration\Providers\Alliance3\DTO\DealerConractInfo|null
     */
    public function getDealerConractInfo()
    {
        return $this->dealerConractInfo;
    }
    /**
     * Set dealerConractInfo value
     * @param \App\Integration\Providers\Alliance3\DTO\DealerConractInfo $dealerConractInfo
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setDealerConractInfo(\App\Integration\Providers\Alliance3\DTO\DealerConractInfo $dealerConractInfo = null)
    {
        $this->dealerConractInfo = $dealerConractInfo;
        return $this;
    }
    /**
     * Get pointOfSale value
     * @return \App\Integration\Providers\Alliance3\DTO\PointOfSale|null
     */
    public function getPointOfSale()
    {
        return $this->pointOfSale;
    }
    /**
     * Set pointOfSale value
     * @param \App\Integration\Providers\Alliance3\DTO\PointOfSale $pointOfSale
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setPointOfSale(\App\Integration\Providers\Alliance3\DTO\PointOfSale $pointOfSale = null)
    {
        $this->pointOfSale = $pointOfSale;
        return $this;
    }
    /**
     * Get userInfo value
     * @return \App\Integration\Providers\Alliance3\DTO\UserInfo|null
     */
    public function getUserInfo()
    {
        return $this->userInfo;
    }
    /**
     * Set userInfo value
     * @param \App\Integration\Providers\Alliance3\DTO\UserInfo $userInfo
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setUserInfo(\App\Integration\Providers\Alliance3\DTO\UserInfo $userInfo = null)
    {
        $this->userInfo = $userInfo;
        return $this;
    }
    /**
     * Get currCode value
     * @return string|null
     */
    public function getCurrCode()
    {
        return $this->currCode;
    }
    /**
     * Set currCode value
     * @param string $currCode
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setCurrCode($currCode = null)
    {
        $this->currCode = $currCode;
        return $this;
    }
    /**
     * Get calcID value
     * @return string|null
     */
    public function getCalcID()
    {
        return $this->calcID;
    }
    /**
     * Set calcID value
     * @param string $calcID
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setCalcID($calcID = null)
    {
        $this->calcID = $calcID;
        return $this;
    }
    /**
     * Get paymentsPlan value
     * @return \App\Integration\Providers\Alliance3\DTO\PaymentList|null
     */
    public function getPaymentsPlan()
    {
        return $this->paymentsPlan;
    }
    /**
     * Set paymentsPlan value
     * @param \App\Integration\Providers\Alliance3\DTO\PaymentList $paymentsPlan
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setPaymentsPlan(\App\Integration\Providers\Alliance3\DTO\PaymentList $paymentsPlan = null)
    {
        $this->paymentsPlan = $paymentsPlan;
        return $this;
    }
    /**
     * Get paymentsFact value
     * @return \App\Integration\Providers\Alliance3\DTO\PaymentList|null
     */
    public function getPaymentsFact()
    {
        return $this->paymentsFact;
    }
    /**
     * Set paymentsFact value
     * @param \App\Integration\Providers\Alliance3\DTO\PaymentList $paymentsFact
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setPaymentsFact(\App\Integration\Providers\Alliance3\DTO\PaymentList $paymentsFact = null)
    {
        $this->paymentsFact = $paymentsFact;
        return $this;
    }
    /**
     * Get discountAV value
     * @return float|null
     */
    public function getDiscountAV()
    {
        return $this->discountAV;
    }
    /**
     * Set discountAV value
     * @param float $discountAV
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setDiscountAV($discountAV = null)
    {
        $this->discountAV = $discountAV;
        return $this;
    }
    /**
     * Get clientWithoutLoss value
     * @return bool|null
     */
    public function getClientWithoutLoss()
    {
        return $this->clientWithoutLoss;
    }
    /**
     * Set clientWithoutLoss value
     * @param bool $clientWithoutLoss
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setClientWithoutLoss($clientWithoutLoss = null)
    {
        $this->clientWithoutLoss = $clientWithoutLoss;
        return $this;
    }
    /**
     * Get discountUnderwriter value
     * @return float|null
     */
    public function getDiscountUnderwriter()
    {
        return $this->discountUnderwriter;
    }
    /**
     * Set discountUnderwriter value
     * @param float $discountUnderwriter
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setDiscountUnderwriter($discountUnderwriter = null)
    {
        $this->discountUnderwriter = $discountUnderwriter;
        return $this;
    }
    /**
     * Get foulOfInsurance value
     * @return bool|null
     */
    public function getFoulOfInsurance()
    {
        return $this->foulOfInsurance;
    }
    /**
     * Set foulOfInsurance value
     * @param bool $foulOfInsurance
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setFoulOfInsurance($foulOfInsurance = null)
    {
        $this->foulOfInsurance = $foulOfInsurance;
        return $this;
    }
    /**
     * Get dateCalc value
     * @return string|null
     */
    public function getDateCalc()
    {
        return $this->dateCalc;
    }
    /**
     * Set dateCalc value
     * @param string $dateCalc
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setDateCalc($dateCalc = null)
    {
        $this->dateCalc = $dateCalc;
        return $this;
    }
    /**
     * Get internalID value
     * @return int|null
     */
    public function getInternalID()
    {
        return $this->internalID;
    }
    /**
     * Set internalID value
     * @param int $internalID
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setInternalID($internalID = null)
    {
        $this->internalID = $internalID;
        return $this;
    }
    /**
     * Get insByPeriods value
     * @return \App\Integration\Providers\Alliance3\DTO\InsuranceByPeriodList|null
     */
    public function getInsByPeriods()
    {
        return $this->insByPeriods;
    }
    /**
     * Set insByPeriods value
     * @param \App\Integration\Providers\Alliance3\DTO\InsuranceByPeriodList $insByPeriods
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setInsByPeriods(\App\Integration\Providers\Alliance3\DTO\InsuranceByPeriodList $insByPeriods = null)
    {
        $this->insByPeriods = $insByPeriods;
        return $this;
    }
    /**
     * Get manualRegistration value
     * @return bool|null
     */
    public function getManualRegistration()
    {
        return $this->manualRegistration;
    }
    /**
     * Set manualRegistration value
     * @param bool $manualRegistration
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setManualRegistration($manualRegistration = null)
    {
        $this->manualRegistration = $manualRegistration;
        return $this;
    }
    /**
     * Get manualProlongation value
     * @return bool|null
     */
    public function getManualProlongation()
    {
        return $this->manualProlongation;
    }
    /**
     * Set manualProlongation value
     * @param bool $manualProlongation
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setManualProlongation($manualProlongation = null)
    {
        $this->manualProlongation = $manualProlongation;
        return $this;
    }
    /**
     * Get procentAV value
     * @return float|null
     */
    public function getProcentAV()
    {
        return $this->procentAV;
    }
    /**
     * Set procentAV value
     * @param float $procentAV
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setProcentAV($procentAV = null)
    {
        $this->procentAV = $procentAV;
        return $this;
    }
    /**
     * Get sellerSK value
     * @return \App\Integration\Providers\Alliance3\DTO\UserInfo|null
     */
    public function getSellerSK()
    {
        return $this->sellerSK;
    }
    /**
     * Set sellerSK value
     * @param \App\Integration\Providers\Alliance3\DTO\UserInfo $sellerSK
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setSellerSK(\App\Integration\Providers\Alliance3\DTO\UserInfo $sellerSK = null)
    {
        $this->sellerSK = $sellerSK;
        return $this;
    }
    /**
     * Get sozdatelDogovora value
     * @return \App\Integration\Providers\Alliance3\DTO\UserInfo|null
     */
    public function getSozdatelDogovora()
    {
        return $this->sozdatelDogovora;
    }
    /**
     * Set sozdatelDogovora value
     * @param \App\Integration\Providers\Alliance3\DTO\UserInfo $sozdatelDogovora
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setSozdatelDogovora(\App\Integration\Providers\Alliance3\DTO\UserInfo $sozdatelDogovora = null)
    {
        $this->sozdatelDogovora = $sozdatelDogovora;
        return $this;
    }
    /**
     * Get marketProgrList value
     * @return \App\Integration\Providers\Alliance3\DTO\MarketProgrList|null
     */
    public function getMarketProgrList()
    {
        return $this->marketProgrList;
    }
    /**
     * Set marketProgrList value
     * @param \App\Integration\Providers\Alliance3\DTO\MarketProgrList $marketProgrList
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setMarketProgrList(\App\Integration\Providers\Alliance3\DTO\MarketProgrList $marketProgrList = null)
    {
        $this->marketProgrList = $marketProgrList;
        return $this;
    }
    /**
     * Get additionPayment value
     * @return float|null
     */
    public function getAdditionPayment()
    {
        return $this->additionPayment;
    }
    /**
     * Set additionPayment value
     * @param float $additionPayment
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setAdditionPayment($additionPayment = null)
    {
        $this->additionPayment = $additionPayment;
        return $this;
    }
    /**
     * Get pechatNaBlanke value
     * @return bool|null
     */
    public function getPechatNaBlanke()
    {
        return $this->pechatNaBlanke;
    }
    /**
     * Set pechatNaBlanke value
     * @param bool $pechatNaBlanke
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setPechatNaBlanke($pechatNaBlanke = null)
    {
        $this->pechatNaBlanke = $pechatNaBlanke;
        return $this;
    }
    /**
     * Get reasonsForReplacement value
     * @return \App\Integration\Providers\Alliance3\DTO\ReasonsForReplacementList|null
     */
    public function getReasonsForReplacement()
    {
        return $this->reasonsForReplacement;
    }
    /**
     * Set reasonsForReplacement value
     * @param \App\Integration\Providers\Alliance3\DTO\ReasonsForReplacementList $reasonsForReplacement
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setReasonsForReplacement(\App\Integration\Providers\Alliance3\DTO\ReasonsForReplacementList $reasonsForReplacement = null)
    {
        $this->reasonsForReplacement = $reasonsForReplacement;
        return $this;
    }
    /**
     * Get blankPolicaNomer value
     * @return string|null
     */
    public function getBlankPolicaNomer()
    {
        return $this->blankPolicaNomer;
    }
    /**
     * Set blankPolicaNomer value
     * @param string $blankPolicaNomer
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setBlankPolicaNomer($blankPolicaNomer = null)
    {
        $this->blankPolicaNomer = $blankPolicaNomer;
        return $this;
    }
    /**
     * Get blankPolicaSeria value
     * @return string|null
     */
    public function getBlankPolicaSeria()
    {
        return $this->blankPolicaSeria;
    }
    /**
     * Set blankPolicaSeria value
     * @param string $blankPolicaSeria
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setBlankPolicaSeria($blankPolicaSeria = null)
    {
        $this->blankPolicaSeria = $blankPolicaSeria;
        return $this;
    }
    /**
     * Get kvitanciaNomer value
     * @return string|null
     */
    public function getKvitanciaNomer()
    {
        return $this->kvitanciaNomer;
    }
    /**
     * Set kvitanciaNomer value
     * @param string $kvitanciaNomer
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setKvitanciaNomer($kvitanciaNomer = null)
    {
        $this->kvitanciaNomer = $kvitanciaNomer;
        return $this;
    }
    /**
     * Get kvitanciaSeria value
     * @return string|null
     */
    public function getKvitanciaSeria()
    {
        return $this->kvitanciaSeria;
    }
    /**
     * Set kvitanciaSeria value
     * @param string $kvitanciaSeria
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setKvitanciaSeria($kvitanciaSeria = null)
    {
        $this->kvitanciaSeria = $kvitanciaSeria;
        return $this;
    }
    /**
     * Get prevWasInAnotherInsurer value
     * @return bool|null
     */
    public function getPrevWasInAnotherInsurer()
    {
        return $this->prevWasInAnotherInsurer;
    }
    /**
     * Set prevWasInAnotherInsurer value
     * @param bool $prevWasInAnotherInsurer
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setPrevWasInAnotherInsurer($prevWasInAnotherInsurer = null)
    {
        $this->prevWasInAnotherInsurer = $prevWasInAnotherInsurer;
        return $this;
    }
    /**
     * Get prevLossCount value
     * @return int|null
     */
    public function getPrevLossCount()
    {
        return $this->prevLossCount;
    }
    /**
     * Set prevLossCount value
     * @param int $prevLossCount
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setPrevLossCount($prevLossCount = null)
    {
        $this->prevLossCount = $prevLossCount;
        return $this;
    }
    /**
     * Get prevLossCount3dPartFault value
     * @return int|null
     */
    public function getPrevLossCount3dPartFault()
    {
        return $this->prevLossCount3dPartFault;
    }
    /**
     * Set prevLossCount3dPartFault value
     * @param int $prevLossCount3dPartFault
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setPrevLossCount3dPartFault($prevLossCount3dPartFault = null)
    {
        $this->prevLossCount3dPartFault = $prevLossCount3dPartFault;
        return $this;
    }
    /**
     * Get skidkaAvVProc value
     * @return bool|null
     */
    public function getSkidkaAvVProc()
    {
        return $this->skidkaAvVProc;
    }
    /**
     * Set skidkaAvVProc value
     * @param bool $skidkaAvVProc
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setSkidkaAvVProc($skidkaAvVProc = null)
    {
        $this->skidkaAvVProc = $skidkaAvVProc;
        return $this;
    }
    /**
     * Get skidkaKV value
     * @return float|null
     */
    public function getSkidkaKV()
    {
        return $this->skidkaKV;
    }
    /**
     * Set skidkaKV value
     * @param float $skidkaKV
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setSkidkaKV($skidkaKV = null)
    {
        $this->skidkaKV = $skidkaKV;
        return $this;
    }
    /**
     * Get insurantDocType value
     * @return string|null
     */
    public function getInsurantDocType()
    {
        return $this->insurantDocType;
    }
    /**
     * Set insurantDocType value
     * @param string $insurantDocType
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setInsurantDocType($insurantDocType = null)
    {
        $this->insurantDocType = $insurantDocType;
        return $this;
    }
    /**
     * Get storeAvProc value
     * @return float|null
     */
    public function getStoreAvProc()
    {
        return $this->storeAvProc;
    }
    /**
     * Set storeAvProc value
     * @param float $storeAvProc
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setStoreAvProc($storeAvProc = null)
    {
        $this->storeAvProc = $storeAvProc;
        return $this;
    }
    /**
     * Get additionalStoreAvProc value
     * @return float|null
     */
    public function getAdditionalStoreAvProc()
    {
        return $this->additionalStoreAvProc;
    }
    /**
     * Set additionalStoreAvProc value
     * @param float $additionalStoreAvProc
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setAdditionalStoreAvProc($additionalStoreAvProc = null)
    {
        $this->additionalStoreAvProc = $additionalStoreAvProc;
        return $this;
    }
    /**
     * Get locality value
     * @return string|null
     */
    public function getLocality()
    {
        return $this->locality;
    }
    /**
     * Set locality value
     * @param string $locality
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setLocality($locality = null)
    {
        $this->locality = $locality;
        return $this;
    }
    /**
     * Get region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * Set region value
     * @param string $region
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setRegion($region = null)
    {
        $this->region = $region;
        return $this;
    }
    /**
     * Get localityCodeKLADR value
     * @return string|null
     */
    public function getLocalityCodeKLADR()
    {
        return $this->localityCodeKLADR;
    }
    /**
     * Set localityCodeKLADR value
     * @param string $localityCodeKLADR
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setLocalityCodeKLADR($localityCodeKLADR = null)
    {
        $this->localityCodeKLADR = $localityCodeKLADR;
        return $this;
    }
    /**
     * Get sequence value
     * @return \App\Integration\Providers\Alliance3\DTO\PolicySequence|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param \App\Integration\Providers\Alliance3\DTO\PolicySequence $sequence
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setSequence(\App\Integration\Providers\Alliance3\DTO\PolicySequence $sequence = null)
    {
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Get blanks value
     * @return \App\Integration\Providers\Alliance3\DTO\BlankList|null
     */
    public function getBlanks()
    {
        return $this->blanks;
    }
    /**
     * Set blanks value
     * @param \App\Integration\Providers\Alliance3\DTO\BlankList $blanks
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setBlanks(\App\Integration\Providers\Alliance3\DTO\BlankList $blanks = null)
    {
        $this->blanks = $blanks;
        return $this;
    }
    /**
     * Get policyCorrected value
     * @return bool|null
     */
    public function getPolicyCorrected()
    {
        return $this->policyCorrected;
    }
    /**
     * Set policyCorrected value
     * @param bool $policyCorrected
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setPolicyCorrected($policyCorrected = null)
    {
        $this->policyCorrected = $policyCorrected;
        return $this;
    }
    /**
     * Get correctedPolicySeries value
     * @return string|null
     */
    public function getCorrectedPolicySeries()
    {
        return $this->correctedPolicySeries;
    }
    /**
     * Set correctedPolicySeries value
     * @param string $correctedPolicySeries
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setCorrectedPolicySeries($correctedPolicySeries = null)
    {
        $this->correctedPolicySeries = $correctedPolicySeries;
        return $this;
    }
    /**
     * Get correctedPolicyNumber value
     * @return string|null
     */
    public function getCorrectedPolicyNumber()
    {
        return $this->correctedPolicyNumber;
    }
    /**
     * Set correctedPolicyNumber value
     * @param string $correctedPolicyNumber
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setCorrectedPolicyNumber($correctedPolicyNumber = null)
    {
        $this->correctedPolicyNumber = $correctedPolicyNumber;
        return $this;
    }
    /**
     * Get contractCreationDate value
     * @return string|null
     */
    public function getContractCreationDate()
    {
        return $this->contractCreationDate;
    }
    /**
     * Set contractCreationDate value
     * @param string $contractCreationDate
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setContractCreationDate($contractCreationDate = null)
    {
        $this->contractCreationDate = $contractCreationDate;
        return $this;
    }
    /**
     * Get correctedPolicyId value
     * @return int|null
     */
    public function getCorrectedPolicyId()
    {
        return $this->correctedPolicyId;
    }
    /**
     * Set correctedPolicyId value
     * @param int $correctedPolicyId
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setCorrectedPolicyId($correctedPolicyId = null)
    {
        $this->correctedPolicyId = $correctedPolicyId;
        return $this;
    }
    /**
     * Get replacedPolicyId value
     * @return int|null
     */
    public function getReplacedPolicyId()
    {
        return $this->replacedPolicyId;
    }
    /**
     * Set replacedPolicyId value
     * @param int $replacedPolicyId
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setReplacedPolicyId($replacedPolicyId = null)
    {
        $this->replacedPolicyId = $replacedPolicyId;
        return $this;
    }
    /**
     * Get dateIssue value
     * @return string|null
     */
    public function getDateIssue()
    {
        return $this->dateIssue;
    }
    /**
     * Set dateIssue value
     * @param string $dateIssue
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setDateIssue($dateIssue = null)
    {
        $this->dateIssue = $dateIssue;
        return $this;
    }
    /**
     * Get sellerCode value
     * @return string|null
     */
    public function getSellerCode()
    {
        return $this->sellerCode;
    }
    /**
     * Set sellerCode value
     * @param string $sellerCode
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setSellerCode($sellerCode = null)
    {
        $this->sellerCode = $sellerCode;
        return $this;
    }
    /**
     * Get insurantChanges value
     * @return \App\Integration\Providers\Alliance3\DTO\SubjectChangesInfo|null
     */
    public function getInsurantChanges()
    {
        return $this->insurantChanges;
    }
    /**
     * Set insurantChanges value
     * @param \App\Integration\Providers\Alliance3\DTO\SubjectChangesInfo $insurantChanges
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setInsurantChanges(\App\Integration\Providers\Alliance3\DTO\SubjectChangesInfo $insurantChanges = null)
    {
        $this->insurantChanges = $insurantChanges;
        return $this;
    }
    /**
     * Get prevWasInThisPartner value
     * @return bool|null
     */
    public function getPrevWasInThisPartner()
    {
        return $this->prevWasInThisPartner;
    }
    /**
     * Set prevWasInThisPartner value
     * @param bool $prevWasInThisPartner
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setPrevWasInThisPartner($prevWasInThisPartner = null)
    {
        $this->prevWasInThisPartner = $prevWasInThisPartner;
        return $this;
    }
    /**
     * Get ksp value
     * @return float|null
     */
    public function getKsp()
    {
        return $this->ksp;
    }
    /**
     * Set ksp value
     * @param float $ksp
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setKsp($ksp = null)
    {
        $this->ksp = $ksp;
        return $this;
    }
    /**
     * Get replacedPolicyNumberInChain value
     * @return int|null
     */
    public function getReplacedPolicyNumberInChain()
    {
        return $this->replacedPolicyNumberInChain;
    }
    /**
     * Set replacedPolicyNumberInChain value
     * @param int $replacedPolicyNumberInChain
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setReplacedPolicyNumberInChain($replacedPolicyNumberInChain = null)
    {
        $this->replacedPolicyNumberInChain = $replacedPolicyNumberInChain;
        return $this;
    }
    /**
     * Get insurantRepresentative value
     * @return \App\Integration\Providers\Alliance3\DTO\SubjectRepresentative|null
     */
    public function getInsurantRepresentative()
    {
        return $this->insurantRepresentative;
    }
    /**
     * Set insurantRepresentative value
     * @param \App\Integration\Providers\Alliance3\DTO\SubjectRepresentative $insurantRepresentative
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setInsurantRepresentative(\App\Integration\Providers\Alliance3\DTO\SubjectRepresentative $insurantRepresentative = null)
    {
        $this->insurantRepresentative = $insurantRepresentative;
        return $this;
    }
    /**
     * Get insurantBankRequisites value
     * @return \App\Integration\Providers\Alliance3\DTO\BankRequisitesList|null
     */
    public function getInsurantBankRequisites()
    {
        return $this->insurantBankRequisites;
    }
    /**
     * Set insurantBankRequisites value
     * @param \App\Integration\Providers\Alliance3\DTO\BankRequisitesList $insurantBankRequisites
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setInsurantBankRequisites(\App\Integration\Providers\Alliance3\DTO\BankRequisitesList $insurantBankRequisites = null)
    {
        $this->insurantBankRequisites = $insurantBankRequisites;
        return $this;
    }
    /**
     * Get parameters value
     * @return \App\Integration\Providers\Alliance3\DTO\ParametrList|null
     */
    public function getParameters()
    {
        return $this->parameters;
    }
    /**
     * Set parameters value
     * @param \App\Integration\Providers\Alliance3\DTO\ParametrList $parameters
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setParameters(\App\Integration\Providers\Alliance3\DTO\ParametrList $parameters = null)
    {
        $this->parameters = $parameters;
        return $this;
    }
    /**
     * Get subrogation value
     * @return bool|null
     */
    public function getSubrogation()
    {
        return $this->subrogation;
    }
    /**
     * Set subrogation value
     * @param bool $subrogation
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setSubrogation($subrogation = null)
    {
        $this->subrogation = $subrogation;
        return $this;
    }
    /**
     * Get ikpCuratora value
     * @return string|null
     */
    public function getIkpCuratora()
    {
        return $this->ikpCuratora;
    }
    /**
     * Set ikpCuratora value
     * @param string $ikpCuratora
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setIkpCuratora($ikpCuratora = null)
    {
        $this->ikpCuratora = $ikpCuratora;
        return $this;
    }
    /**
     * Get cross value
     * @return \App\Integration\Providers\Alliance3\DTO\Cross|null
     */
    public function getCross()
    {
        return $this->cross;
    }
    /**
     * Set cross value
     * @param \App\Integration\Providers\Alliance3\DTO\Cross $cross
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setCross(\App\Integration\Providers\Alliance3\DTO\Cross $cross = null)
    {
        $this->cross = $cross;
        return $this;
    }
    /**
     * Get beneficiary2 value
     * @return \App\Integration\Providers\Alliance3\DTO\SubjectInfo|null
     */
    public function getBeneficiary2()
    {
        return $this->beneficiary2;
    }
    /**
     * Set beneficiary2 value
     * @param \App\Integration\Providers\Alliance3\DTO\SubjectInfo $beneficiary2
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setBeneficiary2(\App\Integration\Providers\Alliance3\DTO\SubjectInfo $beneficiary2 = null)
    {
        $this->beneficiary2 = $beneficiary2;
        return $this;
    }
    /**
     * Get signer value
     * @return \App\Integration\Providers\Alliance3\DTO\RepresentativeInfo|null
     */
    public function getSigner()
    {
        return $this->signer;
    }
    /**
     * Set signer value
     * @param \App\Integration\Providers\Alliance3\DTO\RepresentativeInfo $signer
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setSigner(\App\Integration\Providers\Alliance3\DTO\RepresentativeInfo $signer = null)
    {
        $this->signer = $signer;
        return $this;
    }
    /**
     * Get periodOfInsurance value
     * @return int|null
     */
    public function getPeriodOfInsurance()
    {
        return $this->periodOfInsurance;
    }
    /**
     * Set periodOfInsurance value
     * @param int $periodOfInsurance
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setPeriodOfInsurance($periodOfInsurance = null)
    {
        $this->periodOfInsurance = $periodOfInsurance;
        return $this;
    }
    /**
     * Get timeUnitPeriodOfInsurance value
     * @return string|null
     */
    public function getTimeUnitPeriodOfInsurance()
    {
        return $this->timeUnitPeriodOfInsurance;
    }
    /**
     * Set timeUnitPeriodOfInsurance value
     * @param string $timeUnitPeriodOfInsurance
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setTimeUnitPeriodOfInsurance($timeUnitPeriodOfInsurance = null)
    {
        $this->timeUnitPeriodOfInsurance = $timeUnitPeriodOfInsurance;
        return $this;
    }
    /**
     * Get beneficiaries value
     * @return \App\Integration\Providers\Alliance3\DTO\Beneficiaries|null
     */
    public function getBeneficiaries()
    {
        return $this->beneficiaries;
    }
    /**
     * Set beneficiaries value
     * @param \App\Integration\Providers\Alliance3\DTO\Beneficiaries $beneficiaries
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setBeneficiaries(\App\Integration\Providers\Alliance3\DTO\Beneficiaries $beneficiaries = null)
    {
        $this->beneficiaries = $beneficiaries;
        return $this;
    }
    /**
     * Get countYearsWithoutLoss value
     * @return int|null
     */
    public function getCountYearsWithoutLoss()
    {
        return $this->countYearsWithoutLoss;
    }
    /**
     * Set countYearsWithoutLoss value
     * @param int $countYearsWithoutLoss
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setCountYearsWithoutLoss($countYearsWithoutLoss = null)
    {
        $this->countYearsWithoutLoss = $countYearsWithoutLoss;
        return $this;
    }
    /**
     * Get countInsEventsPrevPolicy value
     * @return int|null
     */
    public function getCountInsEventsPrevPolicy()
    {
        return $this->countInsEventsPrevPolicy;
    }
    /**
     * Set countInsEventsPrevPolicy value
     * @param int $countInsEventsPrevPolicy
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setCountInsEventsPrevPolicy($countInsEventsPrevPolicy = null)
    {
        $this->countInsEventsPrevPolicy = $countInsEventsPrevPolicy;
        return $this;
    }
    /**
     * Get epolicy value
     * @return bool|null
     */
    public function getEpolicy()
    {
        return $this->epolicy;
    }
    /**
     * Set epolicy value
     * @param bool $epolicy
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setEpolicy($epolicy = null)
    {
        $this->epolicy = $epolicy;
        return $this;
    }
    /**
     * Get onlinePayment value
     * @return bool|null
     */
    public function getOnlinePayment()
    {
        return $this->onlinePayment;
    }
    /**
     * Set onlinePayment value
     * @param bool $onlinePayment
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setOnlinePayment($onlinePayment = null)
    {
        $this->onlinePayment = $onlinePayment;
        return $this;
    }
    /**
     * Get stateHistoryList value
     * @return \App\Integration\Providers\Alliance3\DTO\PolicyStateHistoryList|null
     */
    public function getStateHistoryList()
    {
        return $this->stateHistoryList;
    }
    /**
     * Set stateHistoryList value
     * @param \App\Integration\Providers\Alliance3\DTO\PolicyStateHistoryList $stateHistoryList
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setStateHistoryList(\App\Integration\Providers\Alliance3\DTO\PolicyStateHistoryList $stateHistoryList = null)
    {
        $this->stateHistoryList = $stateHistoryList;
        return $this;
    }
    /**
     * Get consentedToPersonalDataProcessing value
     * @return bool|null
     */
    public function getConsentedToPersonalDataProcessing()
    {
        return $this->consentedToPersonalDataProcessing;
    }
    /**
     * Set consentedToPersonalDataProcessing value
     * @param bool $consentedToPersonalDataProcessing
     * @return \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public function setConsentedToPersonalDataProcessing($consentedToPersonalDataProcessing = null)
    {
        $this->consentedToPersonalDataProcessing = $consentedToPersonalDataProcessing;
        return $this;
    }
}
