<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentDocument DTO
 * @subpackage Structs
 */
class PaymentDocument extends AbstractStructBase
{
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $number;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $date;
    /**
     * The noncashPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $noncashPayment;
    /**
     * The serial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serial;
    /**
     * Constructor method for PaymentDocument
     * @uses PaymentDocument::setType()
     * @uses PaymentDocument::setNumber()
     * @uses PaymentDocument::setDate()
     * @uses PaymentDocument::setNoncashPayment()
     * @uses PaymentDocument::setSerial()
     * @param string $type
     * @param string $number
     * @param string $date
     * @param bool $noncashPayment
     * @param string $serial
     */
    public function __construct($type = null, $number = null, $date = null, $noncashPayment = null, $serial = null)
    {
        $this
            ->setType($type)
            ->setNumber($number)
            ->setDate($date)
            ->setNoncashPayment($noncashPayment)
            ->setSerial($serial);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \App\Integration\Providers\Alliance3\DTO\PaymentDocument
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \App\Integration\Providers\Alliance3\DTO\PaymentDocument
     */
    public function setNumber($number = null)
    {
        $this->number = $number;
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \App\Integration\Providers\Alliance3\DTO\PaymentDocument
     */
    public function setDate($date = null)
    {
        $this->date = $date;
        return $this;
    }
    /**
     * Get noncashPayment value
     * @return bool|null
     */
    public function getNoncashPayment()
    {
        return $this->noncashPayment;
    }
    /**
     * Set noncashPayment value
     * @param bool $noncashPayment
     * @return \App\Integration\Providers\Alliance3\DTO\PaymentDocument
     */
    public function setNoncashPayment($noncashPayment = null)
    {
        $this->noncashPayment = $noncashPayment;
        return $this;
    }
    /**
     * Get serial value
     * @return string|null
     */
    public function getSerial()
    {
        return $this->serial;
    }
    /**
     * Set serial value
     * @param string $serial
     * @return \App\Integration\Providers\Alliance3\DTO\PaymentDocument
     */
    public function setSerial($serial = null)
    {
        $this->serial = $serial;
        return $this;
    }
}
