<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment DTO
 * @subpackage Structs
 */
class Payment extends AbstractStructBase
{
    /**
     * The policyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policyID;
    /**
     * The payer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\SubjectInfo
     */
    public $payer;
    /**
     * The owner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\SubjectInfo
     */
    public $owner;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $number;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $date;
    /**
     * The invoiceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $invoiceNumber;
    /**
     * The invoiceDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $invoiceDate;
    /**
     * The sum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $sum;
    /**
     * The paymentDocument
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\PaymentDocument
     */
    public $paymentDocument;
    /**
     * The sumRur
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $sumRur;
    /**
     * The paymentRecepient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentRecepient;
    /**
     * The paymentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentMethod;
    /**
     * The pointOfSale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\PointOfSale
     */
    public $pointOfSale;
    /**
     * The parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\ParametrList
     */
    public $parameters;
    /**
     * The paymentDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentDate;
    /**
     * The dateConfirmed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateConfirmed;
    /**
     * The dateChanged
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateChanged;
    /**
     * The financial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $financial;
    /**
     * The cancelled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $cancelled;
    /**
     * The dateCancelled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateCancelled;
    /**
     * The agent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\AgentSubject
     */
    public $agent;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $exchangeRate;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The percentAV
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $percentAV;
    /**
     * The percentDiscount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $percentDiscount;
    /**
     * The percentAddAV
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $percentAddAV;
    /**
     * Constructor method for Payment
     * @uses Payment::setPolicyID()
     * @uses Payment::setPayer()
     * @uses Payment::setOwner()
     * @uses Payment::setNumber()
     * @uses Payment::setDate()
     * @uses Payment::setInvoiceNumber()
     * @uses Payment::setInvoiceDate()
     * @uses Payment::setSum()
     * @uses Payment::setPaymentDocument()
     * @uses Payment::setSumRur()
     * @uses Payment::setPaymentRecepient()
     * @uses Payment::setPaymentMethod()
     * @uses Payment::setPointOfSale()
     * @uses Payment::setParameters()
     * @uses Payment::setPaymentDate()
     * @uses Payment::setDateConfirmed()
     * @uses Payment::setDateChanged()
     * @uses Payment::setFinancial()
     * @uses Payment::setCancelled()
     * @uses Payment::setDateCancelled()
     * @uses Payment::setAgent()
     * @uses Payment::setCurrency()
     * @uses Payment::setExchangeRate()
     * @uses Payment::setType()
     * @uses Payment::setPercentAV()
     * @uses Payment::setPercentDiscount()
     * @uses Payment::setPercentAddAV()
     * @param string $policyID
     * @param \App\Integration\Providers\Alliance3\DTO\SubjectInfo $payer
     * @param \App\Integration\Providers\Alliance3\DTO\SubjectInfo $owner
     * @param int $number
     * @param string $date
     * @param string $invoiceNumber
     * @param string $invoiceDate
     * @param float $sum
     * @param \App\Integration\Providers\Alliance3\DTO\PaymentDocument $paymentDocument
     * @param float $sumRur
     * @param string $paymentRecepient
     * @param string $paymentMethod
     * @param \App\Integration\Providers\Alliance3\DTO\PointOfSale $pointOfSale
     * @param \App\Integration\Providers\Alliance3\DTO\ParametrList $parameters
     * @param string $paymentDate
     * @param string $dateConfirmed
     * @param string $dateChanged
     * @param bool $financial
     * @param bool $cancelled
     * @param string $dateCancelled
     * @param \App\Integration\Providers\Alliance3\DTO\AgentSubject $agent
     * @param string $currency
     * @param float $exchangeRate
     * @param string $type
     * @param float $percentAV
     * @param float $percentDiscount
     * @param float $percentAddAV
     */
    public function __construct($policyID = null, \App\Integration\Providers\Alliance3\DTO\SubjectInfo $payer = null, \App\Integration\Providers\Alliance3\DTO\SubjectInfo $owner = null, $number = null, $date = null, $invoiceNumber = null, $invoiceDate = null, $sum = null, \App\Integration\Providers\Alliance3\DTO\PaymentDocument $paymentDocument = null, $sumRur = null, $paymentRecepient = null, $paymentMethod = null, \App\Integration\Providers\Alliance3\DTO\PointOfSale $pointOfSale = null, \App\Integration\Providers\Alliance3\DTO\ParametrList $parameters = null, $paymentDate = null, $dateConfirmed = null, $dateChanged = null, $financial = null, $cancelled = null, $dateCancelled = null, \App\Integration\Providers\Alliance3\DTO\AgentSubject $agent = null, $currency = null, $exchangeRate = null, $type = null, $percentAV = null, $percentDiscount = null, $percentAddAV = null)
    {
        $this
            ->setPolicyID($policyID)
            ->setPayer($payer)
            ->setOwner($owner)
            ->setNumber($number)
            ->setDate($date)
            ->setInvoiceNumber($invoiceNumber)
            ->setInvoiceDate($invoiceDate)
            ->setSum($sum)
            ->setPaymentDocument($paymentDocument)
            ->setSumRur($sumRur)
            ->setPaymentRecepient($paymentRecepient)
            ->setPaymentMethod($paymentMethod)
            ->setPointOfSale($pointOfSale)
            ->setParameters($parameters)
            ->setPaymentDate($paymentDate)
            ->setDateConfirmed($dateConfirmed)
            ->setDateChanged($dateChanged)
            ->setFinancial($financial)
            ->setCancelled($cancelled)
            ->setDateCancelled($dateCancelled)
            ->setAgent($agent)
            ->setCurrency($currency)
            ->setExchangeRate($exchangeRate)
            ->setType($type)
            ->setPercentAV($percentAV)
            ->setPercentDiscount($percentDiscount)
            ->setPercentAddAV($percentAddAV);
    }
    /**
     * Get policyID value
     * @return string|null
     */
    public function getPolicyID()
    {
        return $this->policyID;
    }
    /**
     * Set policyID value
     * @param string $policyID
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setPolicyID($policyID = null)
    {
        $this->policyID = $policyID;
        return $this;
    }
    /**
     * Get payer value
     * @return \App\Integration\Providers\Alliance3\DTO\SubjectInfo|null
     */
    public function getPayer()
    {
        return $this->payer;
    }
    /**
     * Set payer value
     * @param \App\Integration\Providers\Alliance3\DTO\SubjectInfo $payer
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setPayer(\App\Integration\Providers\Alliance3\DTO\SubjectInfo $payer = null)
    {
        $this->payer = $payer;
        return $this;
    }
    /**
     * Get owner value
     * @return \App\Integration\Providers\Alliance3\DTO\SubjectInfo|null
     */
    public function getOwner()
    {
        return $this->owner;
    }
    /**
     * Set owner value
     * @param \App\Integration\Providers\Alliance3\DTO\SubjectInfo $owner
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setOwner(\App\Integration\Providers\Alliance3\DTO\SubjectInfo $owner = null)
    {
        $this->owner = $owner;
        return $this;
    }
    /**
     * Get number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param int $number
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setNumber($number = null)
    {
        $this->number = $number;
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setDate($date = null)
    {
        $this->date = $date;
        return $this;
    }
    /**
     * Get invoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->invoiceNumber;
    }
    /**
     * Set invoiceNumber value
     * @param string $invoiceNumber
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        $this->invoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get invoiceDate value
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->invoiceDate;
    }
    /**
     * Set invoiceDate value
     * @param string $invoiceDate
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        $this->invoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get sum value
     * @return float|null
     */
    public function getSum()
    {
        return $this->sum;
    }
    /**
     * Set sum value
     * @param float $sum
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setSum($sum = null)
    {
        $this->sum = $sum;
        return $this;
    }
    /**
     * Get paymentDocument value
     * @return \App\Integration\Providers\Alliance3\DTO\PaymentDocument|null
     */
    public function getPaymentDocument()
    {
        return $this->paymentDocument;
    }
    /**
     * Set paymentDocument value
     * @param \App\Integration\Providers\Alliance3\DTO\PaymentDocument $paymentDocument
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setPaymentDocument(\App\Integration\Providers\Alliance3\DTO\PaymentDocument $paymentDocument = null)
    {
        $this->paymentDocument = $paymentDocument;
        return $this;
    }
    /**
     * Get sumRur value
     * @return float|null
     */
    public function getSumRur()
    {
        return $this->sumRur;
    }
    /**
     * Set sumRur value
     * @param float $sumRur
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setSumRur($sumRur = null)
    {
        $this->sumRur = $sumRur;
        return $this;
    }
    /**
     * Get paymentRecepient value
     * @return string|null
     */
    public function getPaymentRecepient()
    {
        return $this->paymentRecepient;
    }
    /**
     * Set paymentRecepient value
     * @param string $paymentRecepient
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setPaymentRecepient($paymentRecepient = null)
    {
        $this->paymentRecepient = $paymentRecepient;
        return $this;
    }
    /**
     * Get paymentMethod value
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }
    /**
     * Set paymentMethod value
     * @param string $paymentMethod
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get pointOfSale value
     * @return \App\Integration\Providers\Alliance3\DTO\PointOfSale|null
     */
    public function getPointOfSale()
    {
        return $this->pointOfSale;
    }
    /**
     * Set pointOfSale value
     * @param \App\Integration\Providers\Alliance3\DTO\PointOfSale $pointOfSale
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setPointOfSale(\App\Integration\Providers\Alliance3\DTO\PointOfSale $pointOfSale = null)
    {
        $this->pointOfSale = $pointOfSale;
        return $this;
    }
    /**
     * Get parameters value
     * @return \App\Integration\Providers\Alliance3\DTO\ParametrList|null
     */
    public function getParameters()
    {
        return $this->parameters;
    }
    /**
     * Set parameters value
     * @param \App\Integration\Providers\Alliance3\DTO\ParametrList $parameters
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setParameters(\App\Integration\Providers\Alliance3\DTO\ParametrList $parameters = null)
    {
        $this->parameters = $parameters;
        return $this;
    }
    /**
     * Get paymentDate value
     * @return string|null
     */
    public function getPaymentDate()
    {
        return $this->paymentDate;
    }
    /**
     * Set paymentDate value
     * @param string $paymentDate
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setPaymentDate($paymentDate = null)
    {
        $this->paymentDate = $paymentDate;
        return $this;
    }
    /**
     * Get dateConfirmed value
     * @return string|null
     */
    public function getDateConfirmed()
    {
        return $this->dateConfirmed;
    }
    /**
     * Set dateConfirmed value
     * @param string $dateConfirmed
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setDateConfirmed($dateConfirmed = null)
    {
        $this->dateConfirmed = $dateConfirmed;
        return $this;
    }
    /**
     * Get dateChanged value
     * @return string|null
     */
    public function getDateChanged()
    {
        return $this->dateChanged;
    }
    /**
     * Set dateChanged value
     * @param string $dateChanged
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setDateChanged($dateChanged = null)
    {
        $this->dateChanged = $dateChanged;
        return $this;
    }
    /**
     * Get financial value
     * @return bool|null
     */
    public function getFinancial()
    {
        return $this->financial;
    }
    /**
     * Set financial value
     * @param bool $financial
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setFinancial($financial = null)
    {
        $this->financial = $financial;
        return $this;
    }
    /**
     * Get cancelled value
     * @return bool|null
     */
    public function getCancelled()
    {
        return $this->cancelled;
    }
    /**
     * Set cancelled value
     * @param bool $cancelled
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setCancelled($cancelled = null)
    {
        $this->cancelled = $cancelled;
        return $this;
    }
    /**
     * Get dateCancelled value
     * @return string|null
     */
    public function getDateCancelled()
    {
        return $this->dateCancelled;
    }
    /**
     * Set dateCancelled value
     * @param string $dateCancelled
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setDateCancelled($dateCancelled = null)
    {
        $this->dateCancelled = $dateCancelled;
        return $this;
    }
    /**
     * Get agent value
     * @return \App\Integration\Providers\Alliance3\DTO\AgentSubject|null
     */
    public function getAgent()
    {
        return $this->agent;
    }
    /**
     * Set agent value
     * @param \App\Integration\Providers\Alliance3\DTO\AgentSubject $agent
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setAgent(\App\Integration\Providers\Alliance3\DTO\AgentSubject $agent = null)
    {
        $this->agent = $agent;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setCurrency($currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setExchangeRate($exchangeRate = null)
    {
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Get percentAV value
     * @return float|null
     */
    public function getPercentAV()
    {
        return $this->percentAV;
    }
    /**
     * Set percentAV value
     * @param float $percentAV
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setPercentAV($percentAV = null)
    {
        $this->percentAV = $percentAV;
        return $this;
    }
    /**
     * Get percentDiscount value
     * @return float|null
     */
    public function getPercentDiscount()
    {
        return $this->percentDiscount;
    }
    /**
     * Set percentDiscount value
     * @param float $percentDiscount
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setPercentDiscount($percentDiscount = null)
    {
        $this->percentDiscount = $percentDiscount;
        return $this;
    }
    /**
     * Get percentAddAV value
     * @return float|null
     */
    public function getPercentAddAV()
    {
        return $this->percentAddAV;
    }
    /**
     * Set percentAddAV value
     * @param float $percentAddAV
     * @return \App\Integration\Providers\Alliance3\DTO\Payment
     */
    public function setPercentAddAV($percentAddAV = null)
    {
        $this->percentAddAV = $percentAddAV;
        return $this;
    }
}
