<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParametrList DTO
 * @subpackage Structs
 */
class ParametrList extends AbstractStructBase
{
    /**
     * The parameter
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\ParametrInfo[]
     */
    public $parameter;
    /**
     * Constructor method for ParametrList
     * @uses ParametrList::setParameter()
     * @param \App\Integration\Providers\Alliance3\DTO\ParametrInfo[] $parameter
     */
    public function __construct(array $parameter = array())
    {
        $this
            ->setParameter($parameter);
    }
    /**
     * Get parameter value
     * @return \App\Integration\Providers\Alliance3\DTO\ParametrInfo[]|null
     */
    public function getParameter()
    {
        return $this->parameter;
    }
    /**
     * Set parameter value
     * @param \App\Integration\Providers\Alliance3\DTO\ParametrInfo[] $parameter
     * @return \App\Integration\Providers\Alliance3\DTO\ParametrList
     */
    public function setParameter(array $parameter = array())
    {
        $this->parameter = $parameter;
        return $this;
    }
    /**
     * Add item to parameter value
     * @throws \InvalidArgumentException
     * @param \App\Integration\Providers\Alliance3\DTO\ParametrInfo $item
     * @return \App\Integration\Providers\Alliance3\DTO\ParametrList
     */
    public function addToParameter(\App\Integration\Providers\Alliance3\DTO\ParametrInfo $item)
    {
        $this->parameter[] = $item;
        return $this;
    }
}
