<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParameterDictionaryInfo DTO
 * Meta information extracted from the WSDL
 * - type: tns:ParameterDictionaryInfo
 * @subpackage Structs
 */
class ParameterDictionaryInfo extends AbstractStructBase
{
    /**
     * The DictionaryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DictionaryCode;
    /**
     * The ParameterCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ParameterCode;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * Constructor method for ParameterDictionaryInfo
     * @uses ParameterDictionaryInfo::setDictionaryCode()
     * @uses ParameterDictionaryInfo::setParameterCode()
     * @uses ParameterDictionaryInfo::setValue()
     * @param string $dictionaryCode
     * @param string $parameterCode
     * @param string $value
     */
    public function __construct($dictionaryCode = null, $parameterCode = null, $value = null)
    {
        $this
            ->setDictionaryCode($dictionaryCode)
            ->setParameterCode($parameterCode)
            ->setValue($value);
    }
    /**
     * Get DictionaryCode value
     * @return string|null
     */
    public function getDictionaryCode()
    {
        return $this->DictionaryCode;
    }
    /**
     * Set DictionaryCode value
     * @param string $dictionaryCode
     * @return \App\Integration\Providers\Alliance3\DTO\ParameterDictionaryInfo
     */
    public function setDictionaryCode($dictionaryCode = null)
    {
        $this->DictionaryCode = $dictionaryCode;
        return $this;
    }
    /**
     * Get ParameterCode value
     * @return string|null
     */
    public function getParameterCode()
    {
        return $this->ParameterCode;
    }
    /**
     * Set ParameterCode value
     * @param string $parameterCode
     * @return \App\Integration\Providers\Alliance3\DTO\ParameterDictionaryInfo
     */
    public function setParameterCode($parameterCode = null)
    {
        $this->ParameterCode = $parameterCode;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \App\Integration\Providers\Alliance3\DTO\ParameterDictionaryInfo
     */
    public function setValue($value = null)
    {
        $this->Value = $value;
        return $this;
    }
}
