<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KoeffInfoList DTO
 * @subpackage Structs
 */
class KoeffInfoList extends AbstractStructBase
{
    /**
     * The koefficient
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\KoeffInfo[]
     */
    public $koefficient;
    /**
     * Constructor method for KoeffInfoList
     * @uses KoeffInfoList::setKoefficient()
     * @param \App\Integration\Providers\Alliance3\DTO\KoeffInfo[] $koefficient
     */
    public function __construct(array $koefficient = array())
    {
        $this
            ->setKoefficient($koefficient);
    }
    /**
     * Get koefficient value
     * @return \App\Integration\Providers\Alliance3\DTO\KoeffInfo[]|null
     */
    public function getKoefficient()
    {
        return $this->koefficient;
    }
    /**
     * Set koefficient value
     * @param \App\Integration\Providers\Alliance3\DTO\KoeffInfo[] $koefficient
     * @return \App\Integration\Providers\Alliance3\DTO\KoeffInfoList
     */
    public function setKoefficient(array $koefficient = array())
    {
        $this->koefficient = $koefficient;
        return $this;
    }
    /**
     * Add item to koefficient value
     * @throws \InvalidArgumentException
     * @param \App\Integration\Providers\Alliance3\DTO\KoeffInfo $item
     * @return \App\Integration\Providers\Alliance3\DTO\KoeffInfoList
     */
    public function addToKoefficient(\App\Integration\Providers\Alliance3\DTO\KoeffInfo $item)
    {
        $this->koefficient[] = $item;
        return $this;
    }
}
