<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPaymentURLRequest DTO
 * @subpackage Structs
 */
class GetPaymentURLRequest extends AbstractStructBase
{
    /**
     * The accID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accID;
    /**
     * The policyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policyID;
    /**
     * The paymentSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentSystem;
    /**
     * The successUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $successUrl;
    /**
     * The failUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $failUrl;
    /**
     * Constructor method for GetPaymentURLRequest
     * @uses GetPaymentURLRequest::setAccID()
     * @uses GetPaymentURLRequest::setPolicyID()
     * @uses GetPaymentURLRequest::setPaymentSystem()
     * @uses GetPaymentURLRequest::setSuccessUrl()
     * @uses GetPaymentURLRequest::setFailUrl()
     * @param string $accID
     * @param string $policyID
     * @param string $paymentSystem
     * @param string $successUrl
     * @param string $failUrl
     */
    public function __construct($accID = null, $policyID = null, $paymentSystem = null, $successUrl = null, $failUrl = null)
    {
        $this
            ->setAccID($accID)
            ->setPolicyID($policyID)
            ->setPaymentSystem($paymentSystem)
            ->setSuccessUrl($successUrl)
            ->setFailUrl($failUrl);
    }
    /**
     * Get accID value
     * @return string|null
     */
    public function getAccID()
    {
        return $this->accID;
    }
    /**
     * Set accID value
     * @param string $accID
     * @return \App\Integration\Providers\Alliance3\DTO\GetPaymentURLRequest
     */
    public function setAccID($accID = null)
    {
        $this->accID = $accID;
        return $this;
    }
    /**
     * Get policyID value
     * @return string|null
     */
    public function getPolicyID()
    {
        return $this->policyID;
    }
    /**
     * Set policyID value
     * @param string $policyID
     * @return \App\Integration\Providers\Alliance3\DTO\GetPaymentURLRequest
     */
    public function setPolicyID($policyID = null)
    {
        $this->policyID = $policyID;
        return $this;
    }
    /**
     * Get paymentSystem value
     * @return string|null
     */
    public function getPaymentSystem()
    {
        return $this->paymentSystem;
    }
    /**
     * Set paymentSystem value
     * @param string $paymentSystem
     * @return \App\Integration\Providers\Alliance3\DTO\GetPaymentURLRequest
     */
    public function setPaymentSystem($paymentSystem = null)
    {
        $this->paymentSystem = $paymentSystem;
        return $this;
    }
    /**
     * Get successUrl value
     * @return string|null
     */
    public function getSuccessUrl()
    {
        return $this->successUrl;
    }
    /**
     * Set successUrl value
     * @param string $successUrl
     * @return \App\Integration\Providers\Alliance3\DTO\GetPaymentURLRequest
     */
    public function setSuccessUrl($successUrl = null)
    {
        $this->successUrl = $successUrl;
        return $this;
    }
    /**
     * Get failUrl value
     * @return string|null
     */
    public function getFailUrl()
    {
        return $this->failUrl;
    }
    /**
     * Set failUrl value
     * @param string $failUrl
     * @return \App\Integration\Providers\Alliance3\DTO\GetPaymentURLRequest
     */
    public function setFailUrl($failUrl = null)
    {
        $this->failUrl = $failUrl;
        return $this;
    }
}
