<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FinancInformation DTO
 * @subpackage Structs
 */
class FinancInformation extends AbstractStructBase
{
    /**
     * The financInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\DirectoryElemStrInfo[]
     */
    public $financInfo;
    /**
     * Constructor method for FinancInformation
     * @uses FinancInformation::setFinancInfo()
     * @param \App\Integration\Providers\Alliance3\DTO\DirectoryElemStrInfo[] $financInfo
     */
    public function __construct(array $financInfo = array())
    {
        $this
            ->setFinancInfo($financInfo);
    }
    /**
     * Get financInfo value
     * @return \App\Integration\Providers\Alliance3\DTO\DirectoryElemStrInfo[]|null
     */
    public function getFinancInfo()
    {
        return $this->financInfo;
    }
    /**
     * Set financInfo value
     * @param \App\Integration\Providers\Alliance3\DTO\DirectoryElemStrInfo[] $financInfo
     * @return \App\Integration\Providers\Alliance3\DTO\FinancInformation
     */
    public function setFinancInfo(array $financInfo = array())
    {
        $this->financInfo = $financInfo;
        return $this;
    }
    /**
     * Add item to financInfo value
     * @throws \InvalidArgumentException
     * @param \App\Integration\Providers\Alliance3\DTO\DirectoryElemStrInfo $item
     * @return \App\Integration\Providers\Alliance3\DTO\FinancInformation
     */
    public function addToFinancInfo(\App\Integration\Providers\Alliance3\DTO\DirectoryElemStrInfo $item)
    {
        $this->financInfo[] = $item;
        return $this;
    }
}
