<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExcelDictionaryResult DTO
 * Meta information extracted from the WSDL
 * - type: tns:ExcelDictionaryResult
 * @subpackage Structs
 */
class ExcelDictionaryResult extends AbstractStructBase
{
    /**
     * The ExcelUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExcelUrl;
    /**
     * The StreamBase64
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StreamBase64;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The Zip
     * @var bool
     */
    public $Zip;
    /**
     * Constructor method for ExcelDictionaryResult
     * @uses ExcelDictionaryResult::setExcelUrl()
     * @uses ExcelDictionaryResult::setStreamBase64()
     * @uses ExcelDictionaryResult::setErrorMessage()
     * @uses ExcelDictionaryResult::setZip()
     * @param string $excelUrl
     * @param string $streamBase64
     * @param string $errorMessage
     * @param bool $zip
     */
    public function __construct($excelUrl = null, $streamBase64 = null, $errorMessage = null, $zip = null)
    {
        $this
            ->setExcelUrl($excelUrl)
            ->setStreamBase64($streamBase64)
            ->setErrorMessage($errorMessage)
            ->setZip($zip);
    }
    /**
     * Get ExcelUrl value
     * @return string|null
     */
    public function getExcelUrl()
    {
        return $this->ExcelUrl;
    }
    /**
     * Set ExcelUrl value
     * @param string $excelUrl
     * @return \App\Integration\Providers\Alliance3\DTO\ExcelDictionaryResult
     */
    public function setExcelUrl($excelUrl = null)
    {
        $this->ExcelUrl = $excelUrl;
        return $this;
    }
    /**
     * Get StreamBase64 value
     * @return string|null
     */
    public function getStreamBase64()
    {
        return $this->StreamBase64;
    }
    /**
     * Set StreamBase64 value
     * @param string $streamBase64
     * @return \App\Integration\Providers\Alliance3\DTO\ExcelDictionaryResult
     */
    public function setStreamBase64($streamBase64 = null)
    {
        $this->StreamBase64 = $streamBase64;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \App\Integration\Providers\Alliance3\DTO\ExcelDictionaryResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get Zip value
     * @return bool|null
     */
    public function getZip()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param bool $zip
     * @return \App\Integration\Providers\Alliance3\DTO\ExcelDictionaryResult
     */
    public function setZip($zip = null)
    {
        $this->Zip = $zip;
        return $this;
    }
}
