<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorWithCode DTO
 * @subpackage Structs
 */
class ErrorWithCode extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $code;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The detailMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $detailMessage;
    /**
     * Constructor method for ErrorWithCode
     * @uses ErrorWithCode::setCode()
     * @uses ErrorWithCode::setMessage()
     * @uses ErrorWithCode::setDetailMessage()
     * @param int $code
     * @param string $message
     * @param string $detailMessage
     */
    public function __construct($code = null, $message = null, $detailMessage = null)
    {
        $this
            ->setCode($code)
            ->setMessage($message)
            ->setDetailMessage($detailMessage);
    }
    /**
     * Get code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param int $code
     * @return \App\Integration\Providers\Alliance3\DTO\ErrorWithCode
     */
    public function setCode($code = null)
    {
        $this->code = $code;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \App\Integration\Providers\Alliance3\DTO\ErrorWithCode
     */
    public function setMessage($message = null)
    {
        $this->message = $message;
        return $this;
    }
    /**
     * Get detailMessage value
     * @return string|null
     */
    public function getDetailMessage()
    {
        return $this->detailMessage;
    }
    /**
     * Set detailMessage value
     * @param string $detailMessage
     * @return \App\Integration\Providers\Alliance3\DTO\ErrorWithCode
     */
    public function setDetailMessage($detailMessage = null)
    {
        $this->detailMessage = $detailMessage;
        return $this;
    }
}
