<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorList DTO
 * @subpackage Structs
 */
class ErrorList extends AbstractStructBase
{
    /**
     * The error
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\Error[]
     */
    public $error;
    /**
     * Constructor method for ErrorList
     * @uses ErrorList::setError()
     * @param \App\Integration\Providers\Alliance3\DTO\Error[] $error
     */
    public function __construct(array $error = array())
    {
        $this
            ->setError($error);
    }
    /**
     * Get error value
     * @return \App\Integration\Providers\Alliance3\DTO\Error[]|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param \App\Integration\Providers\Alliance3\DTO\Error[] $error
     * @return \App\Integration\Providers\Alliance3\DTO\ErrorList
     */
    public function setError(array $error = array())
    {
        $this->error = $error;
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param \App\Integration\Providers\Alliance3\DTO\Error $item
     * @return \App\Integration\Providers\Alliance3\DTO\ErrorList
     */
    public function addToError(\App\Integration\Providers\Alliance3\DTO\Error $item)
    {
        $this->error[] = $item;
        return $this;
    }
}
